/*
 * crc.c -- Cyclic redundancy checksum utilities
 *
 * Copyright (C) 1997 Pretty Good Privacy, Inc.
 *
 * Written by Mark H. Weaver
 *
 * $Id: crc.h,v 1.2 1997/07/04 09:59:27 colin Exp $
 */

#include <stdlib.h>	/* For size_t */

#include "util.h"	/* For word32, etc. */

word16 crc16Table[0x100];
#define AdvanceCRC16(crc,c) \
	(((crc) >> 8) ^ crc16Table[((crc) ^ (c)) & 0xFF])
word16 CalculateCRC16(word16 crc, byte const *buffer, size_t length);
word16 ReverseCRC16(word16 crc, byte b);
#define CRC16_INIT	0xffff
#define CRC16_FINAL	0xffff

word32 crc32Table[0x100];
#define AdvanceCRC32(crc,c) \
	(((crc) >> 8) ^ crc32Table[((crc) ^ (c)) & 0xFF])
word32 CalculateCRC32(word32 crc, byte const *buffer, size_t length);
word32 ReverseCRC32(word32 crc, byte b);

void InitCRC(void);

/*
 * Local Variables:
 * tab-width: 4
 * End:
 * vi: ts=4 sw=4
 * vim: si
 */
