/******************************************

  XException
  XStatus
  XFileErrorTexts


  use predefined preprocessor macros (ANSI C):
  __LINE__
  __FILE__
  for XStatus/XException

  (C) 1997 Jens von Pilgrim

  ******************************************/

#ifndef __XBASECLASSES_H__
#define __XBASECLASSES_H__

#include "XString.h"
#include "bool.h"


class _XSTRING_DECL_ XStatus
{
public:
	virtual ~XStatus();

	const XString GetStatusString() const;
	const int GetStatusCode() const;
	const long GetStatusUserdef() const;

	const XString GetFileName() const;
	const XString GetClassName() const;
	const int GetLineNo() const;

	const bool IsError() const;

protected:
	XStatus(const XString& inClassName, const XString& inFileName = "unknown");
	
	void SetStatus ( int inCode, const XString& inString, int inLineNo=-1, const XString& InFilename = "", long inUserdef=0 );
	void SetStatus ( const XStatus& );

	void SetError ( int inCode, const XString& inString, int inLineNo=-1, const XString& InFilename = "", long inUserdef=0 );
	void SetError ( bool = true);
	void SetStatusCode (int, bool=false);
	void SetStatusString ( const XString&);
	void SetStatusUserdef ( long);
	void SetStatusLineNo ( int);
	void SetFileName( const XString&);
	void ResetStatus();

private:
	int m_Code;
	long m_Userdef;
	XString m_String, m_ClassName, m_FileName;
	int m_LineNo;
	bool m_Error;

};


class _XSTRING_DECL_ XException : public XStatus
{
public:
	XException( int, const XString&, int, const XString&, long=0);
	~XException();

	const XString GetFString(bool=true) const;
};


class _XSTRING_DECL_ XOSErrorTexts
{
public:
	XOSErrorTexts();
	~XOSErrorTexts();

	static const XString GetErrorText( int ) ;

};
	


#endif
