/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: PGPsdkUILibUtils.cp,v 1.18.10.1 1998/11/12 03:21:05 heller Exp $
____________________________________________________________________________*/

#include <LowMem.h>

#include <LGAFocusBorder.h>
#include <LGrafPortView.h>
#include <LStdScrollBarImp.h>
#include <LTabGroup.h>
#include <PP_Messages.h>
#include <UAttachments.h>
#include <UDrawingState.h>
#include <UGAColorRamp.h>
#include <UEnvironment.h>
#include <UGraphicUtils.h>
#include <URegistrar.h>

// Appearance classes
#include <LCheckBox.h>
#include <LEditText.h>
#include <LIconControl.h>
#include <LPopupButton.h>
#include <LProgressBar.h>
#include <LPushButton.h>
#include <LScrollBar.h>
#include <LScrollerView.h>
#include <LStaticText.h>
#include <LTextGroupBox.h>
#include <LWindowHeader.h>

// Appearance Manager Implementations
#include <LAMControlImp.h>
#include <LAMPopupButtonImp.h>
#include <LAMPushButtonImp.h>
#include <LAMStaticTextImp.h>
#include <LAMTrackActionImp.h>
#include <LAMWindowHeaderImp.h>

// Grayscale Implementations
#include <LGACheckboxImp.h>
#include <LGAEditTextImp.h>
#include <LGAIconControlImp.h>
#include <LGAProgressBarImp.h>
#include <LGAPushButtonImp.h>
#include <LGAStaticTextImp.h>
#include <LGATextGroupBoxImp.h>
#include <LGAWindowHeaderImp.h>

#include "MacBasics.h"
#include "MacDebug.h"
#include "MacEnvirons.h"
#include "MacErrors.h"
#include "MacFiles.h"
#include "pflPrefs.h"
#include "pgpBase.h"
#include "pgpDebug.h"
#include "pgpMem.h"
#include "pgpPassphraseUtils.h"
#include "pgpUserInterface.h"
#include "PowerPlantLeaks.h"

#include "CComboError.h"
#include "CPassphraseEdit.h"
#include "CPGPAMEditTextImp.h"
#include "CPGPGAPopupButtonImp.h"
#include "CPGPModalGrafPortView.h"
#include "CPrivateKeysPopup.h"
#include "CUserIDTable.h"
#include "PGPsdkUILibUtils.h"
#include "pgpDialogs.h"
#include "pgpKeyServer.h"

static FSSpec		sLibraryFileSpec		= {0, };
static long			sLibraryFileID			= 0;
static short		sLibraryFileRefNum		= -1;
static PGPUInt32	sLibraryFileRefCount	= 0;

class CSysFileAMControlImp : public LAMControlImp
{
public:

	enum { class_ID = 'SFCI' };

					CSysFileAMControlImp(LStream *inStream = nil);
	virtual			~CSysFileAMControlImp();

protected:

	virtual void	MakeMacControl(ConstStringPtr inTitle, Int32 inRefCon);
};

CSysFileAMControlImp::CSysFileAMControlImp(LStream *inStream) :
	LAMControlImp( inStream )
{
}

CSysFileAMControlImp::~CSysFileAMControlImp(void)
{
}

	void
CSysFileAMControlImp::MakeMacControl(
	ConstStringPtr 	inTitle,
	Int32 			inRefCon)
{
	short	saveResFile;
	
	saveResFile = CurResFile();
	UseResFile( 2 );
	
	LAMControlImp::MakeMacControl( inTitle, inRefCon );
	
	UseResFile( saveResFile );
}

	static void
RegisterPowerPlantClasses(void)
{
	RegisterClass_( LBorderAttachment );
	RegisterClass_( LColorEraseAttachment );
	RegisterClass_( LGAFocusBorder );
	RegisterClass_( LGrafPortView );
	RegisterClass_( LPane );
	RegisterClass_( LTabGroup );
	RegisterClass_( LView );
	
	// Appearance classes:
	
	RegisterClass_( LCheckBox );
	RegisterClass_( LEditText );
	RegisterClass_( LIconControl );
	RegisterClass_( LPopupButton );
	RegisterClass_( LProgressBar );
	RegisterClass_( LPushButton );
	RegisterClass_( LScrollBar );
	RegisterClass_( LScrollerView );
	RegisterClass_( LStaticText );
	RegisterClass_( LTextGroupBox );
	RegisterClass_( LWindowHeader );
	
	if( HaveAppearanceMgr() )
	{
		// Register Appearance Manager implementations
		// Note: Do NOT call RegisterAppearanceClient here. That is the
		// client's responsibility.
		
		RegisterClassID_( LAMControlImp, 		LCheckBox::imp_class_ID );
		RegisterClassID_( LAMControlImp, 		LIconControl::imp_class_ID );
		RegisterClassID_( CSysFileAMControlImp, LProgressBar::imp_class_ID );
		RegisterClassID_( LAMControlImp, 		LTextGroupBox::imp_class_ID );
		RegisterClassID_( CPGPAMEditTextImp, 	LEditText::imp_class_ID );		
		RegisterClassID_( LAMPopupButtonImp,	LPopupButton::imp_class_ID );
		RegisterClassID_( LAMPushButtonImp,		LPushButton::imp_class_ID );
		RegisterClassID_( LAMStaticTextImp,		LStaticText::imp_class_ID );
		RegisterClassID_( LAMTrackActionImp, 	LScrollBar::imp_class_ID);
		RegisterClassID_( LAMWindowHeaderImp,	LWindowHeader::imp_class_ID );
	}
	else
	{
		// Register Grayscale implementations

		RegisterClassID_( LGACheckboxImp,		LCheckBox::imp_class_ID );
		RegisterClassID_( LGAEditTextImp, 		LEditText::imp_class_ID );		
		RegisterClassID_( LGAIconControlImp,	LIconControl::imp_class_ID );
		RegisterClassID_( CPGPGAPopupButtonImp,	LPopupButton::imp_class_ID );
		RegisterClassID_( LGAProgressBarImp,	LProgressBar::imp_class_ID );
		RegisterClassID_( LGAPushButtonImp,		LPushButton::imp_class_ID );
		RegisterClassID_( LGAStaticTextImp,		LStaticText::imp_class_ID );
		RegisterClassID_( LGATextGroupBoxImp,	LTextGroupBox::imp_class_ID );
		RegisterClassID_( LGAWindowHeaderImp,	LWindowHeader::imp_class_ID );
		RegisterClassID_( LStdScrollBarImp, 	LScrollBar::imp_class_ID);
	}
	
	RegisterClass_( CPGPModalGrafPortView );
	RegisterClass_( CPassphraseEdit );
	RegisterClass_( CPrivateKeysPopup );

	// LDragAndDrop leaks like a sieve. This is fixed by not using
	// the default RegisterClass behavior for those classes which
	// inherit from LDragAndDrop.
	
	URegistrar::RegisterClass( CUserIDTable::class_ID,
				(ClassCreatorFunc) CUserIDTable::CreateFromStream);
}

	static void
InitializePowerPlant(void)
{
	static Boolean	firstTime = TRUE;
	
	if( firstTime )
	{
#if PGP_DEBUG
		gDebugThrow 	= debugAction_LowLevelDebugger;
		gDebugSignal 	= debugAction_LowLevelDebugger;
#endif

		UEnvironment::InitEnvironment();
		UGraphicUtils::InitGraphicsUtilities();

		UQDGlobals::SetQDGlobals((QDGlobals*)(*((long*)::LMGetCurrentA5()) - 
				(sizeof(QDGlobals) - sizeof(GrafPtr))));
		
		MacLeaks_Suspend();

		#if USE_MAC_DEBUG_LEAKS
		{ CForceInitLPeriodical	temp; }
		#endif

		RegisterPowerPlantClasses();

		MacLeaks_Resume();
		
		LCommander::SetDefaultCommander( NULL );
		LPane::SetDefaultView( NULL );

		firstTime = FALSE;
	}
}

	OSStatus
SetLibraryFSSpec(const FSSpec *fileSpec)
{
	OSStatus	status;
	CInfoPBRec	cpb;
	
	// This routine should be called once ONLY from the library INIT routine.
	pgpAssert( sLibraryFileSpec.name[0] == 0 );
	pgpAssert( sLibraryFileID == 0 );
	
	status = FSpGetCatInfo( fileSpec, &cpb );
	if( IsntErr( status ) )
	{
		HParamBlockRec	pb;
		
		sLibraryFileSpec = *fileSpec;
		
		// Create a file ID so we can track this file later.
		
		pgpClearMemory( &pb, sizeof( pb ) );
		
		pb.fidParam.ioVRefNum	= sLibraryFileSpec.vRefNum;
		pb.fidParam.ioNamePtr	= sLibraryFileSpec.name;
		pb.fidParam.ioSrcDirID	= sLibraryFileSpec.parID;
		
		if( IsntErr( PBCreateFileIDRefSync( &pb ) ) )
		{
			sLibraryFileID = pb.fidParam.ioFileID;
		}
	}
	
	return( status );
}

	static OSStatus
GetLibraryFSSpec(FSSpec *fileSpec)
{
	OSStatus	status;
	CInfoPBRec	cpb;
	
	pgpAssertAddrValid( fileSpec, FSSpec );
	AssertSpecIsValid( &sLibraryFileSpec, "PGPGetPGPLibraryFSSpec" );
	
	status = FSpGetCatInfo( &sLibraryFileSpec, &cpb );
	if( IsErr( status ) && sLibraryFileID != 0 )
	{
		// Find the library using the file ID.
		
		HParamBlockRec	pb;
		FSSpec			specCopy;
		
		pgpClearMemory( &pb, sizeof( pb ) );
		
		specCopy = sLibraryFileSpec;
		
		pb.fidParam.ioVRefNum	= specCopy.vRefNum;
		pb.fidParam.ioNamePtr	= specCopy.name;
		pb.fidParam.ioFileID	= sLibraryFileID;
		
		status = PBResolveFileIDRefSync( &pb );
		if( IsntErr( status ) )
		{
			specCopy.parID = pb.fidParam.ioSrcDirID;
			
			status = FSpGetCatInfo( &specCopy, &cpb );
			if( IsntErr( status ) )
			{
				sLibraryFileSpec = specCopy;
			}
		}
	}

	AssertNoErr( status, "GetPGPLibFileSpec" );
	
	*fileSpec = sLibraryFileSpec;
	
	return( status );
}

	PGPError
EnterPGPsdkUILib(
	PGPContextRef context,
	PGPsdkUILibState *state)
{
	CComboError		err;
	
	(void) context;
	
	pgpAssertAddrValid( state, PGPsdkUILibState );
	
	InitializePowerPlant();

	pgpClearMemory( state, sizeof( *state ) );
	
	GetPort( &state->savedPort );
	
	state->savedResLoad 	= LMGetResLoad();
	state->savedZone		= GetZone();
	state->savedResFile		= CurResFile();
	state->savedView 		= LPane::GetDefaultView();
	state->savedCommander 	= LCommander::GetDefaultCommander();

	SetResLoad( TRUE );
	LCommander::SetDefaultCommander( NULL );
	LPane::SetDefaultView( NULL );
	
	if( sLibraryFileRefCount == 0 )
	{
		FSSpec		libraryFileSpec;
		
		/* Library not yet open */
		
		pgpAssert( sLibraryFileRefNum == -1 );
		
		err.err	= GetLibraryFSSpec( &libraryFileSpec );
		if( err.IsntError() )
		{
			sLibraryFileRefNum = FSpOpenResFile( &libraryFileSpec, fsRdPerm );
			if( sLibraryFileRefNum > 0 )
			{
				++sLibraryFileRefCount;
				UseResFile( sLibraryFileRefNum );
			}
			else
			{
				err.pgpErr = kPGPError_FileNotFound;
			}
		}
	}
	else
	{
		/* Library already open. Just increment the count */
		
		pgpAssert( sLibraryFileRefNum > 0 );
		
		++sLibraryFileRefCount;
		UseResFile( sLibraryFileRefNum );
	}
	
	return( err.ConvertToPGPError() );
}

	void
ExitPGPsdkUILib(const PGPsdkUILibState *state)
{
	pgpAssertAddrValid( state, PGPsdkUILibState );

	--sLibraryFileRefCount;
	if( sLibraryFileRefCount == 0 )
	{
		pgpAssert( sLibraryFileRefNum > 0 );
	
		CloseResFile( sLibraryFileRefNum );
		sLibraryFileRefNum = -1;
	}

	LCommander::SetDefaultCommander( state->savedCommander );
	LPane::SetDefaultView( state->savedView );

	SetPort( state->savedPort );
	SetResLoad( state->savedResLoad );
	SetZone( state->savedZone );
	UseResFile( state->savedResFile );
}

	PGPUInt32
PGPEstimatePassphraseQuality(const char *passphrase)
{
	return( pgpEstimatePassphraseQuality( passphrase ) );
}

	Boolean
HaveNetworkLib(void)
{
	return( CFM_AddressIsResolved_( PGPQueryKeyServer ) );
}

	PGPError
pgpCheckNetworklibAvailability(void)
{
	if( HaveNetworkLib() )
	{
		return( kPGPError_NoErr );
	}
	else
	{
		return( kPGPError_FeatureNotAvailable );
	}
}


