/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: PGPCollectRandomDataDialog.cp,v 1.2.12.1 1998/11/12 03:20:57 heller Exp $
____________________________________________________________________________*/

#include <URegistrar.h>

#include "pgpMem.h"

#include "CPGPRandomDataGrafPort.h"
#include "pgpDialogs.h"
#include "PGPsdkUILibUtils.h"

const ResIDT kPGPRandomDataDialogID = 4754;

	PGPError
pgpCollectRandomDataDialogPlatform(
	PGPContextRef					context,
	CPGPRandomDataDialogOptions 	*options)
{
	PGPsdkUILibState	state;
	PGPError			err;
	
	PGPValidatePtr( options );
	
	err = EnterPGPsdkUILib( context, &state );
	if( IsntPGPError( err ) )
	{
		DialogRef	theDialog;
		
		RegisterClass_( CPGPRandomDataGrafPortView );
		
		// Create standard Macintosh window and overlay PowerPlant onto it
		theDialog = CPGPRandomDataGrafPortView::CreateDialog(
							kPGPRandomDataDialogID );
		if( IsntNull( theDialog ) )
		{
			CPGPRandomDataGrafPortView	*grafPortView;
		
			grafPortView = (CPGPRandomDataGrafPortView *)
										GetWRefCon( theDialog );
			pgpAssertAddrValid( grafPortView, VoidAlign );
			
			err = grafPortView->SetOptions( context, options );
			if( IsntPGPError( err ) )
			{
				err = grafPortView->DoDialog();
			}
			
			delete( grafPortView );
			DisposeDialog( theDialog );
		}
		else
		{
			err = kPGPError_OutOfMemory;
		}
	}
		
	ExitPGPsdkUILib( &state );
	
	return( err );
}

