/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CPGPRandomDataGrafPort.h,v 1.5.10.1 1998/11/12 03:20:42 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "CPGPUIGrafPortView.h"

class CPGPRandomDataDialogOptions;
class LProgressBar;

class CPGPRandomDataGrafPortView : public CPGPUIGrafPortView
{
public:

	enum
	{
		class_ID = 'CRPV',
		
		kProgressBarPaneID	= 'Prog',
		kPromptTextPaneID	= 'cTxt'
	};

						CPGPRandomDataGrafPortView(LStream *inStream);
	virtual				~CPGPRandomDataGrafPortView();

	virtual void		DoIdle(const EventRecord &inMacEvent);
	virtual	Boolean		HandleKeyPress(const EventRecord &inKeyEvent);
	virtual void		SetDescriptor(ConstStringPtr prompt);
	PGPError			SetOptions(PGPContextRef context, 
							CPGPRandomDataDialogOptions *options);
	
protected:

	virtual void		FinishCreateSelf(void);
	
private:
	
	LProgressBar		*mProgressBar;
	PGPUInt32			mEntropyCollected;
	Point				mLastMouseLoc;
	
	const CPGPRandomDataDialogOptions 	*mOptions;
};

