/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CPGPOptionView.cp,v 1.3.12.1 1998/11/12 03:20:34 heller Exp $
____________________________________________________________________________*/

// Public includes:
#include <string.h>

#include <LTextEditView.h>
#include <UDrawingState.h>
#include <UReanimator.h>

#include "pgpMem.h"


// Private includes:
#include "CPGPOptionView.h"

CPGPOptionView::CPGPOptionView(LStream *inStream) :
					LView(inStream), LListener()
{
	mItemID 			= 0;
	mDescriptionPane	= NULL;
}

CPGPOptionView::~CPGPOptionView()
{
}

	void
CPGPOptionView::FinishCreateSelf(void)
{
	LView::FinishCreateSelf();
	
	mDescriptionPane = (LTextEditView *) FindPaneByID( kDescriptionPaneID );
	pgpAssertAddrValid( mDescriptionPane, VoidAlign );
}

	void
CPGPOptionView::SetDescription(
	const char *description)
{
	SInt16			newDescHeight;
	SDimension16	oldDescSize;
	
	pgpAssertAddrValid( description, char );
	
	mDescriptionPane->SetTextPtr( (Ptr) description,
					strlen( description ) );

	if( *description == 0 )
	{
		mDescriptionPane->Hide();
		
		newDescHeight = 0;
	}
	else
	{
		SDimension32	descImageSize;
		
		mDescriptionPane->Show();
					
		mDescriptionPane->GetImageSize( descImageSize );
		newDescHeight = descImageSize.height;
	}
	
	mDescriptionPane->GetFrameSize( oldDescSize );
	
	// Adjust the frame to account for the changed text
	ResizeFrameBy( 0, newDescHeight - oldDescSize.height, TRUE );
	ResizeImageBy( 0, newDescHeight - oldDescSize.height, TRUE );
}

	void
CPGPOptionView::ListenToMessage(
	MessageT 	inMessage,
	void 		*ioParam)
{
	(void) inMessage;
	(void) ioParam;
}

	CPGPOptionView *
CPGPOptionView::CreateOptionView(
	LView 	*inSuperView,
	ResIDT 	ppobResID)
{
	StColorPortState	mSavePort( UQDGlobals::GetCurrentPort() );
	CPGPOptionView		*optionView;
	
	SetDefaultView( inSuperView );
	
	optionView = (CPGPOptionView *) UReanimator::ReadObjects(
			'PPob', ppobResID );

	optionView->FinishCreate();
	
	OutOfFocus( NULL );
	
	return ( optionView );
}

