/*____________________________________________________________________________
	Copyright (C) 1996,1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: MacNumerics.h,v 1.8.18.1 1998/11/12 03:19:43 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "pgpBase.h"
#include "pgpTypes.h"

typedef SInt16	CRC16;
typedef SInt32	CRC32;

PGP_BEGIN_C_DECLARATIONS
#if PRAGMA_IMPORT
#pragma import on
#endif



void	BCDToDecimal(UInt32 bcdValue, UInt32 *decimalValue);

CRC16	ComputeCRC16(const void *theBytes, UInt32 numBytes);
CRC16	ContinueCRC16(const void *theBytes, UInt32 numBytes, CRC16 startCRC);

CRC32	ComputeCRC32(const void *theBytes, UInt32 numBytes);
CRC32	ContinueCRC32(const void *theBytes, UInt32 numBytes, CRC32 startCRC);



#if PRAGMA_IMPORT
#pragma import reset
#endif
PGP_END_C_DECLARATIONS