/*____________________________________________________________________________
	Copyright (C) 1997-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CMacFSWiper.h,v 1.3.12.1 1998/11/12 03:19:23 heller Exp $
____________________________________________________________________________*/

#ifndef Included_CMacFSWiper_h	/* [ */
#define Included_CMacFSWiper_h

#include "pgpMacWiping.h"

class CMacFSWiper
{
	FSSpec			mWipeSpec;
	PGPUInt64		mTotalDone;
	
protected:
	virtual OSStatus	FSWipeInternal( short refNum, UInt32 wipeLength,
								PGPUInt32 numPasses, PGPUInt32 numPatterns,
								const PGPWipingPattern patternList[],
								void *wipeBuffer, PGPSize wipeBufferLength);
								
	virtual OSStatus	FSWipe(short refNum, PGPUInt32 numPasses,
								PGPUInt32 numPatterns,
								const PGPWipingPattern patternList[],
								void *wipeBuffer, PGPSize wipeBufferLength);
					
	virtual OSStatus	FSpWipeFork(const FSSpec *spec, ForkKind whichFork,
								PGPUInt32 numPasses, PGPUInt32 numPatterns,
								const PGPWipingPattern 	patternList[],
								void *wipeBuffer, PGPSize wipeBufferLength);
				
	virtual OSStatus	FSpWipe( const FSSpec *spec,
								PGPUInt32 numPasses, PGPUInt32 numPatterns,
								const PGPWipingPattern 	patternList[],
								void *wipeBuffer, PGPSize wipeBufferLength);
	
/*____________________________________________________________________________
	To get progress while wiping, subclass and override Progress()
	Progress  is called periodically with the number of *additional* bytes
	it has done.  It doesn't tell you the total nor does it tell you
	the cumulative number.
	
	This places a burden on the client to know what the total job size is.
____________________________________________________________________________*/
	virtual OSStatus	Progress(  ConstStr255Param fileName,
								PGPUInt64 additionalDone );
	
public:
						CMacFSWiper( void );
	virtual OSStatus	FSpWipeAndDelete(const FSSpec *spec,
								PGPUInt32 numPasses, PGPUInt32 numPatterns,
								const PGPWipingPattern patternList[],
								void *wipeBuffer = NULL,
								PGPSize wipeBufferLength = 0 );
};


#endif /* ] Included_CMacFSWiper_h */


/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
