/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	
	
	$Id: CPutScrapPatcher.h,v 1.3.8.1 1998/11/12 03:10:22 heller Exp $
____________________________________________________________________________*/

#pragma once 

#include "CPatcher.h"

class CPutScrapPatcher	:	public	CPatcher {
public:
#if TARGET_RT_MAC_CFM
	enum {kProcInfo = 	kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(ResType)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(void *)))};
#else
	enum {kProcInfo = 0};
	typedef pascal long			(*PutScrapProc)(long length, ResType theType,
									void * source);
#endif
		
								CPutScrapPatcher();
	virtual						~CPutScrapPatcher();

protected:
	static CPutScrapPatcher *	sPutScrapPatcher;
	
	virtual long				NewPutScrap(long length, ResType theType,
									void * source);

	virtual long				OldPutScrap(long length, ResType theType,
									void * source);

	static pascal long			PutScrapCallback(long length, ResType theType,
									void * source);
};
