/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	
	
	$Id: PGPmenuGlobals.h,v 1.12.2.1.2.1 1998/11/12 03:08:57 heller Exp $
____________________________________________________________________________*/

#pragma once 

#include <PP_Types.h>

#include "pgpUtilities.h"

typedef struct GlobalsS {
	Boolean				disableEncrypt;
	Boolean				disableSign;
	Boolean				disableDecrypt;
	Boolean				disableVerify;
#if ! PGP_FINDERMENU
	PGPContextRef		pgpContext;
	Boolean				privateScrap;
	Boolean				useOutputDialog;
	Boolean				mungeDialogs;
#endif
	Str32				processName;
	ProcessInfoRec		processProcInfo;
	FSSpec				processSpec;
	FSSpec				plugSpec;
	MenuHandle			menuH;
	Handle				menuIconH;
	Boolean				insertMenu;
} SGlobals, * SGlobalsPtr;




class StMungeDialogs {
public:
#if PGP_FINDERMENU
				StMungeDialogs(SGlobals * inGlobals) { (void) inGlobals; }
	virtual 	~StMungeDialogs() { }
#else
				StMungeDialogs(SGlobals * inGlobals) : mGlobals(inGlobals)
					{ mGlobals->mungeDialogs = true; }
	virtual		~StMungeDialogs() { mGlobals->mungeDialogs = false; }

protected:
	SGlobals *	mGlobals;
#endif
};



const OSType		kFinderCreator						=	'MACS';

// Constants
const SInt16		MENU_PGPmenu						=	17359;
const SInt16		ICNx_PGPmenu						=	17359;

const ResIDT		STRx_Strings						=	10000;
const SInt16		kKeysNotFoundID						=	1;
const SInt16		kSignID								=	2;
const SInt16		kEncryptID							=	3;
const SInt16		kEncryptAndSignID					=	4;
const SInt16		kDecryptVerifyID					=	5;
const SInt16		kSignAsID							=	6;
const SInt16		kEncryptAsID						=	7;
const SInt16		kEncryptAndSignAsID					=	8;
const SInt16		kDecryptVerifyAsID					=	9;
const SInt16		kSignatureBadID						=	10;
const SInt16		kSignatureNotVerifiedID				=	11;
const SInt16		kBeginPGPSignedMessageID			=	12;
const SInt16		kEndPGPSignedMessageID				=	13;
const SInt16		kBeginPGPEncryptedSignedMessageID	=	14;
const SInt16		kEndPGPEncryptedSignedMessageID		=	15;
const SInt16		kAddKeysID							=	16;
const SInt16		kToolsNotFoundID					=	17;

const ResIDT		STRx_Errors							=	10001;
const SInt16		kErrorStringID						=	1;



// Menu items
const SInt16	kEncrypt					=	1;
const SInt16	kSign						=	2;
const SInt16	kEncryptAndSign				=	3;
const SInt16	kDecryptVerify				=	4;
const SInt16	kWipe						=	5;
const SInt16	kPGPkeys					=	7;
const SInt16	kPGPtools					=	8;

