/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CRecessedCaption.cp,v 1.5.8.1 1998/11/12 03:08:11 heller Exp $
____________________________________________________________________________*/
#include <UGAColorRamp.h>
#include <LCheckBox.h>
#include <UGraphicUtils.h>
#include <UDrawingState.h>
#include <UDrawingUtils.h>
#include <UAttachments.h>
#include <UTextTraits.h>

#include "CRecessedCaption.h"


	CRecessedCaption *
CRecessedCaption::CreateFromStream(
	LStream * inStream)
{
	return new CRecessedCaption(inStream);
}


CRecessedCaption::CRecessedCaption()
{
}


CRecessedCaption::CRecessedCaption(
	const CRecessedCaption & inBorderCaption)
	: LCaption(inBorderCaption)
{
}


CRecessedCaption::CRecessedCaption(
	LStream * inStream)
	: LCaption(inStream)
{
	// read the fields used to configure the border
	//inStream->ReadData(&mBackColor, sizeof(RGBColor));
}


CRecessedCaption::CRecessedCaption(
	const SPaneInfo&	inPaneInfo,
	ConstStringPtr		inString,
	ResIDT				inTextTraitsID)
	: LCaption(inPaneInfo, inString, inTextTraitsID)
{
	//mBackColor = inBackColor;
}


	void
CRecessedCaption::FinishCreateSelf()
{
}


// NOTE: this follows the philosophy of drawing the border WITHIN the
// pane boundaries it saves a lot of hassles (e.g. with clipping)
	void
CRecessedCaption::DrawSelf()
{
	Rect localFrame;
	CalcLocalFrameRect (localFrame);
	ApplyForeAndBackColors();
	DrawBackground(	localFrame);
	DrawBox(		localFrame);
	DrawText(		localFrame);
}


	void
CRecessedCaption::DrawBackground(
	const Rect & localFrame)
{
	Rect frameCopy = localFrame;
	::InsetRect(&frameCopy, 1, 1);
	::EraseRect(&frameCopy);
}


	void
CRecessedCaption::DrawBox(
	const Rect & localFrame)
{
	StColorPenState	theColorPenState;
	StDeviceLoop	theLoop (localFrame);
	::PenNormal();

	Int16				depth;
	while (theLoop.NextDepth (depth)) 
	{
		if (depth >= 8)	// 256 colours
		{
			DrawGrayBox(localFrame);
		}
		else
		{
			::PenPat(&qd.gray);
			::FrameRect(&localFrame);
			::PenPat(&qd.black);
		}
	}
}
	

	void
CRecessedCaption::DrawGrayBox(
	const Rect & localFrame)
{
	Rect frameCopy = localFrame;
	
	// top left dark edges
	::RGBForeColor (&(UGAColorRamp::GetColor(7)));
	UGraphicUtils::TopLeftSide (frameCopy, 0, 0, 1, 1);

	// bottom right light edges
	::RGBForeColor (&(UGAColorRamp::GetWhiteColor()));
	UGraphicUtils::BottomRightSide (frameCopy, 1, 1, 0, 0);
}


// this is mostly copied from LStaticText::DrawSelf
	void
CRecessedCaption::DrawText(
	const Rect & localFrame)
{
	Rect frame = localFrame;		// added
	::InsetRect(&frame, 4, 2);	// added
	frame.top--;					// added
	
	Int16	just = UTextTraits::SetPortTextTraits(mTxtrID);
	
	RGBColor	textColor;
	::GetForeColor(&textColor);
	
	ApplyForeAndBackColors();
	::RGBForeColor(&textColor);
	
	UTextDrawing::DrawWithJustification((Ptr)&mText[1], mText[0], frame, just);
}

