/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CKeyTableLabels.h,v 1.8.8.1 1998/11/12 03:08:05 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LView.h>

class CKeyTable;
class LBevelButton;

class	CKeyTableLabels	:	public LView
{
public:
	enum { class_ID = 'keyL' };

						CKeyTableLabels(LStream *inStream);
	virtual				~CKeyTableLabels();
	void				FinishCreateSelf();
	virtual void		Click(SMouseDownEvent	&inMouseDown);
	virtual void		ClickSelf(const SMouseDownEvent	&inMouseDown);
	void				AdjustCursor(
								Point				inPortPt,
								const EventRecord	&inMacEvent);

	void				SetKeyTable(CKeyTable *keyTable)
							{	mKeyTable = keyTable;	}
							
	void				NotifyScrolled(Int32 delta);
	
	void				AdjustLabelSizes();
	virtual void		ResizeFrameBy(
								Int16			inWidthDelta,
								Int16			inHeightDelta,
								Boolean			inRefresh);
private:
	Int16				FindColumnHitBy(Point loc, Boolean *outResizeZone);
	void				GetColumnRect(Int16 col, Rect &colRect);
	
	CKeyTable			*mKeyTable;
	Int32				mScrollDelta;
	
	LBevelButton		*mNameHeader,
						*mValidityHeader,
						*mTrustHeader,
						*mSizeHeader,
						*mCreationHeader,
						*mExpirationHeader,
						*mADKHeader,
						*mDescriptionHeader,
						*mKeyIDHeader,
						*mEmptyHeader;
	enum	{	
				kNameHeaderID			= 'whNa',
				kValidityHeaderID		= 'whVa',
				kTrustHeaderID			= 'whTr',
				kSizeHeaderID			= 'whSi',
				kCreationHeaderID		= 'whCr',
				kExpirationHeaderID		= 'whEx',
				kADKHeaderID			= 'whAD',
				kDescriptionHeaderID	= 'whDe',
				kKeyIDHeaderID			= 'whID',
				kEmptyHeaderID			= 'whNN'
			};
};

