/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CKeyTableLabels.cp,v 1.16.8.1 1998/11/12 03:08:04 heller Exp $
____________________________________________________________________________*/
#include <UGAColorRamp.h>
#include <UDrawingState.h>
#include <UCursor.h>
#include <LBevelButton.h>

#include "CKeyTableLabels.h"
#include "CKeyTable.h"

#define RESIZEZONESIZE		3
#define MINCOLUMNWIDTH		5
#define MINFIRSTCOLUMNWIDTH	40

CKeyTableLabels::CKeyTableLabels(LStream *inStream)
		: LView(inStream)
{
	mKeyTable		= nil;
	mScrollDelta	= 0;
}

CKeyTableLabels::~CKeyTableLabels()
{
}

	void
CKeyTableLabels::FinishCreateSelf()
{
	mNameHeader			= (LBevelButton *)FindPaneByID( kNameHeaderID );
	mValidityHeader		= (LBevelButton *)FindPaneByID( kValidityHeaderID );
	mTrustHeader		= (LBevelButton *)FindPaneByID( kTrustHeaderID );
	mSizeHeader			= (LBevelButton *)FindPaneByID( kSizeHeaderID );
	mKeyIDHeader		= (LBevelButton *)FindPaneByID( kKeyIDHeaderID );
	mCreationHeader		= (LBevelButton *)FindPaneByID( kCreationHeaderID );
	mExpirationHeader	= (LBevelButton *)FindPaneByID( kExpirationHeaderID );
	mADKHeader			= (LBevelButton *)FindPaneByID( kADKHeaderID );
	mDescriptionHeader	= (LBevelButton *)FindPaneByID( kDescriptionHeaderID );
	mEmptyHeader		= (LBevelButton *)FindPaneByID( kEmptyHeaderID );
}

	void
CKeyTableLabels::AdjustCursor(
	Point				inPortPt,
	const EventRecord	&inMacEvent)
{
	Boolean				inResizeZone;
	Point				localPt;
	
	localPt = inPortPt;
	PortToLocalPoint( localPt );
	FindColumnHitBy( localPt, &inResizeZone );
	if( inResizeZone )
		UCursor::SetCross();
	else
		LPane::AdjustCursor( inPortPt, inMacEvent );
}

	Int16
CKeyTableLabels::FindColumnHitBy(Point loc, Boolean *outResizeZone)
{
	KeyTableColumnInfo	columnInfo;
	Int16				colIndex,
						pos;
	
	*outResizeZone = FALSE;
	mKeyTable->GetKeyColumnInfo(&columnInfo);
	pos = -mScrollDelta + 2;
	for(colIndex = 0; colIndex < columnInfo.numActiveColumns; colIndex++)
	{
		pos += columnInfo.columnWidths[columnInfo.columns[colIndex]];
		if(loc.h < pos)
		{
			if( pos - loc.h <= RESIZEZONESIZE )
				*outResizeZone = TRUE;
			return colIndex;
		}
	}
	return -1;
}

	void
CKeyTableLabels::GetColumnRect(Int16 col, Rect &colRect)
{
	KeyTableColumnInfo	columnInfo;
	Int16				pos,
						colIndex;
	Rect				localRect;
	
	CalcLocalFrameRect(localRect);
	mKeyTable->GetKeyColumnInfo(&columnInfo);
	pos = 0;
	for(colIndex = 0; colIndex < columnInfo.numActiveColumns; colIndex++)
	{
		if(colIndex == col)
		{
			colRect.top		= localRect.top;
			colRect.bottom	= localRect.bottom - 1;
			colRect.left	= localRect.left + pos;
			colRect.right	= colRect.left +
					columnInfo.columnWidths[columnInfo.columns[colIndex]] - 1;
			::OffsetRect(&colRect, -mScrollDelta, 0);
			break;
		}
		pos += columnInfo.columnWidths[columnInfo.columns[colIndex]];
	}
}

	void
CKeyTableLabels::Click(
	SMouseDownEvent	&inMouseDown)
{
	LPane::Click(inMouseDown);	// ignore subpane hits
}

	void
CKeyTableLabels::ClickSelf(
	const SMouseDownEvent	&inMouseDown)
{
	RgnHandle			columnRgn;
	Rect				columnRect,
						limitRect,
						slopRect,
						ktRect,
						superFrame;
	Int16				col,
						newCol;
	UInt32				dragDiff;
	Point				newPoint;
	Boolean				inResize;
	
	FocusDraw();

	mSuperView->CalcLocalFrameRect( superFrame );
	StClipRgnState	clip(superFrame);
	
	col = FindColumnHitBy( inMouseDown.whereLocal, &inResize );
	if( inResize )
	{
		Int16	startH,
				startWidth;
		
		GetColumnRect(col, columnRect);
		startH = columnRect.left;
		startWidth = columnRect.right - columnRect.left;
		CalcLocalFrameRect(limitRect);
		limitRect.left = columnRect.left + MINCOLUMNWIDTH;
		if( !col )
			limitRect.left = columnRect.left + MINFIRSTCOLUMNWIDTH;
		limitRect.right -= 16;
		slopRect = limitRect;
		::InsetRect(&slopRect, -32, -256);
		mKeyTable->CalcPortFrameRect(ktRect);
		columnRect.top ++;
		columnRect.bottom += ktRect.bottom - ktRect.top + 1;
		columnRect.right++;
		columnRect.left = columnRect.right - 2;
		columnRgn = ::NewRgn();
		::RectRgn(columnRgn, &columnRect);
		dragDiff = ::DragGrayRgn(columnRgn, inMouseDown.whereLocal,
						&limitRect, &slopRect, hAxisOnly,
						NULL);
		DisposeRgn(columnRgn);
		newPoint = inMouseDown.whereLocal;
		newPoint.h += dragDiff & 0xFFFF;
		if( newPoint.h - startH >= MINCOLUMNWIDTH &&
			newPoint.h - startH != startWidth )
		{
			mKeyTable->ResizeColumn( col, newPoint.h - startH );
			AdjustLabelSizes();
		}
	}
	else if( col > 0 )
	{
		GetColumnRect(col, columnRect);
		mKeyTable->CalcPortFrameRect(ktRect);
		columnRect.top ++;
		columnRect.bottom += ktRect.bottom - ktRect.top + 1;
		columnRect.right++;
		columnRgn = ::NewRgn();
		::RectRgn(columnRgn, &columnRect);
		CalcLocalFrameRect(limitRect);
		limitRect.right -= 16;
		slopRect = limitRect;
		::InsetRect(&slopRect, -32, -256);
		dragDiff = ::DragGrayRgn(columnRgn, inMouseDown.whereLocal,
						&limitRect, &slopRect, hAxisOnly,
						NULL);
		DisposeRgn(columnRgn);
		newPoint = inMouseDown.whereLocal;
		newPoint.h += dragDiff & 0xFFFF;
		newCol = FindColumnHitBy(newPoint, &inResize);
		if((newCol != col) && (newCol >= 0))
		{
			mKeyTable->MoveColumn(col, newCol);
			AdjustLabelSizes();
		}
	}
}

	void
CKeyTableLabels::NotifyScrolled(Int32 delta)
{
	mScrollDelta += delta;
	AdjustLabelSizes();
}

	void
CKeyTableLabels::AdjustLabelSizes()
{
	KeyTableColumnInfo	columnInfo;
	Int16				colIndex,
						endPos;
	LBevelButton		*columns[kMaxKeyTableColumnTypes],
						*thisColumn;
	Rect				colRect,
						frame;
	SDimension16		oldSize;
	
	columns[0]	=	mNameHeader;
	columns[1]	=	mValidityHeader;
	columns[2]	=	mTrustHeader;
	columns[3]	=	mSizeHeader;
	columns[4]	=	mKeyIDHeader;
	columns[5]	=	mCreationHeader;
	columns[6]	=	mExpirationHeader;
	columns[7]	=	mADKHeader;
	columns[8]	=	mDescriptionHeader;
	
	CalcLocalFrameRect( frame );
	mKeyTable->GetKeyColumnInfo(&columnInfo);
	for( colIndex = 0; colIndex < columnInfo.numActiveColumns; colIndex++ )
	{
		thisColumn = columns[columnInfo.columns[colIndex]];
		columns[columnInfo.columns[colIndex]] = NULL;
		GetColumnRect( colIndex, colRect );
		if( colRect.right > frame.right - 16 )
			colRect.right = frame.right - 16;
		thisColumn->GetFrameSize( oldSize );
		thisColumn->PlaceInSuperFrameAt( colRect.left, 0, true );
		thisColumn->ResizeFrameTo( colRect.right - colRect.left + 1,
									oldSize.height, true );
		thisColumn->Show();
		endPos = colRect.right;
	}
	for( colIndex = 0; colIndex < kMaxKeyTableColumnTypes; colIndex++ )
	{
		if( columns[colIndex] )
			columns[colIndex]->Hide();
	}
	mEmptyHeader->PlaceInSuperFrameAt( endPos, 0, true );
	mEmptyHeader->ResizeFrameTo( frame.right - endPos,
								oldSize.height, true );
}

	void
CKeyTableLabels::ResizeFrameBy(
	Int16		inWidthDelta,
	Int16		inHeightDelta,
	Boolean		inRefresh)
{
	LView::ResizeFrameBy(inWidthDelta, inHeightDelta, inRefresh);
	
	AdjustLabelSizes();
}

