/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	
	
	$Id: CReconstitutionDialog.h,v 1.16.8.1 1998/11/12 03:07:15 heller Exp $
____________________________________________________________________________*/

#pragma once 

#include <LPeriodical.h>

#include "CPGPModalGrafPortView.h"
#include "CShareholderList.h"
#include "pgpSKEP.h"
#include "pgpClientPrefs.h"



class CReconstitutionDialog :	public CPGPModalGrafPortView,
								public LPeriodical {
public:
	enum					{ class_ID = 'RstD' };

							CReconstitutionDialog(LStream * inStream);
	virtual					~CReconstitutionDialog();

	virtual void			FinishCreateSelf(void);
	virtual MessageT		HandleMessage(MessageT theMessage);
	virtual void			SpendTime(const EventRecord & inMacEvent);
	
	PGPError				SetInfo(PGPKeyRef inKeyToCollect,
								PGPKeySetRef inKeySet,
								PGPtlsContextRef inTLSContext,
								PGPByte ** outPassKey,
								PGPSize * outPassKeySize);
							
	virtual void			ListenToMessage(MessageT inMessage,
								void *ioParam);

protected:
	PGPKeyRef				mKeyToCollect;
	PGPKeySetRef			mKeySet;
	PGPtlsContextRef		mTLSContext;
	PGPByte **				mPassKey;
	PGPSize *				mPassKeySize;
	PGPPrefRef				mPrefRef;
	CShareholderList *		mShareholderList;
	PGPContextRef			mContext;
	PGPKeyID				mKeyToCollectKeyID;
	PGPShareRef				mShares;
	PGPPublicKeyAlgorithm	mAlgorithm;
	PGPInt32				mSharesCollected;
	PGPInt32				mSharesNeeded;
	PGPBoolean				mExitSKEP;
	PGPBoolean				mSKEPActive;
	PGPKeyRef				mSKEPKey;
	char *					mSKEPPassphrase;
	MessageT				mDeferredDismissMessage;
	
	PGPError				CollectFileShares(void);
	PGPError				CollectNetworkShares(void);
	static PGPError			AddShares(CReconstitutionDialog * inDialog,
								char * inUserID, PGPShareRef * inShares);
								
	PGPError				CheckForNonSplitPrivateKey(void);
	
	void					ShowError(PGPError inErr);

	static PGPError			SKEPEventHandler(PGPskepRef inSKEP,
								PGPskepEvent * inEvent,
								PGPUserValue inUserValue);
	static PGPError			DecryptSharesHandler(PGPContextRef inContext,
								PGPEvent * inEvent,
								void * inUserValue);
};