/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CTestDrive.h,v 1.3.8.1 1998/11/12 03:06:25 heller Exp $
____________________________________________________________________________*/

#pragma once

#if PGP_DEBUG	// [


typedef struct TestDriveConfiguration
{
	Str255	testName;
	short	vRefNum;
	
	ushort	numDriverReadTasks;
	ulong	minDriverReadBlocks;
	ulong	maxDriverReadBlocks;
	
	ushort	numDriverWriteTasks;
	ulong	minDriverWriteBlocks;
	ulong	maxDriverWriteBlocks;

	ushort	numFMReadTasks;
	ulong	minFMReadBytes;
	ulong	maxFMReadBytes;

	ushort	numFMWriteTasks;
	ulong	minFMWriteBytes;
	ulong	maxFMWriteBytes;
	
} TestDriveConfiguration;


class CInterruptLevelTestMgr;
class CSyncFileTester;
	
class CTestDrive
	{
protected:
	CInterruptLevelTestMgr *	mInterruptTestMgr;
	CSyncFileTester *			mSyncTester;
	
	TestDriveConfiguration		mTestConfiguration;
	
	short				mTestFileRefNum;
	FSSpec				mTestSpec;
	
	virtual void	StartInterruptDrivenTest( void );
	virtual void	StopInterruptDrivenTest( void );
	
	OSErr			AllocateSpaceToTestFile( short fileRefNum );
	OSErr			CreateAndOpenTestFile( short vRefNum, FSSpec *testSpec,
						short * fileRefNum);

	void			SpecialDriverTest( void );
	void			IdleConsumeStack( void );
public:
						CTestDrive( );
	virtual				~CTestDrive( );
	
	virtual void		Idle( void );
	virtual OSStatus	Run( const TestDriveConfiguration *config );
	virtual void		Stop( void );
	};


#endif	// ]