/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CPBQueue.h,v 1.2.8.1 1998/11/12 03:05:42 heller Exp $
____________________________________________________________________________*/

#pragma once

#include <stddef.h>

#include "CMacQueue.h"


class CPBQueue
	{
protected:
	CMacQueue		mAvailableQueue;
	CMacQueue		mInProgressQueue;
	
	typedef struct
		{
		CPBQueue *	thisObject;
		QElem		inProgressElem;
		QElem		availableElem;
		uchar		pbBytes[ ];
		} QueuePB;
		

	typedef struct CommonPBHeader
		{
		QElemPtr						qLink;
		short							qType;
		short							ioTrap;
		Ptr								ioCmdAddr;
		IOCompletionUPP					ioCompletion;
		OSErr							ioResult;
		StringPtr						ioNamePtr;
		} CommonPBHeader;
	
	static CommonPBHeader *	QueuePBToCommonPBHeader( QueuePB *pb )
								{ return( (CommonPBHeader *)
										&pb->pbBytes[ 0 ] ); }

	static QueuePB *	PBToQueuePB( const void *pb )
							{ return( (QueuePB *)((Ptr)pb -
									offsetof( QueuePB, pbBytes )) ); }

	static QueuePB *	AvailableElemToQueuePB( const QElem *elem )
							{	return( (QueuePB *)((Ptr)elem -
									offsetof( QueuePB, availableElem )) );	}



	static pascal void		sCompletionHook( void );
	
	virtual ulong			GetPBSize( void ) = 0;
	virtual QueuePB *		GetPB( void );
	virtual OSErr			ReleasePB( QueuePB *pb );
	
	virtual void			Completion( QueuePB *pb )
								{ ReleasePB( pb ); }
	
public:
						CPBQueue( void );
	virtual				~CPBQueue( void );
	};