/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CPreferencesDialog.cp,v 1.7.8.1 1998/11/12 03:05:16 heller Exp $
____________________________________________________________________________*/

#include <LCheckBox.h>
#include <LEditText.h>
#include <PP_Messages.h>
#include <UModalDialogs.h>
#include "CPGPStDialogHandler.h"

#include "pgpMem.h"
#include "PGPDisk.h"
#include "PGPDiskPreferences.h"

#include "CPreferencesDialog.h"

const short		kPGPDiskPreferenceDialogResID	= 6000;

const PaneIDT	kOKButtonPaneID					= 6001;
const PaneIDT	kCancelButtonPaneID				= 6002;
const PaneIDT	kSleepDismountCheckboxPaneID 	= 6003;
const PaneIDT	kTimedDismountCheckboxPaneID 	= 6004;
const PaneIDT	kTimedDismountEditFieldPaneID	= 6005;
const PaneIDT	kTimedDismountCaptionPaneID		= 6006;

	OSStatus
DoPreferencesDialog(void)
{
	CPGPStDialogHandler		dialogHandler( kPGPDiskPreferenceDialogResID,
									nil );
	CPreferencesDialog	*dialogObj;
	OSStatus			status;
	
	status = noErr;
	
	dialogObj = (CPreferencesDialog *) dialogHandler.GetDialog();
	if( IsNull( dialogObj ) )
	{
		pgpDebugMsg( "DoPreferencesDialog: Nil dialog object" );
		return( memFullErr );
	}
	
	dialogObj->Show();
	
	while (TRUE)
	{
		MessageT	hitMessage = dialogHandler.DoDialog();

		if( hitMessage == msg_Cancel )
		{
			status = userCanceledErr;
			break;
		}
		else if( hitMessage == msg_OK )
		{
			status = noErr;
			break;
		}
	}

	dialogObj->Hide();
	
	return( status );
}

CPreferencesDialog::CPreferencesDialog()
{
}

CPreferencesDialog::CPreferencesDialog(LStream *inStream)
	: CPGPDiskDialog(inStream)
{
}

CPreferencesDialog::~CPreferencesDialog()
{
}

	void
CPreferencesDialog::FinishCreateSelf(void)
{
	LCheckBox	*controlObj;
	LEditText	*editFieldObj;
	
	CPGPDiskDialog::FinishCreateSelf();
	
	controlObj = (LCheckBox *) FindPaneByID( kSleepDismountCheckboxPaneID );
	pgpAssertAddrValid( controlObj, VoidAlign );
	
	controlObj->SetValue(
			gPGPDiskPrefs.driverPrefs.unmountDrivesOnPBSleep ? 1 : 0 );
	
	controlObj = (LCheckBox *) FindPaneByID( kTimedDismountCheckboxPaneID );
	pgpAssertAddrValid( controlObj, VoidAlign );

	controlObj->SetValue(
			gPGPDiskPrefs.driverPrefs.unmountAfterIdleTime ? 1 : 0 );

	editFieldObj = (LEditText *) FindPaneByID( kTimedDismountEditFieldPaneID );
	pgpAssertAddrValid( editFieldObj, LEditText );
	
	editFieldObj->SetValue(
			gPGPDiskPrefs.driverPrefs.unmountIdleTimeSeconds / 60 );
}

	void
CPreferencesDialog::ListenToMessage(MessageT inMessage, void *ioParam)
{
	switch( inMessage )
	{
		case msg_OK:
		{
			LCheckBox	*controlObj;
			LEditText	*editFieldObj;
			
			// Copy the current state of the controls into our preferences
		
			controlObj =
					(LCheckBox *) FindPaneByID( kSleepDismountCheckboxPaneID );
			pgpAssertAddrValid( controlObj, VoidAlign );
			
			gPGPDiskPrefs.driverPrefs.unmountDrivesOnPBSleep =
					controlObj->GetValue() == 1;
			
			controlObj = (LCheckBox *)
					FindPaneByID( kTimedDismountCheckboxPaneID );
			pgpAssertAddrValid( controlObj, VoidAlign );

			gPGPDiskPrefs.driverPrefs.unmountAfterIdleTime =
					controlObj->GetValue() == 1;

			editFieldObj =
				(LEditText *) FindPaneByID( kTimedDismountEditFieldPaneID );
			pgpAssertAddrValid( editFieldObj, LEditText );

			gPGPDiskPrefs.driverPrefs.unmountIdleTimeSeconds =
					editFieldObj->GetValue();
			if( gPGPDiskPrefs.driverPrefs.unmountIdleTimeSeconds < 1 )
				gPGPDiskPrefs.driverPrefs.unmountIdleTimeSeconds = 1;
			
			/* convert to seconds */
			gPGPDiskPrefs.driverPrefs.unmountIdleTimeSeconds *= 60;	
			
			WritePreferences( &gPGPDiskPrefs );
			SendPreferencesToAllDrivers( &gPGPDiskPrefs.driverPrefs );
		}
		
		default:
			CPGPDiskDialog::ListenToMessage( inMessage, ioParam );
			break;

	}
}

