{--------------------------}

{ Windows frontend for PGP }

{--------------------------}

program PGPwin;

{$R pgpwin.RES}

uses WinTypes, WinProcs, Win31, ShellAPI, Strings, OWindows, ODialogs,
     Ctl3d, CommDlg, fastsort;

const

{ Control ID's }

  id_ASCII_Output      = 101;
  id_wipe_out          = 102;
  id_input_is_text     = 103;
  id_only_display      = 104;

  id_view_on_screen    = 201;
  id_recover_filename  = 202;

  id_encrypt           = 301;
  id_decrypt           = 302;
  id_sign              = 303;
  id_KeyManager        = 304;
  id_info              = 305;
  id_encrypt_clip      = 306;
  id_decrypt_clip      = 307;

  id_show_signature    = 111;
  id_output_to_file    = 112;

type

  pSortObject = ^SortObject;
  String500   = array[0..500] of char;

  pOptions    = ^tOptions;
  tOptions    = record
    ascii_out, wipe_out, input_text, only_display : boolean;
    view_screen, recover_name                     : boolean;
    show_signature, output_to_file                : boolean;
  end;

{ PGPWin dialog window object }

  PPGPWin = ^TPGPWin;
  TPGPWin = object(TDialog)
    Options                            : tOptions;
    FileIN, FileOUT, Recipient, Owner  : SortObject;
    KeyFile, KeyRing, UserID           : SortObject;
    constructor Init;
    destructor Done; virtual;
    procedure SetupWindow; virtual;
    procedure DefChildProc(var Msg: TMessage); virtual;
    procedure DefWndProc (var Msg:TMessage); virtual;
    procedure paint (PaintDC: HDC; var PaintInfo: TPaintStruct); virtual;
    procedure SetOption(OptionID:word; setflag:boolean);
    procedure encrypt (var msg:tmessage); virtual id_first+id_encrypt;
    procedure decrypt (var msg:tmessage); virtual id_first+id_decrypt;
    procedure sign (var msg:tmessage); virtual id_first+id_sign;
    procedure KeyManager (var msg:tmessage); virtual id_first+id_KeyManager;
    procedure info (var msg:tmessage); virtual id_first+id_info;
    procedure encrypt_clip (var msg:tmessage); virtual id_first+id_encrypt_clip;
    procedure decrypt_clip (var msg:tmessage); virtual id_first+id_decrypt_clip;
  end;

{ Main application object }

  TPGPWinApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

{ PGPDlg }

  pPGPDlg = ^tPGPDlg;
  tPGPDlg = object (tdialog)
    Options                        : pOptions;
    OrgOptions                     : tOptions;
    to_clip                        : boolean;
    FileIN,FileOut,Recipient,Owner : String500;
    KeyFile,KeyRing,UserID         : String500;
    constructor init (AParent: PWindowsObject; AName: PChar; AOption:pOptions);
    destructor done;virtual;
    procedure GetSetText (IDNumber:integer; tempstr:pchar; setagain:boolean);
    procedure EncloseString (s:pchar);
    procedure WMInitDialog (var msg:tmessage); virtual wm_first+wm_InitDialog;
    procedure SetOptions; virtual; { Dummy }
  end;

{ PGPEncryptDlg }

  pEncryptDlg = ^tEncryptDlg;
  tEncryptDlg = object (tPGPDlg)
    procedure DefChildProc(var Msg: TMessage); virtual;
    procedure SetOptions; virtual;
    procedure GetOptions; virtual;
  end;

{ PGPDecryptDlg }

  pDecryptDlg = ^tDecryptDlg;
  tDecryptDlg = object (tPGPDlg)
    procedure DefChildProc(var Msg: TMessage); virtual;
    procedure SetOptions; virtual;
    procedure GetOptions; virtual;
  end;

{ PGPSignDlg }

  pSignDlg = ^tSignDlg;
  tSignDlg = object (tPGPDlg)
    procedure DefChildProc(var Msg: TMessage); virtual;
  end;

{ PGPKeyDlg }

  pKeyDlg = ^tKeyDlg;
  tKeyDlg = object (tPGPDlg)
    procedure DefChildProc(var Msg: TMessage); virtual;
  end;

{ PGPEncryptClipDlg }

  pEncryptClipDlg = ^tEncryptClipDlg;
  tEncryptClipDlg = object (tPGPDlg)
    constructor init (AParent: PWindowsObject; AName: PChar; AOption:pOptions; AFileName:pchar);
    procedure DefChildProc(var Msg: TMessage); virtual;
  end;

{ Auto List Combo Box }

  pAutoCombo = ^tAutoCombo;
  tAutoCombo = object (tcombobox)
    List : SortObject;
    constructor InitResource(AParent: PWindowsObject; ResourceID: Integer; ATextLen: Word;
                            AListPtr:pSortObject);
    Procedure SetupWindow; Virtual;
    procedure UpdateList; virtual;
    procedure WMUpdate (msg:tmessage); virtual wm_user+1;
  end;

{ Drag accept edit window }

  pDragEdit = ^tDragEdit;
  tDragEdit = object (tAutoCombo)
    Procedure SetupWindow; Virtual;
    Procedure WMDropFiles(var Msg : TMessage); virtual wm_first + wm_DropFiles;
  end;

{ File browse button }

  pBrowseButton = ^tBrowseButton;
  tBrowseButton = object (tbutton)
    IDNumber    : word;
    constructor initresource (AParent:PWindowsObject; ResourceID:Integer; ID:word);
    procedure DefWndProc (var msg:tmessage); virtual;
  end;

var

{ Application instance }

  PGPWinApp: TPGPWinApp;

{ File browse button }

constructor tBrowseButton.InitResource;
begin
  inherited InitResource (AParent,ResourceID);
  IDNumber:=ID;
end;

{$F+}
function HookProc(HWindow: HWnd; Msg, wParam: word; lParam: longint): word;
var p : TFarProc;
begin
  IF Msg=wm_InitDialog then begin
    Ctl3dSubClassDlg(HWindow,Ctl3d_All);
  end;
  HookProc:=0;
end;
{$F-}

procedure tBrowseButton.DefWndProc;
var filename  : string500;
    targetwin : hwnd;

  function InClientRec(lPoint: Longint): Boolean;
  var R     : TRect;
      Point : TPoint absolute lPoint;
  begin
    GetClientRect(HWindow, R);
    InClientRec := PtInRect(R, Point);
  end;

  function GetFileName (fn:pchar):boolean;
  var Ofn : TOpenFileName;
  begin
    FN[0]:=#0;
    with Ofn do begin
      lStructSize       := sizeof(TOpenFileName);
      hwndOwner         := HWindow;
      hInstance         := HInstance;
      lpstrFilter       :='All Files (*.*)'+#0+'*.*'+#0+#0;
      lpstrCustomFilter := nil;
      nMaxCustFilter    := 0;
      nFilterIndex      := 1;
      lpstrFile         := FN;
      nMaxFile          := 500;
      lpstrFileTitle    := nil;
      nMaxFileTitle     := 0;
      lpstrInitialDir   := #0;
      lpstrTitle        := 'Select File';
      Flags             := ofn_HideReadonly or ofn_EnableHook;
      nFileOffset       := 0;
      nFileExtension    := 0;
      lpstrDefExt       := NIL;
      lpTemplateName    := 'FileOpen';
      lCustData         := 0;
      lpfnHook          := HookProc;
    end;
    GetFileName:=GetOpenFileName(Ofn);
  end;

begin
  inherited DefWndProc (msg);
  if Msg.message=wm_lbuttonup then
    if InClientRec(msg.lparam) then begin { button was clicked }
      if GetFileName(filename) then begin { file selected with OK }
        targetwin:=GetDlgItem(parent^.HWindow, IDNumber);
        if targetwin<>0 then begin
          sendmessage(targetwin,wm_settext,0,longint(@filename));
        end;
      end;
    end;
end;

{ Auto List Combo Box }

constructor tAutoCombo.InitResource;
begin
  inherited InitResource (AParent,ResourceID,ATextLen);
  List:=AListPtr^;
end;

procedure tAutoCombo.SetupWindow;
begin
  inherited SetupWindow;
  UpdateList;
end;

procedure tAutoCombo.UpdateList;
var tempstr : String500;
begin
  ClearList;
  List^.reset;
  while not List^.empty do begin
    List^.get(tempstr);
    AddString(tempstr);
  end;
end;

procedure tAutoCombo.WMUpdate;
var tempstr : string500;
    pos     : integer;
begin
  gettext(tempstr,500);
  if strlen(tempstr)=0 then exit; { nothing to update }
  pos:=list^.find(tempstr);
  if list^.sorterror then begin { string not already in list }
    list^.add(tempstr,strlen(tempstr)+1);
    list^.sort;
    UpdateList;
  end
  else begin { clear display }
    settext ('');
  end;
end;

{ Drag accept edit window }

procedure tDragEdit.SetupWindow;
begin
  inherited setupwindow;
  DragAcceptFiles(hWindow,True); { Inform Windows that we accept file drops }
end;

procedure tDragEdit.WMDropFiles;
Var NumFiles     : word;
    FileName     : array[0..255] of char;
    i            : word;
    DropPoint    : TPoint;
    InClientArea : boolean;

Begin
 { Msg.wParam contains a handle to the "drop info" }
 { First, find out how many files were dropped }
 NumFiles := DragQueryFile(Msg.wParam,$FFFF,Nil,0);
 { Next, find out where the file was dropped }
 InClientArea := DragQueryPoint(Msg.wParam,DropPoint);
 { Finally, retrieve the dropped files and call the virtual method
   "FileDropped" }
 For i := 0 to 0 do { to pred(NumFiles) if all files should be retrieved }
 Begin
   DragQueryFile(Msg.wParam,i,FileName,Pred(Sizeof(FileName)));
   Settext (Filename);
 End;
 { Cleanup - tell Windows that we're done with the "drop info" }
 DragFinish(Msg.wParam);
End {WMDropFiles};

{ PGPDlg }

constructor tPGPDlg.Init;
begin
  inherited init(aparent,aname);
  Options:=AOption;
  OrgOptions:=Options^;
  to_clip:=false;
end;

destructor tPGPDlg.Done;
begin
  Options^:=OrgOptions;
  inherited done;
end;

procedure tPGPDlg.GetSetText;
var Button      : HWnd;
begin
  Button := GetDlgItem(HWindow, IDNumber); { FileName }
  if Button <> 0 then
  begin
    SendMessage(Button, wm_gettext, 500, longint(tempstr));
    SendMessage(Button, wm_user+1,0,0);
    if setagain then SendMessage(Button, wm_settext, 0, longint(tempstr));
  end;
end;

procedure tPGPDlg.EncloseString;
var h : string500;
begin
  strcopy (h,'"');
  strcat  (h,s);
  strcat  (h,'"');
  strcopy (s,h);
end;

procedure tPGPDlg.WMInitDialog;
begin
  inherited WMInitDialog (msg);
  SetOptions;
end;

procedure tPGPDlg.SetOptions;
begin
  { sets the specific options for encryption/decryption }
end;

{ functions to copy clipboard to file and back }

function Clip_to_file (fn:pchar):boolean;
var ClipOpen : boolean;
    Handle   : tHandle;
    PCH      : PChar;
    size     : longint;
    fhandle  : integer;
    isfree   : boolean;
begin
  Clip_to_File:=false;
  ClipOpen:=OpenClipBoard(0);
  if ClipOpen then begin
    Handle:=GetClipboardData(cf_text);
    if handle=0 then begin
      CloseClipboard;
      Messagebox (0,'Clipboard must contain TEXT !','Error',0);
    end
    else begin { Text in Clipboard must be saved to disk }
      PCH:=GlobalLock(Handle);
      isfree:=false;
      if PCH<>nil then begin { Pointer is valid }
        size:=GlobalSize(Handle);
        if size>$FFFE then Messagebox (0,'to much data (max 64 KB !)','Error',0)
        else begin
          fhandle:=_lopen (fn,of_write); { create a file }
          _lwrite (fhandle,PCH,strlen(PCH));
          _lclose (fhandle);
          GlobalUnlock(Handle); CloseClipboard; isfree:=true;
          Clip_to_File:=true;
        end;
      end;
      if not isfree then begin { free memory if not already done }
        GlobalUnlock(Handle);
        CloseClipboard;
      end;
    end;
  end;
end;

Function File_to_clip (fn:pchar):boolean;
var ClipOpen : boolean;
    Handle   : tHandle;
    PCH      : PChar;
    size     : longint;
    fhandle  : integer;
    f        : file;
begin
  File_to_clip:=false;
  assign(f,strpas(fn));
  {$i-} reset (f,1); {$i+}
  if ioresult<>0 then exit;
  size:=filesize(f);
  if size>$FFFE then Messagebox (0,'to much data (max 64 KB !)','Error',0)
  else begin
    handle:=GlobalAlloc(gmem_Moveable,size+1);
    PCH:=GlobalLock(handle);
    fillchar (pch^,size+1,0);
    BlockRead (f,PCH^,size);
    ClipOpen:=OpenClipBoard(0);
    if ClipOpen then begin
      EmptyClipboard;
      SetClipboarddata (cf_text,handle);
      CloseClipboard;
      File_to_clip:=true;
    end
    else GlobalFree(handle);
    close(f);
    erase(f);
  end;
end;

{ EncryptDlg }

procedure tEncryptDlg.SetOptions;
begin
  senddlgitemmsg (301,bm_setcheck,word(options^.ascii_out),0);
  senddlgitemmsg (302,bm_setcheck,word(options^.wipe_out),0);
  senddlgitemmsg (303,bm_setcheck,word(options^.input_text),0);
  senddlgitemmsg (304,bm_setcheck,word(options^.only_display),0);
  senddlgitemmsg (305,bm_setcheck,word(to_clip),0);
end;

procedure tEncryptDlg.GetOptions;
begin
  options^.ascii_out:=boolean(senddlgitemmsg (301,bm_getcheck,0,0));
  options^.wipe_out:=boolean(senddlgitemmsg (302,bm_getcheck,0,0));
  options^.input_text:=boolean(senddlgitemmsg (303,bm_getcheck,0,0));
  options^.only_display:=boolean(senddlgitemmsg (304,bm_getcheck,0,0));
  to_clip:=boolean(senddlgitemmsg (305,bm_getcheck,0,0));
end;

procedure tEncryptDlg.DefChildProc(var Msg: TMessage);
var cmdLine : string500;
begin
  if (Msg.WParamHi = 0) and (Msg.LParamHi = bn_Clicked) and
          (Msg.WParamLo>=202) and (Msg.WParamLo<=205) then begin { action button clicked }
    GetOptions;
    GetSetText (101,FileIN,false);
    GetSetText (102,Recipient,true);
    GetSetText (103,Owner,true);
    EncloseString(Recipient);
    EncloseString(Owner);
    if strlen(FileIN)>0 then begin { Filename for encryption entered }
      strcopy (CmdLine,'PGPCLOSE.PIF -');
      with options^ do begin { use encryption options }
        if ascii_out or to_clip then strcat (CmdLine,'a');
        if wipe_out then strcat (CmdLine,'w');
        if input_text then strcat (CmdLine,'t');
        if only_display then strcat (CmdLine,'m');
      end;
      case Msg.WParamLo of
        202 : begin { normal encryption }
                strcat (CmdLine,'e ');
                strcat (CmdLine,FileIN);
                strcat (CmdLine,' ');
                strcat (CmdLine,Recipient);
              end;
        203 : begin { conventional encryption }
                strcat (CmdLine,'c ');
                strcat (CmdLine,FileIN);
              end;
        204 : begin { encrypt and sign }
                strcat (CmdLine,'es ');
                strcat (CmdLine,FileIN);
                strcat (CmdLine,' ');
                strcat (CmdLine,Recipient);
                if strlen(Owner)>0 then begin
                  strcat (CmdLine,' -u ');
                  strcat (CmdLine,Owner);
                end;
              end;
        205 : begin { non encrypted ASCII armor file }
                strcopy (CmdLine,'PGPCLOSE.PIF -a ');
                strcat (CmdLine,FileIN);
              end;
      end;
      winexec (CmdLine,sw_shownormal); { execute PGP }
      if to_clip then begin
        while findwindow(nil,'Pretty Good Privacy')=0 do yield; { wait until PGP is finished }
        while findwindow(nil,'Pretty Good Privacy')<>0 do yield; { wait until PGP is finished }
        strcopy(@FileIN[strlen(FileIn)-3],'ASC');
        File_to_clip (FileIn);
      end;
    end;
    Msg.Result:=0;
  end;
  inherited DefChildProc(Msg);
end;

{ DecryptDlg }

procedure tDecryptDlg.SetOptions;
begin
  senddlgitemmsg (301,bm_setcheck,word(options^.view_screen),0);
  senddlgitemmsg (302,bm_setcheck,word(options^.recover_name),0);
  senddlgitemmsg (303,bm_setcheck,word(to_clip),0);
end;

procedure tDecryptDlg.GetOptions;
begin
  options^.view_screen:=boolean(senddlgitemmsg (301,bm_getcheck,0,0));
  options^.recover_name:=boolean(senddlgitemmsg (302,bm_getcheck,0,0));
  to_clip:=boolean(senddlgitemmsg (303,bm_getcheck,0,0));
end;

procedure tDecryptDlg.DefChildProc(var Msg: TMessage);
var cmdLine : string500;
begin
  if (Msg.WParamHi = 0) and (Msg.LParamHi = bn_Clicked) and
          (Msg.WParamLo>=202) and (Msg.WParamLo<=203) then begin { action button clicked }
    GetOptions;
    GetSetText (101,FileIN,false);
    GetSetText (102,FileOUT,false);
    if strlen(FileIN)>0 then begin { Filename for decryption entered }
      if to_clip then strcopy(CmdLine,'PGPCLOSE.PIF') else strcopy (CmdLine,'PGP.PIF');
      with options^ do begin { use encryption options }
        if ((view_screen or recover_name) and not to_clip)
           or (Msg.WParamLo=203) then strcat (CmdLine,' -');
        if view_screen and not to_clip then strcat (CmdLine,'m');
        if recover_name and not to_clip then strcat (CmdLine,'p');
        if Msg.WParamLo=203 then strcat (CmdLine,'d');
      end;
      strcat (CmdLine,' ');
      strcat (CmdLine,FileIN);
      if (strlen(FileOUT)>0) and not to_clip then begin { output file name entered }
        strcat (CmdLine,' -o ');
        strcat (CmdLine,FileOUT);
      end;
      winexec (CmdLine,sw_shownormal); { execute PGP }
      if to_clip then begin
        while findwindow(nil,'Pretty Good Privacy')=0 do yield; { wait until PGP is finished }
        while findwindow(nil,'Pretty Good Privacy')<>0 do yield; { wait until PGP is finished }
        strcopy(@FileIN[strlen(FileIn)-3],'');
        if options^.view_screen then begin
          strcopy (CmdLine,'Notepad ');
          strcat (CmdLine,FileIn);
          winexec (CmdLine,sw_shownormal);
        end;
        File_to_clip (FileIn);
      end;
    end;
    Msg.Result:=0;
  end;
  inherited DefChildProc(Msg);
end;

{ SignDlg }

procedure tSignDlg.DefChildProc(var Msg: TMessage);
var cmdLine : string500;
begin
  if (Msg.WParamHi = 0) and (Msg.LParamHi = bn_Clicked) and
          (Msg.WParamLo>=202) and (Msg.WParamLo<=204) then begin { action button clicked }
    GetSetText (101,FileIN,false);
    GetSetText (103,Owner,true);
    EncloseString(Owner);
    if strlen(FileIN)>0 then begin { Filename for encryption entered }
      strcopy (CmdLine,'PGPCLOSE.PIF -');
      with options^do begin
        if ascii_out then strcat (CmdLine,'a');
        if input_text then strcat (CmdLine,'t');
      end;
      case Msg.WParamLo of
        202 : begin { sign file }
                strcat (CmdLine,'s ');
                strcat (CmdLine,FileIN);
                if strlen(Owner)>0 then begin
                  strcat (CmdLine,' -u ');
                  strcat (CmdLine,Owner);
                end;
              end;
        203 : begin { sign detached }
                strcat (CmdLine,'sb ');
                strcat (CmdLine,FileIN);
                if strlen(Owner)>0 then begin
                  strcat (CmdLine,' -u ');
                  strcat (CmdLine,Owner);
                end;
              end;
        204 : begin { detach signature from file }
                strcat (CmdLine,'b ');
                strcat (CmdLine,FileIN);
              end;
      end;
      winexec (CmdLine,sw_shownormal); { execute PGP }
    end;
    Msg.Result:=0;
  end;
  inherited DefChildProc(Msg);
end;

{ KeyDlg }

procedure tKeyDlg.DefChildProc(var Msg: TMessage);
var cmdLine : string500;
    isok    : boolean;
begin
  if (Msg.WParamHi = 0) and (Msg.LParamHi = bn_Clicked) and
          (Msg.WParamLo>=203) and (Msg.WParamLo<=213) then begin { action button clicked }
    GetSetText (101,KeyFile,false);
    GetSetText (102,KeyRing,false);
    GetSetText (103,UserID,true);
    EncloseString(UserID);
    isok:=true;
    strcopy (CmdLine,'PGP.PIF');
    case Msg.WParamLo of
      203 : begin { generate key }
              strcat (CmdLine,' -kg');
            end;
      204 : begin { Add key }
              strcopy (CmdLine,'PGPCLOSE.PIF -ka ');
              strcat (CmdLine,KeyFile);
              strcat (CmdLine,' ');
              strcat (CmdLine,KeyRing);
            end;
      205 : begin { Extract Key }
              if strlen(UserID)>0 then begin
                strcopy (CmdLine,'PGPCLOSE.PIF -kx ');
                strcat (CmdLine,UserID);
                strcat (CmdLine,' ');
                strcat (CmdLine,keyfile);
                strcat (CmdLine,' ');
                strcat (CmdLine,keyring);
              end else begin
                messagebox (hwindow,'User ID required','Error',0);
                isok:=false;
              end;
            end;
      206 : begin { Extract Key to ASCII }
              if strlen(UserID)>0 then begin
                strcopy (CmdLine,'PGPCLOSE.PIF -kxa ');
                strcat (CmdLine,UserID);
                strcat (CmdLine,' ');
                strcat (CmdLine,keyfile);
                strcat (CmdLine,' ');
                strcat (CmdLine,keyring);
              end else begin
                messagebox (hwindow,'User ID required','Error',0);
                isok:=false;
              end;
            end;
      207 : begin { View key }
              strcat (CmdLine,' -kv ');
              strcat (CmdLine,userID);
              strcat (CmdLine,' ');
              strcat (CmdLine,KeyRing);
            end;
      208 : begin { View Fingerprint }
              strcat (CmdLine,' -kvc ');
              strcat (CmdLine,userID);
              strcat (CmdLine,' ');
              strcat (CmdLine,KeyRing);
            end;
      209 : begin { Check Certificates }
              strcat (CmdLine,' -kc ');
              strcat (CmdLine,userID);
              strcat (CmdLine,' ');
              strcat (CmdLine,KeyRing);
            end;
      210 : begin { Edit Key }
              if strlen(UserID)>0 then begin
                strcat (CmdLine,' -ke ');
                strcat (CmdLine,UserID);
                strcat (CmdLine,' ');
                strcat (CmdLine,keyring);
              end else begin
                messagebox (hwindow,'User ID required','Error',0);
                isok:=false;
              end;
            end;
      211 : begin { Remove Key }
              if strlen(UserID)>0 then begin
                strcopy (CmdLine,'PGPCLOSE.PIF -kr ');
                strcat (CmdLine,UserID);
                strcat (CmdLine,' ');
                strcat (CmdLine,keyring);
              end else begin
                messagebox (hwindow,'User ID required','Error',0);
                isok:=false;
              end;
            end;
      212 : begin { Sign Key }
              if strlen(UserID)>0 then begin
                strcopy (CmdLine,'PGPCLOSE.PIF -ks ');
                strcat (CmdLine,UserID);
                strcat (CmdLine,' ');
                strcat (CmdLine,keyring);
              end else begin
                messagebox (hwindow,'User ID required','Error',0);
                isok:=false;
              end;
            end;
      213 : begin { Revoke Key }
              if strlen(UserID)>0 then begin
                strcopy (CmdLine,'PGPCLOSE.PIF -kd ');
                strcat (CmdLine,UserID);
              end else begin
                messagebox (hwindow,'User ID required','Error',0);
                isok:=false;
              end;
            end;
    end;
    if isok then winexec (CmdLine,sw_shownormal); { execute PGP }
    Msg.Result:=0;
  end;
  inherited DefChildProc(Msg);
end;

{ EncryptClipDlg }

constructor tEncryptClipDlg.init;
begin
  inherited init (aparent,Aname,AOption);
  strcopy(FileIN,AFileName);
end;

procedure tEncryptClipDlg.DefChildProc(var Msg: TMessage);
var cmdLine : string500;
begin
  if (Msg.WParamHi = 0) and (Msg.LParamHi = bn_Clicked) and
          (Msg.WParamLo>=202) and (Msg.WParamLo<=205) then begin { action button clicked }
    GetSetText (102,Recipient,true);
    GetSetText (103,Owner,true);
    EncloseString(Recipient);
    EncloseString(Owner);
    if (strlen(Recipient)>2) or (Msg.WParamLo=205) then begin { Recipient for encryption entered }
      strcopy (CmdLine,'PGPCLOSE.PIF -awt');
      with options^ do begin { use encryption options }
        if only_display then strcat (CmdLine,'m');
      end;
      case Msg.WParamLo of
        202 : begin { normal encryption }
                strcat (CmdLine,'e ');
                strcat (CmdLine,FileIN);
                strcat (CmdLine,' ');
                strcat (CmdLine,Recipient);
              end;
        203 : begin { conventional encryption }
                strcat (CmdLine,'c ');
                strcat (CmdLine,FileIN);
              end;
        204 : begin { encrypt and sign }
                strcat (CmdLine,'es ');
                strcat (CmdLine,FileIN);
                strcat (CmdLine,' ');
                strcat (CmdLine,Recipient);
                if strlen(Owner)>0 then begin
                  strcat (CmdLine,' -u ');
                  strcat (CmdLine,Owner);
                end;
              end;
        205 : begin { sign only }
                strcat (CmdLine,'s ');
                strcat (CmdLine,FileIN);
                strcat (CmdLine,' ');
                if strlen(Owner)>0 then begin
                  strcat (CmdLine,' -u ');
                  strcat (CmdLine,Owner);
                end;
              end;
      end;
      winexec (CmdLine,sw_shownormal); { execute PGP }
      while findwindow(nil,'Pretty Good Privacy')=0 do yield; { wait until PGP is finished }
      while findwindow(nil,'Pretty Good Privacy')<>0 do yield; { wait until PGP is finished }
      OK(msg);
    end;
    Msg.Result:=0;
  end;
  inherited DefChildProc(Msg);
end;

{ Sortrelation for sorted lists }

{$F+}
function NameSort (var x,y):boolean;
begin
  NameSort:=stricomp(string500(x),string500(y))<0;
end;
{$F-}

{ Init Window }

constructor TPGPWin.Init;

  procedure GetList (var list:sortobject; section:pchar);
  var i : integer;
      s : array[0..10] of char;
      tempstr : string500;
  begin
    for i:=1 to 100 do begin
      wvsprintf(s,'%i',i);
      getprivateprofilestring (section,s,'',tempstr,500,'PGPWin.ini');
      if strlen(tempstr)>0 then begin
        list^.add(tempstr,strlen(tempstr)+1);
      end;
    end;
    list^.sort;
  end;

begin
  inherited Init(nil, 'PGPWINDOW');
  new(FileIN,startup);    FileIN^.init(NameSort,false);     GetList (FileIN,'FileIN');
  new(FileOUT,startup);   FileOUT^.init(NameSort,false);    GetList (FileOUT,'FileOUT');
  new(Recipient,startup); Recipient^.init(NameSort,false);  GetList (Recipient,'Recipient');
  new(Owner,startup);     Owner^.init(NameSort,false);      GetList (Owner,'Owner');
  new(KeyFile,startup);   KeyFile^.init(NameSort,false);    GetList (KeyFile,'KeyFile');
  new(KeyRing,startup);   KeyRing^.init(NameSort,false);    GetList (KeyRing,'KeyRing');
  new(UserID,startup);    UserID^.init(NameSort,false);     GetList (UserID,'UserID');
end;

{ destruct window and save options }

destructor TPGPWin.Done;
type s1 = array [0..1] of char;
const outstring : array [false..true] of s1 = ('0','1');

  procedure PutList (var list:sortobject; section:pchar);
  var i : integer;
      s : array[0..10] of char;
      tempstr : string500;
  begin
    i:=0;
    list^.reset;
    while (i<100) and not list^.empty do begin
      inc(i);
      wvsprintf(s,'%i',i);
      list^.get(tempstr);
      writeprivateprofilestring (section,s,tempstr,'PGPWin.ini');
    end;
  end;

begin
  inherited Done;
  with Options do begin
    writeprivateprofilestring ('PGPWin','ascii_out',outstring[ascii_out],'PGPWin.ini');
    writeprivateprofilestring ('PGPWin','wipe_out',outstring[wipe_out],'PGPWin.ini');
    writeprivateprofilestring ('PGPWin','input_text',outstring[input_text],'PGPWin.ini');
    writeprivateprofilestring ('PGPWin','only_display',outstring[only_display],'PGPWin.ini');
    writeprivateprofilestring ('PGPWin','view_screen',outstring[view_screen],'PGPWin.ini');
    writeprivateprofilestring ('PGPWin','recover_name',outstring[recover_name],'PGPWin.ini');
    writeprivateprofilestring ('PGPWin','show_signature',outstring[show_signature],'PGPWin.ini');
    writeprivateprofilestring ('PGPWin','output_to_file',outstring[output_to_file],'PGPWin.ini');
  end;
  putlist(FileIN,'FileIN');       dispose(FileIN,clear);
  putlist(FileOUT,'FileOUT');     dispose(FileOUT,clear);
  putlist(Recipient,'Recipient'); dispose(Recipient,clear);
  putlist(Owner,'Owner');         dispose(Owner,clear);
  putlist(KeyFile,'KeyFile');     dispose(KeyFile,clear);
  putlist(KeyRing,'KeyRing');     dispose(KeyRing,clear);
  putlist(UserID,'UserID');       dispose(UserID,clear);
end;

{ properly setup the window and load default values }

procedure TPGPWin.SetupWindow;
var answer : array [0..5] of char;
begin
  inherited SetupWindow;
  with options do begin
    getprivateprofilestring ('PGPWin','ascii_out','0',answer,6,'PGPWin.ini');
    ascii_out:=boolean(abs(strcomp(answer,'0')));
    SetOption (id_ASCII_output,ascii_out);
    getprivateprofilestring ('PGPWin','wipe_out','0',answer,6,'PGPWin.ini');
    wipe_out:=boolean(abs(strcomp(answer,'0')));
    SetOption (id_wipe_out,wipe_out);
    getprivateprofilestring ('PGPWin','input_text','0',answer,6,'PGPWin.ini');
    input_text:=boolean(abs(strcomp(answer,'0')));
    SetOption (id_input_is_text,input_text);
    getprivateprofilestring ('PGPWin','only_display','0',answer,6,'PGPWin.ini');
    only_display:=boolean(abs(strcomp(answer,'0')));
    SetOption (id_only_display,only_display);
    getprivateprofilestring ('PGPWin','view_screen','0',answer,6,'PGPWin.ini');
    view_screen:=boolean(abs(strcomp(answer,'0')));
    SetOption (id_view_on_screen,view_screen);
    getprivateprofilestring ('PGPWin','recover_name','0',answer,6,'PGPWin.ini');
    recover_name:=boolean(abs(strcomp(answer,'0')));
    SetOption (id_recover_filename,recover_name);
    getprivateprofilestring ('PGPWin','show_signature','0',answer,6,'PGPWin.ini');
    show_signature:=boolean(abs(strcomp(answer,'0')));
    SetOption (id_show_signature,show_signature);
    getprivateprofilestring ('PGPWin','output_to_file','0',answer,6,'PGPWin.ini');
    output_to_file:=boolean(abs(strcomp(answer,'0')));
    SetOption (id_output_to_file,output_to_file);
  end;
end;

{ Paint the icon if the dialog is minimized }

procedure TPGPWin.Paint;
var icon             : hicon;
    whitepen,darkpen : hpen;
    oldpen           : hpen;
begin
  if isiconic(hwindow) then begin { Draw the icon in a frame }
    whitepen:=createpen(ps_solid,1,rgb(255,255,255));
    darkpen:=createpen(ps_solid,1,rgb(127,127,127));
    icon:=loadicon(hinstance,'PGPIcon');
    oldpen:=selectobject(PaintDC,WhitePen);
    moveto(PaintDC,0,34); lineto (PaintDC,0,0); lineto (PaintDC,34,0);
    moveto(PaintDC,1,33); lineto (PaintDC,1,1); lineto (PaintDC,33,1);
    selectobject(PaintDC,DarkPen);
    moveto(PaintDC,1,34); lineto (PaintDC,34,34); lineto (PaintDC,34,1);
    moveto(PaintDC,0,35); lineto (PaintDC,35,35); lineto (PaintDC,35,0);
    selectobject(PaintDC,oldpen);
    drawicon(PaintDC,2,2,icon);
    deleteobject(icon);
    deleteobject(darkpen);
    deleteobject(whitepen);
  end;
end;

procedure TPGPWin.SetOption(OptionID:word; setflag:boolean);
var
  Button: HWnd;
begin
  Button := GetDlgItem(HWindow, OptionID);
  if Button <> 0 then
  begin
    SendMessage(Button, bm_SetCheck, word(setflag), 0);
  end;
end;

{ Rather then handle each button individually with child ID
  response methods, it is possible to handle them all at
  once with the default child procedure. }

procedure TPGPWin.DefChildProc(var Msg: TMessage);
begin
  if (Msg.WParamHi = 0) and (Msg.LParamHi = bn_Clicked) then with options do begin
    case Msg.WParamLo of
      id_ASCII_Output           : begin
                                    ascii_out:=not ascii_out;
                                    SetOption (id_ASCII_output,ascii_out);
                                  end;
      id_wipe_out               : begin
                                    wipe_out:=not wipe_out;
                                    SetOption (id_wipe_out,wipe_out);
                                  end;
      id_input_is_text          : begin
                                    input_text:=not input_text;
                                    SetOption (id_input_is_text,input_text);
                                  end;
      id_only_display           : begin
                                    only_display:=not only_display;
                                    SetOption (id_only_display,only_display);
                                  end;
      id_view_on_screen         : begin
                                    view_screen:=not view_screen;
                                    SetOption (id_view_on_screen,view_screen);
                                  end;
      id_recover_filename       : begin
                                    recover_name:=not recover_name;
                                    SetOption (id_recover_filename,recover_name);
                                  end;
      id_show_signature         : begin
                                    show_signature:=not show_signature;
                                    SetOption (id_show_signature,show_signature);
                                  end;
      id_output_to_file         : begin
                                    output_to_file:=not output_to_file;
                                    SetOption (id_output_to_file,output_to_file);
                                  end;
    end; { of case }
  end;
  inherited DefChildProc(Msg);
end;

procedure TPGPWin.DefWndProc;        { realises custom painting in a dialog }
var PaintDC   : hdc;
    PaintInfo : tPaintStruct;
begin
  inherited DefWndProc (Msg);
  if (Msg.Message=wm_paint) then begin
    if isiconic(hwindow) then begin  { to avoid unnessesary calls      }
      PaintDC:=getDC(hwindow);       { as the paintig is only required }
      paint(PaintDC,PaintInfo);      { to draw the icon if the program }
      releaseDC(hwindow,PaintDC);    { is minimized                    }
    end;
  end;
end;

procedure TPGPWin.encrypt;
var dialog : pdialog;
    p      : pwindowsobject;
begin
  dialog:=new(pEncryptDlg,init(@self,'Encryption',@Options));
  p:=new(pDragEdit,initresource(dialog,101,256,@FileIN));
  p:=new(pAutoCombo,initresource(dialog,102,500,@Recipient));
  p:=new(pAutoCombo,initresource(dialog,103,500,@Owner));
  p:=new(pBrowseButton,initresource(dialog,201,101));
  application^.execdialog(dialog);
end;

procedure TPGPWin.decrypt;
var dialog : pdialog;
    p      : pwindowsobject;
begin
  dialog:=new(pDecryptDlg,init(@self,'Decryption',@Options));
  p:=new(pDragEdit,initresource(dialog,101,256,@FileIN));
  p:=new(pDragEdit,initresource(dialog,102,256,@FileOUT));
  p:=new(pBrowseButton,initresource(dialog,201,101));
  p:=new(pBrowseButton,initresource(dialog,204,102));
  application^.execdialog(dialog);
end;

procedure TPGPWin.sign;
var dialog : pdialog;
    p      : pwindowsobject;
begin
  dialog:=new(pSignDlg,init(@self,'Sign',@Options));
  p:=new(pDragEdit,initresource(dialog,101,256,@FileIN));
  p:=new(pAutoCombo,initresource(dialog,103,500,@Owner));
  p:=new(pBrowseButton,initresource(dialog,201,101));
  application^.execdialog(dialog);
end;

procedure TPGPWin.KeyManager;
var dialog : pdialog;
    p      : pwindowsobject;
begin
  dialog:=new(pKeyDlg,init(@self,'KeyManagement',@Options));
  p:=new(pDragEdit,initresource(dialog,101,256,@KeyFile));
  p:=new(pDragEdit,initresource(dialog,102,256,@KeyRing));
  p:=new(pAutoCombo,initresource(dialog,103,500,@UserID));
  p:=new(pBrowseButton,initresource(dialog,201,101));
  p:=new(pBrowseButton,initresource(dialog,202,102));
  application^.execdialog(dialog);
end;

procedure TPGPWin.Info;
var dialog : pdialog;
begin
  dialog:=new(pdialog,init(@self,'Info'));
  application^.execdialog(dialog);
end;

procedure TPGPWin.encrypt_clip;
var dialog   : pdialog;
    fn       : string500;
    p        : pwindowsobject;
    f,f2     : file;
    NewName  : array [0..180] of char;
begin
  gettempfilename(#0,'PGP',0,fn);
  if Clip_to_File (fn) then begin
    dialog:=new(pEncryptClipDlg,init(@self,'EncryptClip',@Options,FN));
    p:=new(pAutoCombo,initresource(dialog,102,500,@Recipient));
    p:=new(pAutoCombo,initresource(dialog,103,500,@Owner));
    p:=new(pBrowseButton,initresource(dialog,201,101));
    if application^.execdialog(dialog)=id_cancel then begin { delete file }
      assign(f,strpas(fn));
      {$i-} erase(f) {$i+};
    end
    else begin
      strcopy(@fn[strlen(fn)-3],'ASC');
      assign(f,strpas(fn));
      if options.output_to_file then begin { rename file to final name }
        strcopy(newname,'');
        dialog:=new(pDialog,init(@self,'renamefile'));
        p:=new(pedit,initresource(dialog,101,sizeof(newname)));
        p:=new(pBrowseButton,initresource(dialog,102,101));
        dialog^.transferbuffer:=@newname;
        if application^.execdialog(dialog)=id_ok then begin
          assign (f2,newname);
          {$i-} erase(f2); {$i+}
          {$i-} rename(f,newname); {$i+}
        end else begin
          erase(f);
        end;
      end
      else begin { read file back to clipboard }
        File_to_clip (fn);
      end;
    end;
  end;
end;

procedure TPGPWin.decrypt_clip;
var fn,Cmd     : string500;
    f,f2       : file;
    DefCommand : array [0..80] of char;
    NewName    : array [0..180] of char;
    dialog     : pdialog;
    p          : pwindowsobject;
begin
  if options.show_signature
    then strcopy(DefCommand,'PGP.PIF')
    else strcopy(DefCommand,'PGPCLOSE.PIF');
  gettempfilename(#0,'PGP',0,fn);
  if Clip_to_file (fn) then begin
    { decrypt clipboard file }
    strcopy (Cmd,DefCommand);
    strcat (Cmd,' ');
    strcat (Cmd,fn);
    winexec (Cmd,sw_shownormal); { execute PGP }
    while findwindow(nil,'Pretty Good Privacy')=0 do yield; { wait until PGP is finished }
    while findwindow(nil,'Pretty Good Privacy')<>0 do yield; { wait until PGP is finished }
    assign(f,strpas(fn));
    { delete file from disk }
    {$i-} erase(f) {$i+};
    strcopy(@fn[strlen(fn)-3],'');
    assign(f,strpas(fn));
    if options.output_to_file then begin { rename file to final name }
      strcopy(newname,'');
      dialog:=new(pDialog,init(@self,'renamefile'));
      p:=new(pedit,initresource(dialog,101,sizeof(newname)));
      p:=new(pBrowseButton,initresource(dialog,102,101));
      dialog^.transferbuffer:=@newname;
      if application^.execdialog(dialog)=id_ok then begin
        { delete existing file if nessessary }
        assign (f2,newname);
        {$i-} erase(f2); {$i+}
        {$i-} rename(f,newname); {$i+}
        if options.view_screen then begin { start notepad }
          strcopy (Cmd,'Notepad ');
          strcat (Cmd,newname);
          winexec (Cmd,sw_shownormal);
        end
        else begin
          strcopy (Cmd,'Notepad ');
          strcat (Cmd,fn);
          winexec (Cmd,sw_shownormal);
          {$i-} erase(f); {$i+}
        end;
      end
    end
    else begin { read file back to clipboard }
      if options.view_screen then begin { start notepad }
        strcopy (Cmd,'Notepad ');
        strcat (Cmd,fn);
        winexec (Cmd,sw_shownormal);
      end;
      if not File_to_clip (fn) then messagebeep(0);
    end;
  end;
end;

{ Create the application's main window. }

procedure TPGPWinApp.InitMainWindow;
begin
  MainWindow := New(PPGPWin, Init);
end;

begin
  Ctl3dRegister(HInstance);
  Ctl3dAutoSubclass(HInstance);
  PGPWinApp.Init('PGPWIN');
  PGPWinApp.Run;
  PGPWinApp.Done;
  Ctl3dUnregister(HInstance);
end.
