/* REXX Begin PGPENCOD MAIN  Version 1.2 */
/* CopyRight Lueko Willms <lueko.willms@T-Online.de>
                          <L.WILLMS@LINK-F.rhein-main.de>
*/

parse arg OutMail DEBUG PGPpassOpt 
Outmail = strip(translate(outmail))

DEBUG = (strip(translate(DEBUG)) = 'DEBUG')
TRUE = 1
FALSE = 0
PARSE SOURCE BetrSyst Shell MyName
MyDir = FILESPEC("Drive",MyName)||FILESPEC("Path",MyName)

If DEBUG then
  DO
  PARSE SOURCE BetrSyst Shell MyName
  Erg = STREAM('DEBUGS.DAT','C','OPEN WRITE')
  Erg = LINEOUT('DEBUGS.DAT',BetrSyst||' '||Shell||'::'||ADDRESS()||' '||MyName)
  Erg = STREAM('DEBUGS.DAT','C','CLOSE')
  END

/* ------------------------- Build Table of known PGP key users -------- */
'pgp -kv | RXQUEUE'
DO 4
   Call LINEIN 'QUEUE:'
END

pgpKeyUser.0 = 0
DO UNTIL QUEUED() = 1
  pgpKeyUser.0 = pgpKeyUser.0 + 1
  i = pgpKeyUser.0
  pgpKeyUser.i = TRANSLATE(SUBSTR(LINEIN('QUEUE:'),31))
  If DEBUG then
     SAY pgpKeyUser.i
END
Call LINEIN 'QUEUE:'   /* Flush the Queue */

If DEBUG then
  DO
  Say pgpKeyUser.0 ' PGP userids in your keyring/PGP Benutzer in Deinem Schlsselbund.'
  Call SAYADDRESS "pgpKeyUser"
  END


/* ------------------------ Build Table of this message's recipients ------ */

Recipient.0 = 0
From.0 = 0
Sender.0 = 0
MsgId = ''

Erg = STREAM(Outmail,'C','OPEN READ')
If DEBUG Then
  Say 'Ergebnis von OPEN ' Outmail ':' Erg


Zeile = linein(OutMail)
ContLine = FALSE
DO WHILE Length(Zeile) > 0
    /* Beachte Fortsetzungszeilen!! */
    ContLine = ContLine & (LEFT(Zeile,1) = ' ' | LEFT(Zeile,1) = '09'x)
    Zeile = STRIP(Zeile)
    If \ ContLine then
       DO
       Tag = TRANSLATE(WORD(Zeile,1))
       Zeile = Delstr(Zeile,1,Length(Tag))
       END

    If RIGHT(Zeile,1) = ',' then
       DO
       ContLine = TRUE                                 /* for the next line... */
       Zeile = DELSTR(Zeile,Length(Zeile),1)
       END

    SELECT
      When (Tag = 'TO:' | Tag = 'CC:' | Tag = 'BCC:') then
       DO
       Call GETADDRESS "Recipient" zeile
       END
      When (Tag = 'FROM:') then
        Do
        Call GETADDRESS "From" zeile
        End
      When (Tag = 'SENDER:') then
        Do
        Call GETADDRESS "Sender" zeile
        End
      When (Tag = 'MESSAGE-ID:') then
        DO
        MsgId = Zeile
        end /* do */
      Otherwise
        NOP
    END /* Switch */

    Zeile = linein(OutMail)
END /* Do Header */

Erg = STREAM(Outmail,'C','CLOSE')

If DEBUG then
  DO
  Say MyName 'Ergebnis von CLOSE ' Outmail ':' Erg
  Call SAYADDRESS "Recipient"
  Call SAYADDRESS "From"
  Call SAYADDRESS "Sender"
/*  Call SAYADDRESS "pgpKeyUser" */
  END

/* ----------- Check if we have a key for every recipient. If yes, we encrypt, otherwise only sign */
Encrypt = 1       /* 1 = TRUE */

Do i = 1 to Recipient.0 UNTIL Encrypt = 0
   ThisOne = 0
   Do j = 1 to pgpKeyUser.0 UNTIL ThisOne = 1
      ThisOne = MAX(ThisOne,POS(Recipient.i,pgpKeyUser.j))
      If DEBUG then
         SAY '??' Recipient.i '<?>' pgpKeyUser.j
   end /* do */
   Encrypt = MIN(Encrypt,ThisOne)
END

PGPreceivers = ' '
If Encrypt then
   DO
      PGPopt = 'e'
      DO i = 1 to Recipient.0
        PGPreceivers = PGPreceivers||Recipient.i||' '
      end /* do */
   END /* Encrypt = TRUE */
Else
   PGPopt = ''

/* -------------------------------------------------------- */
PGPopt = PGPopt||'s'

Signuser = '-u '
If Sender.0 > 0 then
   signuser = signuser || VALUE(Sender||'.'||Sender.0)
else
   signuser = signuser || VALUE(From||'.'||From.0)

If DEBUG then
   BugPar = 'DEBUG'
else
   BugPar = ''

MyDir'SPLTMAIL.cmd '||OutMail BugPar||' | '||MyDir||'PGPexec.CMD -fat'||PGPopt||PGPreceivers||signuser||PGPpassOpt' | '||MyDir||'joinmail.cmd '||OutMail BugPar

/* Do logging ---------------------------------------------- 
Erfolg = RC
Tab = '09'x
LogFile = MyDir||'PGPREXX.LOG'
Erg = STREAM(LogFile,'C','OPEN WRITE')
Erg = LINEOUT(LogFile,Date('O')||' '||Time()||Tab||'>>>'||Tab||MsgId||Tab||Erfolg||Tab||SignUser||Tab||PGPreceivers)
Erg = STREAM(LogFile,'C','CLOSE')
*/

If DEBUG  then
  DO
  Say 'Hallo! Gib ENTER:'
  parse pull dings
  END
exit
/* END REXX ENCODE MAIN */

/* ----- subprogram to unstring header lines and build address stem variables --- */
GETADDRESS:
parse arg tabelle hdrline
hdrline = strip(hdrline)

Anzahl = 0
Gesamtzahl = VALUE(Tabelle||'.0')
DO While Length(hdrline) > 0
   Anfang = LASTPOS(',',hdrline) + 1
   Anzahl = Anzahl + 1
   Gesamtzahl = Gesamtzahl + 1
   If DEBUG then
      Say Gesamtzahl ':' hdrline
   Erg = VALUE(Tabelle||'.0',Gesamtzahl)
   TempAddr = TRANSLATE(Strip(SUBSTR(hdrline,Anfang)))
   SpAuf = POS('<',TempAddr)                     /* search for mailbox address in line */
   SpZu  = LASTPOS('>',TempAddr)
   If ( SpAuf > 0 & SpZu > 0) then
       TempAddr = SUBSTR(TempAddr,SpAuf+1,SpZu-SpAuf-1)
   If RIGHT(TempAddr,1) = ')' then               /* Address has a comment */
      DO
      KlAuf = LASTPOS('(',TempAddr)
      TempAddr = STRIP(DELSTR(TempAddr,KlAuf))
      end /* do */
   /*                                               Adress processing complete */
   Erg = VALUE(Tabelle||'.'||Gesamtzahl,TempAddr)
   hdrline = DELSTR(hdrline,MAX(1,Anfang-1))
END /* WHILE */
RETURN Anzahl

SAYADDRESS:
/* for DEBUG purposes */
parse arg tabelle
Gesamtzahl = VALUE(Tabelle||'.0')
DO i = 1 to Gesamtzahl
   SAY tabelle':' VALUE(tabelle||'.'||i)
END
RETURN
