#include "cdemo.h"

char szUserID[256];
int iKeySize, iKeyType, iKeyExpire;
int iKeyringType;

char szWindowTitle[256], szReturnedKeyID[20];

BOOL CALLBACK KeyGenDlgProc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	char szBuf[256];
	int iResult;
	static int bMoveRadio;

	switch(msg)
	{
		case WM_INITDIALOG:
			// Set the text box limits
			SendDlgItemMessage(hwndDlg, IDE_USERID, EM_LIMITTEXT, 255, 0);
			SendDlgItemMessage(hwndDlg, IDE_KEYSIZE, EM_LIMITTEXT, 5, 0);
			SendDlgItemMessage(hwndDlg, IDE_KEYEXPIRE, EM_LIMITTEXT, 4, 0);

			// Set the initial values
			bMoveRadio = FALSE;
			SetDlgItemText(hwndDlg, IDE_KEYSIZE, "512");
			bMoveRadio = TRUE;
			SendDlgItemMessage(hwndDlg, IDR_KEYSIZE512, BM_SETCHECK, TRUE, 0);
			SendDlgItemMessage(hwndDlg, IDR_KEYTYPEDUAL, BM_SETCHECK, TRUE, 0);
			SendDlgItemMessage(hwndDlg, IDR_KEYEXPIRENEVER, BM_SETCHECK, TRUE, 0);
			SetDlgItemText(hwndDlg, IDE_KEYEXPIRE, "0");
			return TRUE;
			
		case WM_COMMAND:
			switch(wParam)
			{
				case IDOK:
					// Validate input
					iResult = GetDlgItemText(hwndDlg, IDE_USERID, szUserID, 255);
					if ((strlen(szUserID) == 0) || (iResult == 0))
					{
						MessageBox(hwndDlg, "Please specify a user ID for this key pair in the text box.", APP_TITLE, MB_OK | MB_ICONEXCLAMATION);
						SetFocus(GetDlgItem(hwndDlg, IDE_USERID));
						return TRUE;
					}
					
					iResult = GetDlgItemText(hwndDlg, IDE_KEYSIZE, szBuf, 255);
					if (iResult)
					{
						iKeySize = atoi(szBuf);
						if ((iKeySize > 2048) || (iKeySize < 384))
						{
							MessageBox(hwndDlg, "Please specify a key length between 384 and 2048 bits.", APP_TITLE, MB_OK | MB_ICONEXCLAMATION);
							SetFocus(GetDlgItem(hwndDlg, IDE_KEYSIZE));
							return TRUE;
						}
					}
					else
					{
						MessageBox(hwndDlg, "Please specify a key length between 384 and 2048 bits.", APP_TITLE, MB_OK | MB_ICONEXCLAMATION);
						SetFocus(GetDlgItem(hwndDlg, IDE_KEYSIZE));
						return TRUE;
					}
					
					if (SendDlgItemMessage(hwndDlg, IDR_KEYTYPEDUAL, BM_GETCHECK, 0, 0))
						iKeyType = KEYS_OLD;
					else
						if (SendDlgItemMessage(hwndDlg, IDR_KEYTYPEENC, BM_GETCHECK, 0, 0))
							iKeyType = KEYS_ENCR;
						else
							if (SendDlgItemMessage(hwndDlg, IDR_KEYTYPESIGN, BM_GETCHECK, 0, 0))
								iKeyType = KEYS_SIGN;
						
					
					iResult = (int)SendDlgItemMessage(hwndDlg, IDR_KEYEXPIRENEVER, BM_GETCHECK, 0, 0);
					if (!iResult)
					{
						iResult = GetDlgItemText(hwndDlg, IDE_KEYEXPIRE, szBuf, 255);
						if (iResult)
						{
							
							iKeyExpire = atoi(szBuf);
							if ((iKeyExpire > 999) || (iKeyExpire < 1))
							{
								MessageBox(hwndDlg, "Please specify a key expiration period between 1 and 999 days.", APP_TITLE, MB_OK | MB_ICONEXCLAMATION);
								SetFocus(GetDlgItem(hwndDlg, IDE_KEYEXPIRE));
								return TRUE;
							}
						}
						else
						{
							MessageBox(hwndDlg, "Please specify a key expiration period between 1 and 999 days.", APP_TITLE, MB_OK | MB_ICONEXCLAMATION);
							SetFocus(GetDlgItem(hwndDlg, IDE_KEYEXPIRE));
							return TRUE;
						}
					}
					else
						iKeyExpire = 0;
					
					EndDialog(hwndDlg, TRUE);
					return TRUE;
				
				case IDCANCEL:
					EndDialog(hwndDlg, FALSE);
					return TRUE;
					
				case IDR_KEYSIZE512:
					bMoveRadio = FALSE;
					SetDlgItemText(hwndDlg, IDE_KEYSIZE, "512");
					bMoveRadio = TRUE;
					return TRUE;
					
				case IDR_KEYSIZE1024:
					bMoveRadio = FALSE;
					SetDlgItemText(hwndDlg, IDE_KEYSIZE, "1024");
					bMoveRadio = TRUE;
					return TRUE;
					
				case IDR_KEYSIZE2048:
					bMoveRadio = FALSE;
					SetDlgItemText(hwndDlg, IDE_KEYSIZE, "2048");
					bMoveRadio = TRUE;
					return TRUE;
					
				case IDE_KEYSIZE:
					if ((HIWORD(lParam) == EN_CHANGE) && (bMoveRadio))
					{
						// Clear all the other radio buttons in this group
						SendDlgItemMessage(hwndDlg, IDR_KEYSIZE512, BM_SETCHECK, FALSE, 0);
						SendDlgItemMessage(hwndDlg, IDR_KEYSIZE1024, BM_SETCHECK, FALSE, 0);
						SendDlgItemMessage(hwndDlg, IDR_KEYSIZE2048, BM_SETCHECK, FALSE, 0);
						
						SendDlgItemMessage(hwndDlg, IDR_KEYSIZECUSTOM, BM_SETCHECK, TRUE, 0);
						return TRUE;
					}
					return FALSE;
					

				case IDR_KEYSIZECUSTOM:
					SetFocus(GetDlgItem(hwndDlg, IDE_KEYSIZE));
					return TRUE;
					
				case IDR_KEYEXPIRENEVER	:
					SetDlgItemText(hwndDlg, IDE_KEYEXPIRE, "0");
					return TRUE;

				case IDR_KEYEXPIREDAYS:
					SetFocus(GetDlgItem(hwndDlg, IDE_KEYEXPIRE));
					return TRUE;
			}
			
			default:
				return FALSE;
	}
	
	return FALSE;
}

void Do_KeyGen(HWND hWnd)
{
    char szKeyID[20], szOutBuf[1023], szTypeBuf[100], szExpireBuf[100];
    int iResult;
    
    
    if (DialogBox(hInst, MAKEINTRESOURCE(IDD_KEYGEN), GhWnd, MakeProcInstance(KeyGenDlgProc, hInst)))
    {
	    if(iResult = SimplePGPGenerateKey(hWnd, szUserID, iKeySize, iKeyType,
		    							  iKeyExpire, "", 256, "", "", szKeyID))
	    {
	    	sprintf(szOutBuf, "Simple PGP Generate Key returned error code %d.", iResult);
			MessageBox(hWnd, szOutBuf, APP_TITLE, MB_OK);
		}
	    else
		{
			switch(iKeyType)
			{
				case KEYS_OLD:
					strcpy(szTypeBuf, "dual-function");
					break;
    					
				case KEYS_ENCR:
					strcpy(szTypeBuf, "encryption-only");
					break;
    					
				case KEYS_SIGN:
					strcpy(szTypeBuf, "signature-only");
					break;
			}
    			
			if (iKeyExpire)
				sprintf(szExpireBuf, "set to expire in %d days", iKeyExpire);
			else
				sprintf(szExpireBuf, "which will never expire");
    					
			sprintf(szOutBuf, "Successfully generated a %d-bit %s key pair for user ID %s, %s.", iKeySize, szTypeBuf, szUserID, szExpireBuf);
			MessageBox(hWnd, szOutBuf, APP_TITLE, MB_OK | MB_ICONINFORMATION);
		}
    }
}

void Do_KeyExtract(HWND hWnd)
{
	// Get key
    char *SelectedList;
    HANDLE hSelectedList;
    int SelectedListLength = 4096;
    int SelectedCount = 0;
    
    int iResult;
    char szBuf[256] = {	"Armored Files (*.as?);*.as?"	};
    char szKeyFile[_MAX_PATH] = {	'\0'	};
    
    // allocate some memory for recipient list
    hSelectedList = GlobalAlloc(GPTR, (DWORD) SelectedListLength);
    if(!hSelectedList)
    {
		MessageBox(hWnd, "Insufficient Memory for this operation", APP_TITLE, MB_OK | MB_ICONSTOP);
		return;
    }
    else 
        SelectedList = GlobalLock(hSelectedList);


    /* call simple KeySel to get recipient's key */
    
    
    iResult = SimplePGPKeySel(hWnd,   
                (LPSTR) "Select Key To Extract:",
                FALSE,                   // allow multiple selection
                KEYSEL_PUBLIC,          // keyring type 
                (LPSTR) SelectedList,   // upon return will contain selected key IDs
                SelectedListLength,     // length of SelectedList buffer
                &SelectedCount,         // upon return contains number of key selected
                INCLUDE_ONLYKEYIDS,     // IncludeWhat (Key IDs, User IDs, or Both?
                (LPSTR) "",             // NUll search string displays everything
                KEYS_OLD | KEYS_ENCR
                		 | KEYS_SIGN,   // show all key types
                (LPSTR) "",             // show all keys
                FALSE,                  // start with 'narrow' formof dlg box
                KEYSEL_SHOW_GROUPS,     // show recipient groups, but do not show
                                        // expired, disabled, or revoked keys
                KEYSEL_DISABLE_SHARED_BUTTONS, // do not display shared button
                (LPSTR) "");            // use default public keyring
                
    if(iResult)
    {
        wsprintf(szBuf,"Key Selection failed, error code %d", iResult);
        MessageBox(hWnd, szBuf, APP_TITLE, MB_OK | MB_ICONSTOP);
        return;
    }
        
    if(!SelectedCount)
    {
        MessageBox(hWnd, "Operation aborted: no keys selected.", APP_TITLE, MB_OK | MB_ICONEXCLAMATION);
        return;
    }
    
    if (SelectedCount > 1)
    {
    	MessageBox(hWnd, "Only one key may be extracted at a time.", APP_TITLE, MB_OK | MB_ICONEXCLAMATION);
    	return;
    }
    
    if (FileSaveDlg(hWnd, szKeyFile, szBuf))
    {
		memmove(SelectedList, SelectedList + 1, strlen(SelectedList));
		*(SelectedList + strlen(SelectedList) - 1) = 0;
		iResult = SimplePGPExtractKey(hWnd, SelectedList, szKeyFile, "");
		if (iResult)
		{
	        sprintf(szBuf,"Simple PGP Extract Key returned error code %d.", iResult);
			MessageBox(hWnd, szBuf, APP_TITLE, MB_OK | MB_ICONEXCLAMATION);
		}
    }
        
	return;
}

void Do_KeyAdd(HWND hWnd)
{
	char szKeyFile[_MAX_PATH] = {	'\0'	};
	char szBuf[256] = {	"Armored Files (*.as?);*.as?"	};
	int iResult;
	
    if (FileOpenDlg(hWnd, szKeyFile, szBuf))
	{    
		// "Could not open keyring" is OK
		iResult = SimplePGPAddKey(hWnd, szKeyFile, "");
		if (iResult)
		{
	        sprintf(szBuf,"Simple PGP Add Key returned error code %d.", iResult);
			MessageBox(hWnd, szBuf, APP_TITLE, MB_OK | MB_ICONEXCLAMATION);
		}
    }
    
	return;
}

void Do_KeyRemove(HWND hWnd)
{
    char *SelectedList;
    HANDLE hSelectedList;
    int SelectedListLength = 4096;
    int SelectedCount = 0;
    int iResult;
    char szBuf[256];
    
    // allocate some memory for recipient list
    hSelectedList = GlobalAlloc(GPTR, (DWORD) SelectedListLength);
    if(!hSelectedList)
    {
		MessageBox(hWnd, "Insufficient Memory for this operation", APP_TITLE, MB_OK | MB_ICONSTOP);
		return;
    }
    else 
        SelectedList = GlobalLock(hSelectedList);


    /* call simple KeySel to get recipient's key */
    
    
    iResult = SimplePGPKeySel(hWnd,   
                (LPSTR) "Select Key To Remove:",
                FALSE,                   // allow multiple selection
                KEYSEL_PUBLIC,          // keyring type 
                (LPSTR) SelectedList,   // upon return will contain selected key IDs
                SelectedListLength,     // length of SelectedList buffer
                &SelectedCount,         // upon return contains number of key selected
                INCLUDE_ONLYKEYIDS,     // IncludeWhat (Key IDs, User IDs, or Both?
                (LPSTR) "",             // NUll search string displays everything
                KEYS_OLD | KEYS_ENCR
                		 | KEYS_SIGN,   // show all key types
                (LPSTR) "",             // show all keys
                FALSE,                  // start with 'narrow' formof dlg box
                KEYSEL_SHOW_GROUPS,     // show recipient groups, but do not show
                                        // expired, disabled, or revoked keys
                KEYSEL_DISABLE_SHARED_BUTTONS, // do not display shared button
                (LPSTR) "");            // use default public keyring
                
    if(iResult)
    {
        wsprintf(szBuf,"Key Selection failed, error code %d", iResult);
        MessageBox(hWnd, szBuf, APP_TITLE, MB_OK | MB_ICONSTOP);
        return;
    }
        
    if(!SelectedCount)
    {
        MessageBox(hWnd,"Operation aborted: no keys selected", APP_TITLE, MB_OK);
        return;
    }

	memmove(SelectedList, SelectedList + 1, strlen(SelectedList));
	*(SelectedList + strlen(SelectedList) - 1) = 0;
	iResult = SimplePGPRemoveKey(hWnd, SelectedList, "");
	if (iResult)
	{
        sprintf(szBuf,"Simple PGP Remove Key returned error code %d.", iResult);
		MessageBox(hWnd, szBuf, APP_TITLE, MB_OK | MB_ICONEXCLAMATION);
	}
	
	return;
}

BOOL CALLBACK KeySelDlgProc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	int iTabs[] = {	48, 68, 109, 133, 1000	};
	int iResult;
	char szUserID[256], szKeyID[20], szOldKID[20], szCreateDate[20];
	char szExpireDate[20], szKeyType[10], szKeyState[10];
	char szKeySelLine[1024], szBuf[256];
	int iKeyLen, iValidDays, iKeyType;

	switch(msg)
	{
		case WM_INITDIALOG:
			// Initialize list boxes
			SendDlgItemMessage(hwndDlg, IDL_TITLE, LB_SETTABSTOPS, 5, (LPARAM)iTabs);
			SendDlgItemMessage(hwndDlg, IDL_KEYSEL, LB_SETTABSTOPS, 5, (LPARAM)iTabs);
			SendDlgItemMessage(hwndDlg, IDL_TITLE,  LB_ADDSTRING, 0, (LPARAM)(LPSTR)"Key ID\tBits\tCreated\tType\tUser ID");
			SendMessage(hwndDlg, WM_SETTEXT, 0, (LPARAM)(LPSTR)szWindowTitle);
			
			// Open keyring and validate iKeyType
			if (iKeyringType == KEYSEL_PUBLIC)
				iResult = SimplePGPOpenPublicKeyRing(hwndDlg, "");
			else if (iKeyringType == KEYSEL_SECRET)
				iResult = SimplePGPOpenPrivateKeyRing(hwndDlg, "");
			else
			{
				MessageBox(hwndDlg, "iKeyringType is not KEYSEL_PUBLIC or KEYSEL_SECRET.", APP_TITLE, MB_OK | MB_ICONEXCLAMATION);
				EndDialog(hwndDlg, FALSE);
				return TRUE;
			}
			
			if (iResult)
			{
				sprintf(szBuf, "Could not open keyring: error code %d.", iResult);
				MessageBox(hwndDlg, szBuf, APP_TITLE, MB_OK | MB_ICONEXCLAMATION);
				EndDialog(hwndDlg, FALSE);
				return TRUE;
			}
			
			while (!iResult)
			{
				if (iKeyringType == KEYSEL_PUBLIC)
					iResult = SimplePGPGetNextPublicKey(hwndDlg,
														szUserID, 
														szKeyID,
														&iKeyLen,
														szCreateDate,
														szExpireDate,
														&iValidDays,
														&iKeyType,
														szKeyType,		// "es", "e ", or "s "
														szKeyState);           // "exp", "rev", "dis", "   " for current
				else
					iResult = SimplePGPGetNextPrivateKey(hwndDlg,
														 szUserID, 
														 szKeyID,
														 &iKeyLen,
														 szCreateDate,
														 szExpireDate,
														 &iValidDays,
														 &iKeyType,
														 szKeyType,		// "es", "e ", or "s "
														 szKeyState);           // "exp", "rev", "dis", "   " for current
				
				if (!iResult)
				{
					if (strcmp(szKeyID, szOldKID))
					{
						// New key, not just a new user ID
						strcpy(szKeySelLine, szKeyID);
						strcat(szKeySelLine, "\t");
						strcat(szKeySelLine, _itoa(iKeyLen, szBuf, 10));
						strcat(szKeySelLine, "\t");
						strcat(szKeySelLine, szCreateDate);
						strcat(szKeySelLine, "\t");
						strcat(szKeySelLine, szKeyType);
						strcat(szKeySelLine, " ");
						strcat(szKeySelLine, szKeyState);
						strcat(szKeySelLine, "\t");
						strcpy(szOldKID, szKeyID);
					}
					else
						// This one is a new user ID on the same key
						// Don't display anything but the user ID
						strcpy(szKeySelLine, "\t\t\t\t");
					
					strcat(szKeySelLine, szUserID);
					SendDlgItemMessage(hwndDlg, IDL_KEYSEL, LB_ADDSTRING, 0, (LPARAM)(LPSTR)szKeySelLine);
				}
			}

			if (iKeyringType == KEYSEL_PUBLIC)
				iResult = SimplePGPClosePublicKeyRing(hwndDlg);
			else
				iResult = SimplePGPClosePrivateKeyRing(hwndDlg);
			
			if (iResult)
			{
				sprintf(szBuf, "Error accessing keyring, code %d.", iResult);
				MessageBox(hwndDlg, szBuf, APP_TITLE, MB_OK | MB_ICONEXCLAMATION);
				EndDialog(hwndDlg, FALSE);
				return TRUE;
			}
			
			return TRUE;

		case WM_COMMAND:
			if ((wParam == IDOK) || ((LOWORD(wParam) == IDL_KEYSEL) && (HIWORD(wParam) == LBN_DBLCLK)))
			{
				iResult = (int)SendDlgItemMessage(hwndDlg, IDL_KEYSEL, LB_GETCURSEL, 0, 0L);
				
				while(iResult >= 0)
				{
					SendDlgItemMessage(hwndDlg, IDL_KEYSEL, LB_GETTEXT, iResult, (LPARAM)(LPSTR)szKeySelLine);
					if (strchr(szKeySelLine, '\t') == szKeySelLine)
						// The first character in this selection is a tab
						// This line doesn't contain a key ID
						// Decrement the index until we find a line that does
						iResult--;
					else
					{
						// This line contains a key ID
						// Put a trailing null immediately after said key ID
						// Put that key ID in the return buffer
						*strchr(szKeySelLine, '\t') = 0;
						strcpy(szReturnedKeyID, szKeySelLine);
						EndDialog(hwndDlg, TRUE);
						return TRUE;
					}
				}
				
				MessageBox(hwndDlg, "Error retrieving key ID from list box!", APP_TITLE, MB_OK | MB_ICONINFORMATION);
				EndDialog(hwndDlg, FALSE);
				return TRUE;
			}
			
			switch(wParam)
			{
				case IDCANCEL:
					EndDialog(hwndDlg, FALSE);
					return TRUE;
					
				default:
					return FALSE;
			}
			break;
		
		default:
			return FALSE;
	}
	
	return TRUE;
	
}

void Do_KeyCertify(HWND hWnd)
{
	int iResult;
	char szKey2Cert[20], szPassPhrase[256] = {	'\0'	};
	char szBuf[256];
	
	iKeyringType = KEYSEL_PUBLIC;
	strcpy(szWindowTitle, "Please select the public key you wish to certify:");
    if (DialogBox(hInst, MAKEINTRESOURCE(IDD_KEYSEL), GhWnd, MakeProcInstance(KeySelDlgProc, hInst)))
	{
		strcpy(szKey2Cert, szReturnedKeyID);
		
		// We got a public key
		// Now get the private key to certify with
		
		iKeyringType = KEYSEL_SECRET;
		strcpy(szWindowTitle, "Please select the private key you wish use to certify:");
	    if (DialogBox(hInst, MAKEINTRESOURCE(IDD_KEYSEL), GhWnd, MakeProcInstance(KeySelDlgProc, hInst)))
		{
			// We have both keys
			// Let's certify
			
			iResult = SimplePGPCertifyPublicKey(hWnd,
												szKey2Cert,
												szReturnedKeyID,
												20,
												szPassPhrase,
												256,
												"", "");
			
			if (iResult)
			{
		    	sprintf(szBuf, "Simple PGP Certify Key returned error code %d.", iResult);
				MessageBox(hWnd, szBuf, APP_TITLE, MB_OK | MB_ICONEXCLAMATION);
			}
		}
	}
	
	return;
}
