/****************************************************************************

    PROGRAM: CDemo.c

    PURPOSE: Demonstration application for ViaCrypt PGP for Windows Toolkit

****************************************************************************/

#include "cdemo.h"         /* specific to this program          */

/* Your basic WinMain..... */

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    MSG msg;                     
    HACCEL hAccel;
    
    if (!hPrevInstance)          /* Allow only one instance */
	    if (!InitApplication(hInstance))
	    {
	        MessageBox(NULL, "InitApplication Failed","",MB_OK); 
	        return (NULL);
	    }       

        
    if (!InitInstance(hInstance, nCmdShow))
    {
        MessageBox(NULL, "InitInstance Failed","",MB_OK); 
        return (NULL);
	}       
    
	hAccel = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDA_CDEMO));

    /* Message Loop */

    while (GetMessage(&msg,NULL,NULL, NULL)) 
		if (!TranslateAccelerator (GhWnd, hAccel, &msg))
	    {
			TranslateMessage(&msg);
			DispatchMessage(&msg); 
	    }

    return (msg.wParam);
}


BOOL InitApplication(HANDLE hInstance)
{
    WNDCLASS  wc;

    /* Fill in window class structure with parameters that describe the       */
    /* main window.                                                           */

    wc.style = CS_HREDRAW | CS_VREDRAW; /* Class style(s).                    */
    wc.lpfnWndProc = WndProc;           /* Function to retrieve messages for  */
                                        /* windows of this class.             */
    wc.cbClsExtra = 0;                  /* No per-class extra data.           */
    wc.cbWndExtra = 0;                  /* No per-window extra data.          */
    wc.hInstance = hInstance;           /* Application that owns the class.   */
    wc.hIcon = LoadIcon(hInstance, "MyIcon");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH) (COLOR_WINDOW +1); 
    wc.lpszMenuName =  "DEMOMENU";          /* Name of menu resource in .RC file. */
    wc.lpszClassName = "CDEMO";         /* Name used in call to CreateWindow. */

    /* Register the window class and return success/failure code. */

    return (RegisterClass(&wc));

    }

BOOL InitInstance(HANDLE hInstance, int nCmdShow)
    {
    /* Save the instance handle in static variable, which will be used in  */
    /* many subsequence calls from this application to Windows.            */

    hInst = hInstance;

    GhWnd = CreateWindow(
        "CDEMO",                        /* Class name         */
        "ViaCrypt PGP Toolkit Demo Program",                 /* Text for window title bar. */
        WS_OVERLAPPEDWINDOW,            /* Window style.         */
        CW_USEDEFAULT,                  /* initial x position   */
        CW_USEDEFAULT,                  /* initial y position   */
        CW_USEDEFAULT,                  /* initial x size */
        CW_USEDEFAULT,                  /* initial y size   */
        NULL,                           /* Parent window handle */
        NULL,                           /* Use the window class menu.         */
        hInstance,                      /* This instance owns this window.    */
        NULL                            /* Pointer not needed.                */
    );

    /* If window could not be created, return "failure" */

    if (!GhWnd)
        return (FALSE);

    /* Make the window visible; update its client area; and return "success" */

    ShowWindow(GhWnd, nCmdShow);
    UpdateWindow(GhWnd);     
    return (TRUE);

}




long FAR PASCAL _export WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
    {
    static HWND hwndEdit;
    char szBuf[256] = {	"Text Files (*.txt);*.txt"	};
    
    switch (message) 
        {
    
        case WM_CREATE:
            /* create an edit control that fills the window */
            hwndEdit = CreateWindow ("edit",NULL, WS_CHILD | WS_VISIBLE | WS_HSCROLL |
                            WS_VSCROLL | WS_BORDER | ES_LEFT | ES_MULTILINE |
                            ES_AUTOHSCROLL | ES_AUTOVSCROLL,
                            0,0,0,0,
                            hWnd,EDITCONTROLID,
                            ((LPCREATESTRUCT) lParam) -> hInstance, NULL);

			SetWindowText(hwndEdit, "This is a test...");

            OFNInit(hWnd); // initialize the OPENFILENAME structure
            bNeedSave = FALSE;
            return 0;

        case WM_SETFOCUS:
            SetFocus(hwndEdit);
            return 0;
        
        case WM_SIZE:
            MoveWindow (hwndEdit, 0,0, LOWORD (lParam), HIWORD (lParam), TRUE);
            return 0;
        
        case WM_DESTROY:
            PostQuitMessage(0);
            return 0;
        case WM_CLOSE:
            if(!bNeedSave || IDCANCEL != AskAboutSave(hWnd))
                DestroyWindow(hWnd);
               return 0;
               
        case WM_COMMAND:
        
            // see if it is a message from the edit control:
            if(LOWORD (lParam) && wParam == EDITCONTROLID)
            {
                switch (HIWORD (lParam))
                {
                    case EN_UPDATE:
                        bNeedSave = TRUE;
                        return 0;
                    case EN_ERRSPACE:
                    case EN_MAXTEXT:
                        MessageBox(hWnd, "Edit control out of space","Error", MB_OK | MB_ICONSTOP);
                        return 0;
                }
                break;
            }
                
            // now handle menu commands
            switch (wParam)
            {
                case IDM_NEW:
                    if(bNeedSave && IDCANCEL == AskAboutSave (hWnd))
                        return 0;
                    szFileName[0] = '\0';
                    SetWindowText(hwndEdit,"\0");
                    bNeedSave = FALSE;
                    return 0;
                    
                case IDM_OPEN:
                    if (bNeedSave && IDCANCEL == AskAboutSave(hWnd))
                        return 0;
                        
                    if (FileOpenDlg(hWnd, szFileName, szBuf))
                        if (!FileRead (hwndEdit, szFileName))
                        {
                            MessageBox(hWnd, "Unable to open file","Error", MB_OK | MB_ICONSTOP);
                            szFileName[0] = '\0';
                        }

                    bNeedSave = FALSE;
                    return 0;
                /* no Save command has been implemented here.  It would be easy to do so,
                   but for safety reasons, you'll probably want the encrypt, decrypt, and
                   sign funtions to reset szFileName to null in order to force the user
                   to specify a new filename after one of these operations */
                case IDM_SAVEAS:
                    if(FileSaveDlg(hWnd, szFileName, szBuf))
                        if(FileWrite (hwndEdit, szFileName))
                        {
                            bNeedSave = FALSE;
                            return 1;
                        }
                        else
                        	MessageBox(hWnd, "Unable to write file", "Error", MB_OK | MB_ICONSTOP);

                    return 0;
                        
                        
				case IDM_EXIT:
					SendMessage (hWnd, WM_CLOSE, 0,0L);
					return 0;
				                   
				case IDM_CUT:
					SendMessage (hwndEdit, WM_CUT, 0, 0L);
					return 0;
				case IDM_COPY:
					SendMessage (hwndEdit, WM_COPY, 0, 0L);
					return 0;
				case IDM_PASTE:
					SendMessage (hwndEdit, WM_PASTE, 0, 0L);
					return 0;
				case IDM_SELECTALL:
					SendMessage (hwndEdit, EM_SETSEL, (WPARAM) 1, MAKELONG(0, -1));
					return 0;
				case IDM_DELETE:
					SendMessage (hwndEdit, WM_CLEAR, 0, 0L);
					return 0;
				case IDM_ENCRYPT:
					Do_Encrypt(hWnd, hwndEdit, FALSE);
					return 0;
				case IDM_ENCSIGN:
					Do_Encrypt(hWnd, hwndEdit, TRUE);
					return 0;
				case IDM_SIGN:
					Do_Sign(hWnd, hwndEdit);
					return 0;
				case IDM_DECRYPT:
					Do_Decrypt(hWnd, hwndEdit, FALSE);
					return 0;
				case IDM_VERIFY:
					Do_Decrypt(hWnd, hwndEdit, TRUE);
					return 0;
				case IDM_GENKEY:
					Do_KeyGen(hWnd);
					return 0;
				case IDM_EXTRACT:
					Do_KeyExtract(hWnd);
					return 0;
				case IDM_ADD:
					Do_KeyAdd(hWnd);
					return 0;
				case IDM_REMOVE:
					Do_KeyRemove(hWnd);
					return 0;
				case IDM_CERTIFY:
					Do_KeyCertify(hWnd);
					return 0;
            }
            break; 
    }
    return DefWindowProc (hWnd, message, wParam, lParam);
}
