#include <stdio.h>

static unsigned char
intern2cp850[] = {  /* ISO 8859-1 Latin Alphabet 1 (Latin-1) to IBM Code Page 850 */
186, 205, 201, 187, 200, 188, 204, 185, 203, 202, 206, 223, 220, 219, 254, 242,
179, 196, 218, 191, 192, 217, 195, 180, 194, 193, 197, 176, 177, 178, 213, 159,
255, 173, 189, 156, 207, 190, 221, 245, 249, 184, 166, 174, 170, 240, 169, 238,
248, 241, 253, 252, 239, 230, 244, 250, 247, 251, 167, 175, 172, 171, 243, 168,
183, 181, 182, 199, 142, 143, 146, 128, 212, 144, 210, 211, 222, 214, 215, 216,
209, 165, 227, 224, 226, 229, 153, 158, 157, 235, 233, 234, 154, 237, 232, 225,
133, 160, 131, 198, 132, 134, 145, 135, 138, 130, 136, 137, 141, 161, 140, 139,
208, 164, 149, 162, 147, 228, 148, 246, 155, 151, 163, 150, 129, 236, 231, 152
};

static unsigned char
cp8502intern[] = {  /* IBM Code Page 850 to Latin-1 */
199, 252, 233, 226, 228, 224, 229, 231, 234, 235, 232, 239, 238, 236, 196, 197,
201, 230, 198, 244, 246, 242, 251, 249, 255, 214, 220, 248, 163, 216, 215, 159,
225, 237, 243, 250, 241, 209, 170, 186, 191, 174, 172, 189, 188, 161, 171, 187,
155, 156, 157, 144, 151, 193, 194, 192, 169, 135, 128, 131, 133, 162, 165, 147,
148, 153, 152, 150, 145, 154, 227, 195, 132, 130, 137, 136, 134, 129, 138, 164,
240, 208, 202, 203, 200, 158, 205, 206, 207, 149, 146, 141, 140, 166, 204, 139,
211, 223, 212, 210, 245, 213, 181, 254, 222, 218, 219, 217, 253, 221, 175, 180,
173, 177, 143, 190, 182, 167, 247, 184, 176, 168, 183, 185, 179, 178, 142, 160
};

main(argc, argv)
char **argv;
{
	int c;

	if (argc < 2 || strcmp(argv[1], "int") && strcmp(argv[1], "ext")) {
		fprintf(stderr, "usage: convert [int|ext] [file]\n");
		exit(1);
	}
	if (argc > 2) {
		if (freopen(argv[2], "r", stdin) == NULL) {
			perror(argv[2]);
			exit(1);
		}
	}
	if (strcmp(argv[1], "int"))
		while ((c = getchar()) != EOF)
			putchar(c & 0x80 ? intern2cp850[c&0x7f] : c);
	else
		while ((c = getchar()) != EOF)
			putchar(c & 0x80 ? cp8502intern[c&0x7f] : c);
	exit(0);
}
