#include <stdlib.h>
#include "pgpdll.h"

#define USES_STL

#define NOMINMAX

#ifdef min
#undef min
#endif

#ifdef max
#undef max
#endif


#include "XString.h"

#include <new.h>
#include <iostream.h>


// STL:
namespace std {
#include "vector.h"
}

typedef std::vector<XString> XStringVec;
typedef XSplitableString<XStringVec > XSplitStrV;


// #include "pgp.h"

extern "C" char* LANG(char* s);


extern "C" int contains_yesNo;
extern "C" int contains_enough;
extern "C" int contains_badpass;


int stdprint (FILE* stream, const char *string)
{
	return fputs(string, stream);
}


outputFunction JvP_outFct = &stdprint;
inputFunction JvP_inFct = NULL;
rndaccFunction JvP_rndaccFct = NULL;
pagerFunction JvP_pagerFct = NULL;
phreadFunction JvP_phreadFct = NULL;
phwriteFunction JvP_phwriteFct = NULL;


extern "C" int pgp_main(int argc, char *argv[]);
extern "C" unsigned trueRandEvent(int event);


int contains_yesNo;
int contains_enough;
int contains_badpass;

int WINAPI CONTAINS_YESNO()
{
	return contains_yesNo;
}

int WINAPI CONTAINS_ENOUGH()
{
	return contains_enough;
}

int WINAPI CONTAINS_BADPASS()
{
	return contains_badpass;
}





unsigned int WINAPI RANDEVENT(int event)
{
	return trueRandEvent(event);
}

DWORD WINAPI CALLPGP (  LPVOID lpThreadParm )
{
	contains_yesNo = 0;
	contains_enough = 0;
	contains_badpass = 0;
	
	pgpparameter *p = (pgpparameter *) lpThreadParm;

	JvP_outFct		= p->outFct;
	JvP_inFct		= p->inFct;
	JvP_rndaccFct	= p->rndaccFct;
	JvP_pagerFct	= p->pagerFct;
	JvP_phreadFct   = p->phreadFct;
    JvP_phwriteFct  = p->phwriteFct;


	XSplitStrV CopyOfArgs("pgp ");
	CopyOfArgs += p->lpszArguments;

	XSIZE_T p1=0, p2=0;
	while (CopyOfArgs.Find(p1, "\"", p2 ))
	{
		if (p1<CopyOfArgs.GetLength()-1)
		{
			if (!CopyOfArgs.Find(p2, "\"", p1+1 )) 
				p2 = CopyOfArgs.GetLength();
			if (p2-p1>1)
				CopyOfArgs.Replace(" ", "\07", XALL, p1, p2);
			p2++;
		}
		else break;
		if (p2 >= CopyOfArgs.GetLength()) break;
	}


	XStringVec Args;
	int Argc = CopyOfArgs.Split(Args);
	
	char **ArgV;
	ArgV = ( char **)malloc ( sizeof (char*) * Argc );
	assert (ArgV != NULL);
	{
	int ItemCount;
	XStringVec::iterator i;
	
	for ( i = Args.begin(), ItemCount = 0;
	      !(i == Args.end()), ItemCount < Argc; 
		  ItemCount ++, i++)
	{
		(*i).Replace("\"" , "");
		(*i).Replace("\07", " ");
/*		if ( ((*i)=="-z") || ((*i)=="-Z"))
		{
			ItemCount--;
			Argc--;
		}
		else  
*/
	   	ArgV[ItemCount] = (*i).GetBuffer();
	}
	}
	try
	{ pgp_main (Argc, ArgV);
	} catch (int e)
	{
		return (DWORD) e;
	}
	return 0;
} 



_PGP_DECL_ const char* WINAPI GETLANG(char* text)
{
	return LANG(text);
}


extern XString JvP_Lastout;

_PGP_DECL_ const char* WINAPI GETLASTMSG()
{
	return JvP_Lastout();
}