/*
 * Decompiled with CFR 0.152.
 */
package NIST;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public final class test {
    static final String VERSION = "$Revision: 1.0$";
    static final String SUBMITTER = "<as stated on the submission cover sheet>";
    boolean varKey = false;
    boolean varText = false;
    String dirName;
    String keylengths;
    String cipherName;
    File destination;
    int[] keys = new int[]{128, 192, 256};
    final String vkFileName = "ecb_vk.txt";
    final String vtFileName = "ecb_vt.txt";
    long encBlocks;
    long decBlocks;
    long keyCount;
    Method makeKey;
    Method encrypt;
    Method decrypt;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void main(String[] stringArray) {
        System.out.println("measures NIST AES cipher speed\n\n");
        test test2 = new test();
        test2.processOptions(stringArray);
        test2.run();
    }

    private void processOptions(String[] stringArray) {
        Object object;
        Object[] objectArray;
        int n = stringArray.length;
        if (n == 0) {
            this.printUsage();
        }
        System.out.println("(type \"java NIST.test\" with no arguments for help)\n\n");
        int n2 = -1;
        String string = "";
        boolean bl = true;
        while (true) {
            if (bl) {
                if (++n2 >= n) break;
                string = stringArray[n2];
            } else {
                string = "-" + string.substring(2);
            }
            if (string.startsWith("-k")) {
                this.varKey = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-t")) {
                this.varText = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-l")) {
                this.keylengths = stringArray[n2 + 1];
                ++n2;
                bl = true;
                continue;
            }
            if (string.startsWith("-d")) {
                this.dirName = stringArray[n2 + 1];
                ++n2;
                bl = true;
                continue;
            }
            this.cipherName = string;
        }
        if (this.cipherName == null) {
            test.halt("Missing cipher algorithm name");
        }
        if (this.cipherName.length() > 1 && (this.cipherName.startsWith("\"") || this.cipherName.startsWith("'"))) {
            this.cipherName = this.cipherName.substring(2, this.cipherName.length() - 2);
        }
        if (this.keylengths != null) {
            int n3 = 0;
            objectArray = new int[3];
            object = new StringTokenizer(this.keylengths, ", \t\"");
            while (((StringTokenizer)object).hasMoreTokens()) {
                int n4 = Integer.parseInt(((StringTokenizer)object).nextToken());
                if (n4 <= 0) {
                    test.halt("Negative key length not allowed: " + n4);
                }
                if (n3 == 3) {
                    test.halt("Only three key-length values are allowed.");
                }
                objectArray[n3++] = n4;
            }
            if (n3 != 0) {
                this.keys = new int[n3];
                System.arraycopy(objectArray, 0, this.keys, 0, n3);
            }
        }
        if (!this.varKey && !this.varText) {
            this.varText = true;
            this.varKey = true;
        }
        if (this.dirName == null) {
            this.dirName = System.getProperty("user.dir");
        }
        this.destination = new File(this.dirName);
        if (!this.destination.isDirectory()) {
            test.halt("Destination <" + this.destination.getName() + "> is not a directory");
        }
        String string2 = String.valueOf(this.cipherName) + "." + this.cipherName + "_Algorithm";
        try {
            Class<?> clazz = Class.forName(string2);
            objectArray = clazz.getDeclaredMethods();
            n2 = 0;
            while (n2 < objectArray.length) {
                object = objectArray[n2].getName();
                int n5 = objectArray[n2].getParameterTypes().length;
                if (((String)object).equals("makeKey") && n5 == 1) {
                    this.makeKey = (Method)objectArray[n2];
                } else if (((String)object).equals("blockEncrypt") && n5 == 3) {
                    this.encrypt = (Method)objectArray[n2];
                } else if (((String)object).equals("blockDecrypt") && n5 == 3) {
                    this.decrypt = (Method)objectArray[n2];
                }
                ++n2;
            }
            if (this.makeKey == null) {
                throw new NoSuchMethodException("makeKey()");
            }
            if (this.encrypt == null) {
                throw new NoSuchMethodException("blockEncrypt()");
            }
            if (this.decrypt == null) {
                throw new NoSuchMethodException("blockDecrypt()");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            test.halt("Unable to find " + string2 + " class");
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            test.halt("Unable to find " + string2 + "." + noSuchMethodException.getMessage() + " method");
        }
    }

    static void halt(String string) {
        System.err.println("\n*** " + string + "...");
        System.exit(-1);
    }

    static void notify(String string) {
        System.out.println("test: " + string + "...");
    }

    void printUsage() {
        System.out.println("NAME\n  test: measures the speed of an AES cipher algorithm.\n\nSYNTAX\n  java NIST.test\n    <cipher>\n\nOPTIONS\n  <cipher>\n       Cipher algorithm name.\n\n");
        System.exit(0);
    }

    void run() {
        long l = System.currentTimeMillis();
        test.notify("Java interpreter used: Version " + System.getProperty("java.version"));
        test.notify("Java Just-In-Time (JIT) compiler: " + System.getProperty("java.compiler"));
        test.notify("");
        test.notify("Encrypting 10000 blocks:");
        try {
            this.teste();
        }
        catch (Exception exception) {
            test.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + exception.getMessage());
        }
        test.notify("Total encryption time (ms): " + (System.currentTimeMillis() - l));
        test.notify("");
        test.notify("Decrypting 10000 blocks:");
        l = System.currentTimeMillis();
        try {
            this.testd();
        }
        catch (Exception exception) {
            test.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + exception.getMessage());
        }
        test.notify("Total decryption time (ms): " + (System.currentTimeMillis() - l));
    }

    void teste() throws IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{};
        int n = 10000;
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        objectArray = new Object[]{byArray};
        Object object = this.makeKey.invoke(null, objectArray);
        int n2 = 0;
        while (n2 < n) {
            objectArray = new Object[]{byArray2, new Integer(0), object};
            byArray2 = (byte[])this.encrypt.invoke(null, objectArray);
            ++n2;
        }
    }

    void testd() throws IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{};
        int n = 10000;
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        objectArray = new Object[]{byArray};
        Object object = this.makeKey.invoke(null, objectArray);
        int n2 = 0;
        while (n2 < n) {
            objectArray = new Object[]{byArray2, new Integer(0), object};
            byArray2 = (byte[])this.decrypt.invoke(null, objectArray);
            ++n2;
        }
    }

    private static boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static String toString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = n;
        int n3 = 0;
        while (n2 > 0) {
            byte by = byArray[--n2];
            cArray[n3++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }
}

