#ifndef CRYPTOPP_DES_H
#define CRYPTOPP_DES_H

#include "cryptlib.h"
#include "misc.h"

NAMESPACE_BEGIN(CryptoPP)

class DES : public BlockTransformation
{
public:
	DES(const byte *userKey, CipherDir);

	void ProcessBlock(const byte *inBlock, byte * outBlock) const;
	void ProcessBlock(byte * inoutBlock) const
		{DES::ProcessBlock(inoutBlock, inoutBlock);}

	enum {KEYLENGTH=8, BLOCKSIZE=8};
	unsigned int BlockSize() const {return BLOCKSIZE;}
	static unsigned int KeyLength(unsigned int keylength) {return KEYLENGTH;}

protected:
	static const word32 Spbox[8][64];

	SecBlock<word32> k;
};

class DESEncryption : public DES
{
public:
	DESEncryption(const byte * userKey, unsigned int = 0)
		: DES (userKey, ENCRYPTION) {}
};

class DESDecryption : public DES
{
public:
	DESDecryption(const byte * userKey, unsigned int = 0)
		: DES (userKey, DECRYPTION) {}
};

class DES_EDE_Encryption : public BlockTransformation
{
public:
	DES_EDE_Encryption(const byte * userKey, unsigned int = 0)
		: e(userKey, ENCRYPTION), d(userKey + DES::KEYLENGTH, DECRYPTION) {}

	void ProcessBlock(const byte *inBlock, byte * outBlock) const;
	void ProcessBlock(byte * inoutBlock) const;

	enum {KEYLENGTH=16, BLOCKSIZE=8};
	unsigned int BlockSize() const {return BLOCKSIZE;}
	static unsigned int KeyLength(unsigned int keylength) {return KEYLENGTH;}

private:
	DES e, d;
};

class DES_EDE_Decryption : public BlockTransformation
{
public:
	DES_EDE_Decryption(const byte * userKey, unsigned int = 0)
		: d(userKey, DECRYPTION), e(userKey + DES::KEYLENGTH, ENCRYPTION) {}

	void ProcessBlock(const byte *inBlock, byte * outBlock) const;
	void ProcessBlock(byte * inoutBlock) const;

	enum {KEYLENGTH=16, BLOCKSIZE=8};
	unsigned int BlockSize() const {return BLOCKSIZE;}
	static unsigned int KeyLength(unsigned int keylength) {return KEYLENGTH;}

private:
	DES d, e;
};

class TripleDES_Encryption : public BlockTransformation
{
public:
	TripleDES_Encryption(const byte * userKey, unsigned int = 0)
		: e1(userKey, ENCRYPTION), d(userKey + DES::KEYLENGTH, DECRYPTION),
		  e2(userKey + 2*DES::KEYLENGTH, ENCRYPTION) {}

	void ProcessBlock(const byte *inBlock, byte * outBlock) const;
	void ProcessBlock(byte * inoutBlock) const;

	enum {KEYLENGTH=24, BLOCKSIZE=8};
	unsigned int BlockSize() const {return BLOCKSIZE;}
	static unsigned int KeyLength(unsigned int keylength) {return KEYLENGTH;}

private:
	DES e1, d, e2;
};

class TripleDES_Decryption : public BlockTransformation
{
public:
	TripleDES_Decryption(const byte * userKey, unsigned int = 0)
		: d1(userKey + 2*DES::KEYLENGTH, DECRYPTION), e(userKey + DES::KEYLENGTH, ENCRYPTION),
		  d2(userKey, DECRYPTION) {}

	void ProcessBlock(const byte *inBlock, byte * outBlock) const;
	void ProcessBlock(byte * inoutBlock) const;

	enum {KEYLENGTH=24, BLOCKSIZE=8};
	unsigned int BlockSize() const {return BLOCKSIZE;}
	static unsigned int KeyLength(unsigned int keylength) {return KEYLENGTH;}

private:
	DES d1, e, d2;
};

NAMESPACE_END

#endif
