#ifndef GABA_DEFINE
struct forwarded_tcpip
{
  struct lsh_object super;
  struct forwarded_tcpip *next;
  struct lsh_string *bind_host;
  UINT32 bind_port;
  struct listen_fd *listen;
};
extern struct lsh_class forwarded_tcpip_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_forwarded_tcpip_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct forwarded_tcpip *i = (struct forwarded_tcpip *) o;
  mark((struct lsh_object *) i->next);
  mark((struct lsh_object *) i->listen);
}

static void do_forwarded_tcpip_free(struct lsh_object *o)
{
  struct forwarded_tcpip *i = (struct forwarded_tcpip *) o;
  lsh_string_free(i->bind_host);
}

struct lsh_class forwarded_tcpip_class =
{ STATIC_HEADER,
  0, "forwarded_tcpip", sizeof(struct forwarded_tcpip),
  do_forwarded_tcpip_mark,
  do_forwarded_tcpip_free
};
#endif /* !GABA_DECLARE */

