/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
 
#pragma ident "@(#)skip_cache.h	1.19 96/05/02"

#ifndef SKIP_CACHE_H
#define SKIP_CACHE_H
 
#include "Bstream.h"
#include "LL.h"
#include "skip_secret.h"
#include "skip_localid.h"


class secret_cache_elem  {
public:
	u_char		r_nsid;		// remote nsid
        Bstream		r_keyid;	// remote mkid
	u_char		l_nsid;		// local nsid
        Bstream		l_keyid;	// local mkid
	SkipSecret	*secret;

	// expiration time begin, end needs to be in here
};

#define MAX_HASH	1019		// must be prime

class secret_cache {
private:
	LL<secret_cache_elem> *table[MAX_HASH];
	unsigned int hash(const Bstream&);

public:
	secret_cache();
	SkipSecret *get_secret(u_char l_nsid, const Bstream&, u_char r_nsid, 
				const Bstream &);

	secret_cache_elem *get_entry(u_char, const Bstream&, 
				     u_char, const Bstream &);

	void purge();
	void insert(secret_cache_elem *);
};

#define MAX_SECRETS	10

class local_secret {
public:
	Bstream keyid;
	u_char nsid;
	int params;
	Bstream secret;

	local_secret() : nsid(0), params(0) {}
};

#endif /* SKIP_CACHE_H */
