/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_es.h	1.20 96/07/08 Sun Microsystems"

#ifndef SKIP_ES_H
#define SKIP_ES_H

#ifdef  __cplusplus
extern "C" {
#endif

/*
 * the hash functions skip_es_hosthash()/skip_es_nethash() must be
 * modified if this define changes...
 */
#define SKIP_ES_HASH_TABLESZ	(256)

/*
 * supported network interfaces
 */
#define SKIP_ETHER_HDRSZ	(14)
#define SKIP_FDDI_HDRSZ		(24)

/*
 * access control information is held in per-interface hash tables -
 * one for hosts, the other for networks.
 */
typedef struct skip_es_hash_t {
	struct skip_es_hash_t	*next;	/* hash collision entries */
	struct skip_es_hash_t	*prev;	/* hash collision entries */
	skip_param_t		params;
} skip_es_hash_t;

#define	SKIP_NETMATCH(a, p)	((a->s_addr & p.mask.s_addr) == \
				 p.ip_addr.s_addr)
/*
 * SKIP IP header size
 */
#define	IP_HDR_SZ	(20)

#define	SKIP_IPSP_HDR_SZ	(68) /* worst-case SKIP header size */
#define SKIP_IPSP_AH_SZ		(24) /* with 128 bits MD5 */
#define	SKIP_IPSP_ESP_SZ	(22) /* includes 8 bytes iv + 10 byte pad */

#define	SKIP_HDR_SZ	(IP_HDR_SZ + \
			SKIP_IPSP_HDR_SZ + \
			SKIP_IPSP_AH_SZ + \
			SKIP_IPSP_ESP_SZ )

#define	IP_MAX_HDR	64
#define IP_MIN_PAYLOAD	8
#define	SKIP_MIN_MTU	(IP_MAX_HDR + SKIP_HDR_SZ + IP_MIN_PAYLOAD)

#ifndef IP_OFFSET
#define	IP_OFFSET	(0x1fff)
#endif
#define	INADDRSZ	(4)
#define	IPADDRMATCH(a, b)	((a)->s_addr == (b)->s_addr)

/*
 * default size of buffer to allocate for encrypted packets (updated by mac)
 */
#define	ENCRYPTBUFSZ	2048

/*
 * function prototypes - exported functions
 */
struct skip_es;
extern boolean_t	skip_es_bypass(struct ip *, int);
extern boolean_t	skip_es_find_keyid(struct skip_es *, 
						unsigned char,
						unsigned char,
						skip_key_var_t *,
						skip_es_hash_t **,
						skip_es_hash_t ***);
extern int		skip_es_change_addr(struct skip_es *,
						skip_param_t *,
						struct in_addr *);
extern int		skip_es_acl_add(skip_es_req_t *, int);
extern int		skip_es_acl_del(skip_es_req_t *, int);
extern int		skip_es_acl_get(skip_es_req_t *, int);
extern int		skip_es_acl_list(skip_es_req_t *, int *);
extern int		skip_es_get_mode(skip_es_mode_t *);
extern int		skip_es_set_mode(SKIP_NOTIFYQ_T, skip_es_mode_t *);
extern int		skip_get_if_stats(skip_ctrl_stats_t *);

#ifdef  __cplusplus
}
#endif

#endif /* SKIP_ES_H */
