/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_ipsp.c	1.23	96/04/02 Sun Microsystems"

/*
 * System includes
 */
#include <skip_os.h>

/*
 * SKIP includes
 */
#include <skip_proto.h>
#include <skip_types.h>
#include <skip_keymgrmsgs.h>
#include <skip_key.h>
#include <skip_crypt.h>
#include <skip_ah.h>
#include <skip_ioctl.h>

/*
 * skip header statistics
 */
extern ioctl_hdr_stat_t	skip_hdrs_stats;

extern unsigned char	skip_nsid[];


/* skip_hdr_ipsp_decode()
 * 
 * Decode a skip header in a packet
 *
 * Returns: the offset of the start of real data in the packet, or
 * -1 if the skip header was not valid.
 */
int
skip_hdr_ipsp_decode(unsigned char *start, unsigned char *end, skip_hdr_t *hdr)
{
	register unsigned char	*p = start;
	register 		i;
	register int 		Akp_len = 0;
	register int	 	Ekp_len = 0;
	unsigned char		version;
	skip_cryptor_t		*kp_crypt;
	skip_mac_t		*kp_mac;

	/*
	 * Set the SKIP protocol version to IPSP
	 */
	hdr->params.version = SKIP_V2;

	/*
	 * a minimum skip header is SKIP_MIN_HDR_LG bytes
	 */
	if ((end - p) < SKIP_MIN_HDR_LG) {
		skip_hdrs_stats.skip_hdr_runts++;
		return (-1);
	}

	/*
	 * Decode the version field
	 */
	version = (*p >> 4) & 0x0f;

	if (version != SKIP_VERSION) {
		skip_hdrs_stats.skip_hdr_bad_versions++;
		return(-1);
	}
	p++;

	/*
	 * Decode the source/destination NSID fields
	 */

	/*
	 * When decoding a packet, the sender key id corresponds to the
	 * remote, the receiver key id is ours.
	 */
	hdr->params.r_nsid = *p++;	/* s_nsid in packet */
	hdr->params.s_nsid = *p++;	/* r_nsid in packet */

	/* 
	 * Decode the Next Header field
	 */
	hdr->params.payload_type = *p++;

	/*
	 * Get the counter n value
	 */
	hdr->params.counter_n = *((unsigned long *) p);
	p += 4;

	/*
	 * Get all alogrithms identifiers
	 */
	hdr->params.kij_alg 	= *p++;
	hdr->params.kp_alg 	= *p++;
	hdr->params.mac_alg 	= *p++;
	hdr->params.comp_alg 	= *p++;

	/*
	 * Get the size of encrypted Kp
	 * Key size is max(Ekp, Akp)
	 */
	if (hdr->params.kp_alg) {

		kp_crypt = GETCRYPTMOD(SKIP_V2, hdr->params.kp_alg);
		Ekp_len = kp_crypt->ekp_len;

		if (Ekp_len < 0) {
			skip_hdrs_stats.skip_hdr_bad_kp_algs++;
			return (-1);
		} 
	}

	if (hdr->params.mac_alg) {

		kp_mac = GETMACMOD(hdr->params.mac_alg);

		if (kp_mac == NULL)  {
			skip_hdrs_stats.skip_hdr_bad_mac_algs++;
			return (-1);
		}
		Akp_len = kp_mac->kp_len;
	}
	hdr->ekp.len = Ekp_len > Akp_len ? Ekp_len : Akp_len;

	/*
	 * get encrypted kp (ekp) field
	 */
	if ((int) (end - p) < hdr->ekp.len) {
		skip_hdrs_stats.skip_hdr_short_ekps++;
		return (-1);
	}

	for (i = 0; i < hdr->ekp.len; i++) {
		hdr->ekp.buf[i] = *p++;
	}

	/*
 	 * Master Key ID of remote (Sender Master key ID in protocol)
 	 */
	if (hdr->params.r_nsid) {
		/*
		 * Name Space supported ?
		 */
		if ((int) hdr->params.r_nsid >=  SKIP_MAX_NSID) {
			skip_hdrs_stats.skip_hdr_bad_nsid++;
			return (-1);
		}

		hdr->params.r_mkeyid.len = skip_nsid[hdr->params.r_nsid];

		if ((int) (end - p) < (int) hdr->params.r_mkeyid.len) {

			/*
			 * Sender Master Key ID in the protocol is short
			 */
			skip_hdrs_stats.skip_hdr_short_s_mkeyid++;
			return (-1);
		}

		for (i = 0; i < (hdr->params.r_mkeyid.len); i++) {
			hdr->params.r_mkeyid.buf[i] = *p++;
		}
	}

	/*
 	 * Master Key ID of local (Receiver Master key ID in protocol)
 	 */
	if (hdr->params.s_nsid) {
		/*
		 * Name Space supported ?
		 */
		if ((int) hdr->params.s_nsid >= SKIP_MAX_NSID) {
			skip_hdrs_stats.skip_hdr_bad_nsid++;
			return (-1);
		}

		hdr->params.s_mkeyid.len = skip_nsid[hdr->params.s_nsid];

		if ((int) (end - p) < hdr->params.s_mkeyid.len) {
			/*
			 * Receiver Master Key ID in the protocol is short
			 */
			skip_hdrs_stats.skip_hdr_short_r_mkeyid++;
			return (-1);
		}

		for (i = 0; i < (hdr->params.s_mkeyid.len); i++) {
			hdr->params.s_mkeyid.buf[i] = *p++;
		}

	}

	skip_hdrs_stats.skip_ipsp_decodes++;

	return ((int)(p - start));
}

/*
 * skip_iv_esp_decode() 
 *
 * Retrieve the value of the IV 
 */
int
skip_iv_esp_decode(skip_hdr_t * hdr, unsigned char *start, unsigned char *end) 
{
	unsigned char	*p = start;
	skip_cryptor_t	*kp_crypt;
	unsigned long	skip_spi = 0;
	int 		i;

	/*
	 * Get SPI field ...
	 */
	if ((unsigned short) (end - p) < sizeof (skip_spi)) {
		skip_hdrs_stats.skip_hdr_bad_esp_spi++;
		return (-1);
	}

	skip_spi = * (unsigned long *) p;

	/*
	 * ...and check it
	 */
	if (hdr->params.version == SKIP_V2) {
		if (skip_spi != SKIP_SPI) {
			skip_hdrs_stats.skip_hdr_bad_esp_spi++;
			return (-1);
		}

	} else {
		/*
		 * with raw ESP/AH mode, SPI should match the
		 * Sender Master Key ID.
		 */
		if (BCMP((caddr_t) &skip_spi,
				(caddr_t) hdr->params.s_mkeyid.buf,
				sizeof(skip_spi))) {
			skip_hdrs_stats.skip_hdr_bad_esp_spi++;
			return (-1);
		}
	}

	p += sizeof (skip_spi);

	kp_crypt = GETCRYPTMOD(SKIP_V2, hdr->params.kp_alg);

	hdr->mid.len = kp_crypt->mid_len;

	/*
	 * copy the MID/Initialization Vector (IV)
	 */
	if ((int) (end - p) < hdr->mid.len) {
		skip_hdrs_stats.skip_hdr_short_mids++;
		return (-1);
	}

	for (i = 0; i < hdr->mid.len; i++) {
		hdr->mid.buf[i] = *p++;
	}

	return ((int)(p - start));
}
