// optdlg.cpp : implementation file
//

#include "stdafx.h"
#include "winkey.h"
#include "optdlg.h"

extern CKeyApp NEAR keyApp;

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptionsDlg dialog


COptionsDlg::COptionsDlg(CKeyDialog* pParent /*=NULL*/)
   : CDialog(COptionsDlg::IDD, pParent)
{
   m_parent = pParent;
   
   //{{AFX_DATA_INIT(COptionsDlg)
   m_autopaste = pParent->m_autopaste;
   m_autocopy = pParent->m_autocopy;
   m_autodecrement = pParent->m_autodecrement;
   m_autoclear = FALSE;
   //}}AFX_DATA_INIT
}


void COptionsDlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(COptionsDlg)
   DDX_Check(pDX, IDC_CHECK1, m_autopaste);
   DDX_Check(pDX, IDC_CHECK2, m_autocopy);
   DDX_Check(pDX, IDC_CHECK3, m_autodecrement);
   DDX_Check(pDX, IDC_CHECK4, m_autoclear);
   //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(COptionsDlg, CDialog)
   //{{AFX_MSG_MAP(COptionsDlg)
   ON_BN_CLICKED(IDC_ABOUT, OnAbout)
   ON_BN_CLICKED(IDC_SAVE, OnSave)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// COptionsDlg message handlers

BOOL COptionsDlg::OnInitDialog() 
{
   CDialog::OnInitDialog();

   // copy global flags
   m_autopaste = (BOOL)m_parent->m_autopaste;
   m_autocopy = (BOOL)m_parent->m_autocopy;
   m_autodecrement = (BOOL)m_parent->m_autodecrement;
   m_autoclear = (BOOL)m_parent->m_autoclear;
   UpdateData(FALSE);
   CheckRadioButton(IDC_MD4, IDC_MD5, IDC_MD4 + m_parent->m_algorithm);
      
   return TRUE;
}


void COptionsDlg::OnAbout() 
{
   // display about box
   MessageBox("OPIE S/Key Calculator\nby David Aylesworth\n"
              "Technologic, Inc.\ndave@tlogic.com", 
              "WinKey v1.1", MB_ICONINFORMATION);
}


void COptionsDlg::OnCancel() 
{
   CDialog::OnCancel();
}


void COptionsDlg::OnOK() 
{
   UpdateData(TRUE);

   // set global flags   
   m_parent->m_autopaste = (int)m_autopaste;
   m_parent->m_autocopy = (int)m_autocopy;
   m_parent->m_autodecrement = (int)m_autodecrement;
   m_parent->m_autoclear = (int)m_autoclear;
   m_parent->m_algorithm = GetCheckedRadioButton(IDC_MD4, IDC_MD5) - IDC_MD4;

   CDialog::OnOK();
}

void COptionsDlg::OnSave()
{
   UpdateData(TRUE);

   // set global flags   
   m_parent->m_autopaste = (int)m_autopaste;
   m_parent->m_autocopy = (int)m_autocopy;
   m_parent->m_autodecrement = (int)m_autodecrement;
   m_parent->m_autoclear = (int)m_autoclear;
   m_parent->m_algorithm = GetCheckedRadioButton(IDC_MD4, IDC_MD5) - IDC_MD4;

   // save defaults
   keyApp.WriteProfileInt("Defaults", "AutoCopy", m_parent->m_autocopy);
   keyApp.WriteProfileInt("Defaults", "AutoPaste", m_parent->m_autopaste);
   keyApp.WriteProfileInt("Defaults", "AutoDecrement", m_parent->m_autodecrement);
   keyApp.WriteProfileInt("Defaults", "AutoClear", m_parent->m_autoclear);
   keyApp.WriteProfileString("Defaults", "Algorithm", m_parent->m_algorithm ? "MD5" : "MD4");

   CDialog::OnOK();
}
