#include <ctype.h>

/* match common names using shell expressions */
int                 shellexp(char *t, char *m)
{
        static char        *lastx;
	int                 good, revflag;
	char               *lastt, *tref;

	tref = t;
	lastt = t;
	while (*m) {
		good = 0;
		switch (*m) {
		case '~':
			return (!shellexp(tref, ++m));
		case '$':
			return (!(*t));
		case '*':
			while (*m && *m == '*')
				m++;
			if (!*m)
				return 1;
			while (*t)
				if (shellexp(t++, m))
					return 1;
			return 0;
		case '[':
			if ((revflag = (*++m == '^')))
				m++;
			while (!good && *m && *m != ']') {
				switch (*m) {
				case '-':
					if (*t >= m[-1] && *t <= m[1])
						good = 1;
					m++;
					m++;
					break;
				case '\\':
					if (!*++m)
						return 0;
				default:
					if (*++m == *t)
						good = 1;
					break;
				}
			}
			if (good == revflag)
				return 0;
			while (*m != ']')
				if (!*++m)
					return 0;
		case '?':	/* with fallthrough */
			m++, t++;
			break;
		case '(':
			do {
				m++;
				if (shellexp(t, m))
					good = 1, lastt = lastx;
				while (*m && *m != ')' && *m != '|')
					m++;
			} while (*m == '|');
			if (!good || *m++ != ')')
				return 0;
			t = lastt;
			break;
		case '|':
		case ')':
			lastx = t;
			return 1;
		case '\\':
			if (!*++m)
				return 0;
		default:	/* with fallthrough */
			if (tolower(*m++) != tolower(*t++))
				return 0;
		}
	}
	return (!(*t));
}
