/* ====================================================================
 * Copyright (c) 1998 Ralf S. Engelschall. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by 
 *     Ralf S. Engelschall <rse@engelschall.com> for use in the
 *     mod_ssl project (http://www.engelschall.com/sw/mod_ssl/)."
 *
 * 4. The names "mod_ssl" must not be used to endorse or promote
 *    products derived from this software without prior written
 *    permission. For written permission, please contact
 *    rse@engelschall.com.
 *
 * 5. Products derived from this software may not be called "mod_ssl"
 *    nor may "mod_ssl" appear in their names without prior
 *    written permission of Ralf S. Engelschall.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by 
 *     Ralf S. Engelschall <rse@engelschall.com> for use in the
 *     mod_ssl project (http://www.engelschall.com/sw/mod_ssl/)."
 *
 * THIS SOFTWARE IS PROVIDED BY RALF S. ENGELSCHALL ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RALF S. ENGELSCHALL OR
 * HIS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes software developed by Ben Laurie
 * for use in the Apache-SSL HTTP server project.
 */

/* ====================================================================
 * Copyright (c) 1995, 1996, 1997, 1998 Ben Laurie.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Ben Laurie
 *    for use in the Apache-SSL HTTP server project."
 *
 * 4. The name "Apache-SSL Server" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Ben Laurie
 *    for use in the Apache-SSL HTTP server project."
 *
 * THIS SOFTWARE IS PROVIDED BY BEN LAURIE ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL BEN LAURIE OR
 * HIS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 */


/* OS headers */
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/un.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

/* mod_ssl headers */
#include "ssl_gcache.h"

typedef union {
    struct sockaddr_in in;
    struct sockaddr_un un;
} SockAddr;

static const char *szServerPort;

void ssl_gcache_Init(const char *szPort)
{
    szServerPort = szPort;
    return;
}

static int ssl_gcache_OpenServer(void)
{
    int nSize;
    int nSocket;
    SockAddr saServer;
    int nServerPort;
    
    nServerPort = atoi(szServerPort);
    if (nServerPort)
        nSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    else
        nSocket = socket(AF_UNIX, SOCK_STREAM, 0);
    if (nSocket < 0) {
        fprintf(stderr, "[%s] ssl_gcache: socket(): %s\n", 
                ssl_gcache_get_time(), strerror(errno));
        return (-1);
    }

    memset(&saServer, 0, sizeof(saServer));
    if (nServerPort) {
        saServer.in.sin_family = AF_INET;
        saServer.in.sin_addr.s_addr = htonl(0x7f000001);
        saServer.in.sin_port = htons(nServerPort);
        nSize = sizeof(saServer.in);
    }
    else {
        saServer.un.sun_family = AF_UNIX;
        strcpy(saServer.un.sun_path, szServerPort);
        nSize = sizeof(saServer.un);
    }

    if (connect(nSocket, (struct sockaddr *)&saServer, nSize)) {
        fprintf(stderr, "[%s] ssl_gcache: connect(): %s\n", 
                ssl_gcache_get_time(), strerror(errno));
        return (-1);
    }
    return nSocket;
}

static void ssl_gcache_WriteCommand(int nFD, enum Command eCommand)
{
    char c;

    c = eCommand;
    write(nFD, &c, 1);
    return;
}

void ssl_gcache_GlobalAdd(UCHAR *aucKey, int nKey, UCHAR *aucData,
                    int nData, time_t tExpiresAt)
{
    int nFD;
        
    if ((nFD = ssl_gcache_OpenServer()) < 0)
        return;
    ssl_gcache_WriteCommand(nFD, ADD_TO_CACHE);
    ssl_gcache_WriteThing(nFD, aucKey, nKey);
    ssl_gcache_WriteThing(nFD, aucData, nData);
    write(nFD, &tExpiresAt, sizeof(tExpiresAt));
    close(nFD);
    return;
}

UCHAR *ssl_gcache_GlobalGet(UCHAR *aucKey, int nKey, int *pnData, time_t *ptExpiresAt)
{
    int nFD;
    UCHAR *ret;

    if ((nFD = ssl_gcache_OpenServer()) < 0) {
        *pnData = 0;
        return NULL;
    }
    ssl_gcache_WriteCommand(nFD, GET_FROM_CACHE);
    ssl_gcache_WriteThing(nFD, aucKey, nKey);
    ret = ssl_gcache_ReadThing(nFD, pnData);
    if (ret)
        read(nFD, ptExpiresAt, sizeof(*ptExpiresAt));
    close(nFD);
    return ret;
}

