/* pkcrack - pkcrack.h
 *
 * (C) by Peter Conrad <conrad@unix-ag.uni-kl.de>
 *
 * $Id: pkcrack.h,v 1.5 1996/08/21 17:37:20 conrad Release1_2 $
 *
 * $Log: pkcrack.h,v $
 * Revision 1.5  1996/08/21 17:37:20  conrad
 * memory for plain- and ciphertext is now allocated dynamically
 *
 * Revision 1.4  1996/08/13 13:20:27  conrad
 * Increased value of KEY2SPACE after several complaints. Now the array is
 * 32 MB...
 *
 * Revision 1.3  1996/06/23 10:28:48  lucifer
 * Modifications for DJGPP 2.0: DJGPP can't handle arrays larger than 16MB,
 * so key2i is now allocated dynamically.
 * DJGPP doesn't know about type ushort, either.
 *
 * Revision 1.2  1996/06/12  09:47:20  conrad
 * Release version
 *
 * Revision 1.1  1996/06/10 17:55:27  conrad
 * Initial revision
 *
 */

#define byte	unsigned char /*  8 bit wide */
#define uword	unsigned int  /* 32 bit wide */

#ifdef __DJGPP__
#define	ushort	unsigned short /* 16 bit wide */
#endif /* DJGPP */

#define	KEY2SPACE	(1<<23)	/* some more just for safety */

#define	KEY3(i)	(plaintext[(i)]^ciphertext[(i)])

extern byte	*plaintext, *ciphertext;
extern uword	*key2i;
extern int	numKey2s, bestOffset;

