/* pkcrack - mktmptbl.c
 *
 * (C) by Peter Conrad <conrad@unix-ag.uni-kl.de>
 *
 * $Id: mktmptbl.c,v 1.4 1996/08/13 13:19:19 conrad Release1_2 $
 *
 * $Log: mktmptbl.c,v $
 * Revision 1.4  1996/08/13 13:19:19  conrad
 * Changed name to support OS with short filenames... :-/
 *
 * Revision 1.3  1996/06/23 12:34:08  lucifer
 * #defined ushort for DJGPP
 *
 */

static char RCSID[]="$Id: mktmptbl.c,v 1.4 1996/08/13 13:19:19 conrad Release1_2 $";

#include <stdio.h>
#include <sys/types.h>

#define byte	unsigned char

#ifdef	__DJGPP__
#define	ushort	unsigned short
#endif	/* __DJGPP__ */

ushort tempTable[256][64];

static int numEntries[256];

void preCompTemp( )
{
ushort	temp;
byte	key3;

    for( temp = 0; temp < 256; temp++ )
	numEntries[temp] = 0;

    temp = 65532;
    do{
	temp += 4;
	key3 = (((temp|2) * (temp|3))>>8)&0xff;
	tempTable[key3][numEntries[key3]++] = temp;
	if( numEntries[key3] > 64 )
	    fprintf( stderr, "Warning! Lookup-table corrupted!\n" );
    }while( temp < 65532 );
}

