/* pkcrack - keystuff.c
 *
 * (C) by Peter Conrad <conrad@unix-ag.uni-kl.de>
 *
 * $Id: keystuff.c,v 1.3 1996/06/12 09:46:51 conrad Release1_2 $
 *
 * $Log: keystuff.c,v $
 * Revision 1.3  1996/06/12 09:46:51  conrad
 * Release version
 *
 * Revision 1.2  1996/06/11 10:27:57  conrad
 * added function cUpdateKeys() for decrypting stuff
 *
 * Revision 1.1  1996/06/10 17:46:07  conrad
 * Initial revision
 *
 */

static char RCSID[]="$Id: keystuff.c,v 1.3 1996/06/12 09:46:51 conrad Release1_2 $";

#include <sys/types.h>
#include "pkcrack.h"
#include "crc.h"
#include "keystuff.h"

uword	key0, key1, key2;
ushort	temp;
byte	key3;

void initkeys()
{
    key0 = 0x12345678;
    key1 = 0x23456789;
    key2 = 0x34567890;
}

void updateKeys( byte plainbyte )
{
    key0 = CRC32( key0, plainbyte );
    key1 = (key1 + (key0&0xff))*134775813 + 1;
    key2 = CRC32( key2, (key1>>24)&0xff );
    temp = (key2&0xffff) | 3;
    key3 = ((temp * (temp^1))>>8)&0xff;
}

byte cUpdateKeys( byte cipherbyte )
{
byte plainbyte;

    temp = (key2&0xffff) | 3;
    key3 = ((temp * (temp^1))>>8)&0xff;
    plainbyte = cipherbyte^key3;
    updateKeys( plainbyte );

    return plainbyte;
}

