/*
 * exheaders.h
 *
 * This file defines some structures containing information from a typical
 * ZIP-archive. Gratefully received from a person who wishes to remain 
 * anonymous. Some changes by Peter Conrad, August 1996.
 *
 * $Id: headers.h,v 1.2 1996/08/21 17:35:19 conrad Release1_2 $
 *
 * $Log: headers.h,v $
 * Revision 1.2  1996/08/21 17:35:19  conrad
 * variable-prototypes for stuff in readhead.c
 *
 * Revision 1.1  1996/08/20 17:58:45  conrad
 * Initial revision
 *
 */

/******************************************************************************/
/* Various types and constants                                                */
/******************************************************************************/

/******************************************************************************/
/* Header types                                                               */
/******************************************************************************/
#define LOCAL 1
#define DIR   2
#define END   3

/******************************************************************************/
/* Local header                                                               */
/******************************************************************************/
typedef struct
{
  unsigned char version[2];
  unsigned char gpb[2];
  unsigned char compr[2];
  unsigned char time[2];
  unsigned char date[2];
  unsigned long crc;
  unsigned long csize;
  unsigned long uncsize;
  unsigned short flen;
  unsigned short extralen;
} local;

/******************************************************************************/
/* Directory                                                                  */
/******************************************************************************/
typedef struct
{
  unsigned char version[2];
  unsigned char verneed[2];
  unsigned char gpb[2];
  unsigned char compr[2];
  unsigned char time[2];
  unsigned char date[2];
  unsigned long crc;
  unsigned long csize;
  unsigned long uncsize;
  unsigned short flen;
  unsigned short extralen;
  unsigned short commlen;
  unsigned short disk;
  unsigned char attr[2];
  unsigned long extattr;
  unsigned long locoffset;
} dirtype;

/******************************************************************************/
/* End of directory                                                           */
/******************************************************************************/
typedef struct
{
  unsigned short diskno;
  unsigned short centrdiskno;
  unsigned short diskentries;
  unsigned short totentries;
  unsigned long centrsize;
  unsigned long centroffset;
  unsigned short commlen;
} enddirtype;

/******************************************************************************/
/* Data descriptor                                                            */
/******************************************************************************/
typedef struct
{
  unsigned long crc;
  unsigned long csize;
  unsigned long uncsize;
} ddesctype;

extern local		lh;
extern dirtype		dir;
extern enddirtype	enddir;
extern ddesctype	ddesc;
extern char		*filename;

