#ifndef PAN_HASH_MED
#define PAN_HASH_MED

#include <string.h>
#include "hash_low.h"

#ifdef __cplusplus
extern "C" {
#endif

/** Internal Functions **/

int Brute_Force(Pan_PassHack *gPassHack,int maxtry,char **trypw,uint32 limit,char *_key_space)
{
 uint8 buf[32],idtab[4];
 uint32 id;
 short FOUND=FALSE;
 int i,k;
 int try_index[16];
 unsigned short lengh,pos,turns,locat;
 uint8 crypt2_c_val,ghash[16],crypt2data[96];

  /* Initialize and sanity */
  *trypw=(char *)calloc(1,sizeof(char)*19);
  lengh=(short)gPassHack->pwlen;
  for(i=0;i<16;i++) ghash[i]=gPassHack->hash[i];
  for(i=0;i<lengh;i++) (*trypw)[i]=gPassHack->pw_current[i];
  for(i=0;i<lengh;i++)
   for(k=0;k<maxtry+1;k++)
    if ((*trypw)[i]==_key_space[k]) try_index[i]=k;

  /* Initialize */
  id=gPassHack->objectID;
  for(i=0;i<4;i++) idtab[i]=(uint8)(id>>(8*i));
  turns=preparepw(*trypw,lengh,buf);

  /* turns is the number of time part of the passwd is repeated */
  xorwithid(id,(uint32 *)buf);
  i=0; do {crypt2data[i]=buf[i]; i++;} while (i<32);

  /* loop forever (or until success, the bitter end, or power failure) */
  while(1)
  {

   /* do the test... */
   #define PAN_INSERT_HASH_HERE
   #include "hash_low.h"
   #undef PAN_INSERT_HASH_HERE
   FOUND=TRUE; /* comes here if password found */
   break;
   NOTFOUND:   /* comes here if password not found */
   /* the function call has been replaced by an insertion of the routine
      directly here, due to optimization requirements of threading       */
   /* We check if we accomplished a
      complete loop, or passwd found */
   if ( (!(memcmp(gPassHack->pw_last,*trypw, lengh))) || (!(--limit)) )
    { 
     for(i=0;i<lengh;i++) gPassHack->pw_current[i]=(*trypw)[i];
     break;
    }

    i=0;
    while(i<lengh)
    {
      pos=lengh-i-1;
      if (try_index[pos] < maxtry)
      { 
        try_index[pos]++;
        (*trypw)[pos]=_key_space[try_index[pos]];
        for(k=0;k<turns;k++)
        {
          locat=pos+(lengh+1)*k;
          /* this little indian thing is driving me crazzzy */
          if (locat<32) crypt2data[locat]=(*trypw)[pos]^idtab[locat&3];
        }
        break;
      }
      try_index[pos]=0;
      (*trypw)[pos]=_key_space[try_index[pos]];
      for(k=0;k<turns;k++)
      {
        locat=pos+(lengh+1)*k;
        if (locat<32) crypt2data[locat]=(*trypw)[pos]^idtab[locat&3];
      }
      i++;
    };
  }
 /* now we are out of the loop */
 strcpy(gPassHack->pw_current,*trypw);
 if (FOUND) return(NULL);
 if (!(memcmp(gPassHack->pw_last,*trypw,lengh))) return(-105);
 if (!limit) return (-106);
  else return(-1);
}

/************End  of Brute Force*************/
/************Dict attack********************/
int Dict_Attack(Pan_PassHack *gPassHack,char **words,char *wordlist)
{FILE *dict;
 int i,FOUND=FALSE;
 uint8 crypt2_c_val,ghash[16],crypt2data[96];

 *words=(char *)malloc(sizeof(char)*19);
  /*if pwlen=16, words[17]=carriage return,words[18]='\0'*/

 dict=fopen(wordlist, "r");
 if (dict==NULL) return (-300);

 for(i=0;i<16;i++) ghash[i]=gPassHack->hash[i];

 /* the crack loop -- break out if done or the password found */
 while (!feof(dict))
  {
   fgets(*words, 18, dict); /*reads 18-1 (17) chars*/
   /* subtract the length of the carriage return and check the
      length of the dictionary word. Since we know what the
      unencrypted length is, skip the word if it's not the right
      length to save time */
   if (strlen(*words)-1==gPassHack->pwlen)
    {
     for (i=0;i<gPassHack->pwlen;i++)
      (*words)[i]=toupper((*words)[i]); /* convert lower case letters to
                                           upper case letters */
     (*words)[i]='\0';
     preparepw(*words,gPassHack->pwlen,crypt2data);
     xorwithid(gPassHack->objectID,(uint32 *)crypt2data);
     /* do the test... */
     #define PAN_INSERT_HASH_HERE
     #include "hash_low.h"
     #undef PAN_INSERT_HASH_HERE
     FOUND=TRUE; /* comes here if password found */
     break;
     NOTFOUND:   /* comes here if password not found */
     /* the function call has been replaced by an insertion of the routine
        directly here, due to optimization requirements of threading       */
    }
  }
 if (FOUND==TRUE) return(NULL);
 else
  {free(*words); *words=NULL;
   return(-105);
  }
}
/**********End of Dict Attack*********/

/********* Challenge response ********/
int Pan_Hash_Gen(Pan_PassHack *pPassHack); /* I hate to do this, but it */
                                           /* keeps the code clearer */
int getpassk(Pan_PassHack *Info,int hash_known,uint8 *logkey, uint8 *dst)
{
 Pan_PassHack pPassHack;
 uint8 buf[32],crpw[16];
 long *key;
 int err,i,j;

 /** Hash generation if necessary **/
 if (!hash_known) {err=Pan_Hash_Gen(Info);
                   if (err) return(-107);}
 for(i=0;i<16;i++) crpw[i]=Info->hash[i];

 /** initialize for response hash generation **/
 key=(long *)logkey;
 pPassHack.objectID=key[0];
 pPassHack.pwlen=16;
 for(i=0;i<pPassHack.pwlen;i++) pPassHack.pw_first[i]=crpw[i];
 pPassHack.pw_first[pPassHack.pwlen]='\0';

 /** get first half of hash response **/
 err=Pan_Hash_Gen(&pPassHack);
 if (err) return(err);
 for(i=0;i<16;i++) buf[i]=pPassHack.hash[i];

 /** get second half of hash response **/
 pPassHack.objectID=key[1];
 err=Pan_Hash_Gen(&pPassHack);
 if (err) return(err);
 for(i=16;i<32;i++) buf[i]=pPassHack.hash[i-16];

 /** hash the response **/
 for (i=0, j=31 ; i<16 ; i++, j--) buf[i]^=buf[j];
 for (i=0 , j=15 ; i<8 ; i++, j--) dst[i]=buf[i]^buf[j];

 return(NULL);
}
/**End of Challenge response **/

/********* Change password cipher **************/
int three_hash_cipher(uint8 *oldcrpw,uint8 *newcrpw,uint8 *cipherpw)
{
 pass_cipher(oldcrpw,newcrpw,cipherpw);
 pass_cipher(oldcrpw+8,newcrpw+8,cipherpw+8);
 return(NULL);
}
/********* End of Change password cipher *******/

/********* Decrypt remote password **************/
int RemoteNLMDecipher(char *cipher, char *decipher)
{
 return(DecryptRemotePassword(cipher,decipher));
}
/********* End of Decrypt remote password **************/

/** End of internal functions **/


#ifdef __cplusplus
}
#endif

#endif /* PAN_HASH_MED */
