/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * md-sparc.i -- Machine dependent uKernel code.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Fri Feb  9 15:20:17 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:30:40 1990
 * Update Count     : 103
 */

static inline void uCopy( void *src, void *dst, unsigned int len ) {
    bcopy( src, dst, len );
}

static inline void *uReadStackPointer() {

    void *addr;

    asm volatile ( "mov %%sp, %0" : "=r" (addr) );
    return( addr );
}

static inline void uWriteStackPointer( void *addr ) {
    asm volatile ( "mov %0, %%sp" : : "r" (addr) : "%sp" );
}

static inline void *uReadFramePointer() {

    void *addr;

    asm volatile ( "mov %%fp, %0" : "=r" (addr) );
    return( addr );
}

static inline void uWriteFramePointer( void *addr ) {
    asm volatile ( "mov %0, %%fp" : : "r" (addr) : "%fp" );
}

static inline void *uReadReturnAddress() {

    void *addr;

    asm volatile ( "mov %%i7, %0" : "=r" (addr) );
    return( addr );
}

static inline void uWriteReturnAddress( void *addr ) {
    asm volatile ( "mov %0, %%i7" : : "r" (addr) : "%i7" );
}

static inline void uCallUsingStack( void (*begin)() ) {

    /*
     * We must setup a correct SPARC stack frame.
     *
     * Load the first 6 arguments from the stack into
     * the registers o0, o1, o2, o3, o4, and o5, as the sparc
     * calling convention dictates.
     */
    
    asm volatile ( "mov %0, %%l0" : : "r" (begin) : "%l0" );
    asm volatile ( "ld [%%sp+0x44], %%o0" : : : "%o0" );
    asm volatile ( "ld [%%sp+0x48], %%o1" : : : "%o1" );
    asm volatile ( "ld [%%sp+0x4c], %%o2" : : : "%o2" );
    asm volatile ( "ld [%%sp+0x50], %%o3" : : : "%o3" );
    asm volatile ( "ld [%%sp+0x54], %%o4" : : : "%o4" );
    asm volatile ( "call %l0, 0" );
    asm volatile ( "ld [%%sp+0x58], %%o5" : : : "%o5" );
}

static inline void uMakeFrameUsingStack( uStack stack, void *buf, int len ) {

    /*
     * The frame pointer will be initialized to point to a WINDOWSIZE byte area
     * allocated at the end of the stack.
     *
     * The stack pointer will be initialized to point to a stack frame of a size
     * determined by the arglen passed to this routine.
     *
     * The size of the stack frame is MINFRAME + MAX(arglen - ARGPUSHSIZE, 0).
     * This allocates space for the window area, the structure return address,
     * the parameter register save area, and any extra parameters indicated
     * by arglen.
     * The parameters are then copied to (stack pointer + ARGPUSH).
     */

    stack->fp = stack->base - WINDOWSIZE;
    stack->sp = stack->fp - U_CEILING( MINFRAME + (len - ARGPUSHSIZE > 0 ? len - ARGPUSHSIZE : 0 ), sizeof( double ) );
    uCopy( buf, stack->sp + ARGPUSH, len );
} /* uMakeFrameUsingStack */

static inline void uPushFixedRegs() {

    /*
     * Save only those registers that the GCC machine
     * configuration files specify as being saved across
     * functions calls.
     *
     * In this case, it is handled by having the SPARC flush
     * all register windows.
     */

    asm volatile ( "ta 3" );
}

static inline void uPopFixedRegs() {

    /*
     * Restore the saved registers.
     *
     * The registers will be restored by the "restore" instruction at
     * the end of the calling routine.
     *
     * The register save area they are restored from is determined
     * by the frame pointer, which has already been restored from
     * the stack descriptor.
     */

}

static inline void uPushFloatRegs() {

    /*
     * Save only those registers that the GCC machine
     * configuration files specify as being saved across
     * functions calls.
     */

}

static inline void uPopFloatRegs() {

    /*
     * Restore the saved floating point registers.
     */

}

static inline void uSaveContext( register unsigned long* context ) {

    /*
     * must save frame pointer,
     *           stack pointer,
     *           instruction pointer,
     *           and registers which must be saved across procedure calls.
     */

    asm volatile ( "st %%sp, %0"  : "=m" (context[0]) );	      /* save current stack pointer */
    asm volatile ( "st %%fp, %0"  : "=m" (context[1]) );	      /* save old stack pointer */
    asm volatile ( "st %%i7, %0"  : "=m" (context[2]) );	      /* return address */
} /* uSaveContext */

static inline void uRestoreContext( register unsigned long* context ) {

    /*
     * must restore frame pointer,
     *           stack pointer,
     *           and registers which must be saved across procedure calls.
     *
     * First register windows are flushed to force an underflow when restore
     * is called.
     * the non-zero return value is setup, 
     * followed by a jump to the return address
     */

    asm volatile ( "ta 3" );
    asm volatile ( "ld %0, %%sp" : : "m" (context[0]) : "%sp");	     /* restore stack pointer */
    asm volatile ( "ld %0, %%fp" : : "m" (context[1]) : "%fp");	     /* restore frame pointer */
    asm volatile ( "ld %0, %%o7" : : "m" (context[2]) : "%o7" );     /* return address */
    asm volatile ( "mov 1, %%i0" : : : "%i0" );			     /* setup return result */
    asm volatile ( "retl" );					     /* return */
    asm volatile ( "restore" );	                                     /* cause a window underflow to restore registers */
} /* uRestoreContext */
