/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * md-ns32k.i -- Machine dependent uKernel code.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Thu Mar 15 10:56:29 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:30:39 1990
 * Update Count     : 22
 */

static inline void uCopy( void *src, void *dst, unsigned int len ) {
    asm volatile ( "movd %0, r1" : : "g" (src) : "r1" );
    asm volatile ( "movd %0, r2" : : "g" (dst) : "r2" );
    asm volatile ( "movd %0, r0" : : "g" (len) : "r0" );
    asm volatile ( "movsb" );
} /* uCopy */

static inline void *uReadStackPointer( void ) {

    void *addr;

    asm volatile ( "sprd sp, %0" : "=g" (addr) );
    return( addr );
} /* uReadStackPointer */

static inline void *uReadFramePointer( void ) {

    void *addr;

    asm volatile ( "sprd fp, %0" : "=g" (addr) );
    return( addr );
} /* uReadFramePointer */

/*
 * The following two routines clobber the stack pointer
 * and frame pointer respectively.  Therefore, it would
 * make sense that we use the clobber specification
 * to tell the compiler that we are going to clobber these
 * registers.  However, when we did that, the compiler thought
 * that after making a function call with arguments, the stack
 * pointer did not have to be reset, because we were going to
 * clobber it anyways.  But, we wanted to read the stack pointer
 * and frame pointer before we clobbered them.  Therefore, although
 * the GNU C compiler allows you to specify what registers you will
 * write to, we do not yet know how to specify which registers
 * we want to read from and whose values have to be intact.
 */

static inline void uWriteStackPointer( void *addr ) {
    asm volatile ( "lprd sp, %0" : : "g" (addr) );
} /* uWriteStackPointer */

static inline void uWriteFramePointer( void *addr ) {
    asm volatile ( "lprd fp, %0" : : "g" (addr) );
} /* uWriteFramePointer */

static inline void *uReadReturnAddress( void ) {

    void *addr;

    asm volatile ( "movd 4(fp), %0" : "=g" (addr) );
    return( addr );
} /* uReadReturnAddress */

static inline void uWriteReturnAddress( void *addr ) {
} /* uWriteReturnAddress */

static inline void uCallUsingStack( void (*begin)() ) {
    (*begin)();
} /* uCallUsingStack */

static inline void uMakeFrameUsingStack( uStack stack, void *buf, int len ) {
    stack->fp = stack->base;
    stack->sp = stack->fp - U_CEILING( len, sizeof( double ) );
    uCopy( buf, stack->sp, len );
} /* uMakeFrameUsingStack */
    
static inline void uPushFixedRegs( void ) {

    /*
     * Save only those registers that the GCC machine
     * configuration files specify as being saved across
     * functions calls.
     */

    asm volatile ( "save [r3,r4,r5,r6,r7]" );
} /* uPushFixedRegs */

static inline void uPopFixedRegs( void ) {

    /*
     * Restore the saved registers.
     */

    asm volatile ( "restore [r3,r4,r5,r6,r7]" );
} /* uPopFixedRegs */

static inline void uPushFloatRegs( void ) {

    /*
     * Save only those registers that the GCC machine
     * configuration files specify as being saved across
     * functions calls.
     */

    asm volatile ( "movf f4, tos" );
    asm volatile ( "movf f5, tos" );
    asm volatile ( "movf f6, tos" );
    asm volatile ( "movf f7, tos" );
} /* uPushFloatRegs */

static inline void uPopFloatRegs( void ) {

    /*
     * Restore the saved registers.
     */

    asm volatile ( "movf tos, f7" );
    asm volatile ( "movf tos, f6" );
    asm volatile ( "movf tos, f5" );
    asm volatile ( "movf tos, f4" );
} /* uPopFloatRegs */

static inline void uSaveContext( register unsigned long* context ) {

    /*
     * must save frame pointer,
     *           stack pointer,
     *           instruction pointer,
     *           and registers which must be saved across procedure calls.
     */

    asm volatile ( "movd 0(fp), %0" : "=m" (context[0]) );	      /* save old frame pointer */
    asm volatile ( "addr 4(fp), %0" : "=m" (context[1]) );	      /* sp to restore */
    asm volatile ( "movd 4(fp), %0" : "=m" (context[2]) );	      /* return address */
    asm volatile ( "movd r3, %0"    : "=m" (context[3]) );	      /* save registers */
    asm volatile ( "movd r4, %0"    : "=m" (context[4]) );
    asm volatile ( "movd r5, %0"    : "=m" (context[5]) );
    asm volatile ( "movd r6, %0"    : "=m" (context[6]) );
    asm volatile ( "movd r7, %0"    : "=m" (context[7]) );
} /* uSaveContext */

static inline void uRestoreContext( register unsigned long* context ) {

    /*
     * must restore frame pointer,
     *           stack pointer,
     *           and registers which must be saved across procedure calls.
     * the non-zero return value is setup, 
     * followed by a jump to the return address
     */

    asm volatile ( "lprd fp, %0" :: "m" (context[0]) : "fp" );	      /* restore frame pointer */
    asm volatile ( "lprd sp, %0" :: "m" (context[1]) : "sp" );	      /* restore stack pointer */
    asm volatile ( "movd %0, r3" :: "m" (context[3]) : "r3" );	      /* restore registers */
    asm volatile ( "movd %0, r4" :: "m" (context[4]) : "r4" );
    asm volatile ( "movd %0, r5" :: "m" (context[5]) : "r5" );
    asm volatile ( "movd %0, r6" :: "m" (context[6]) : "r6" );
    asm volatile ( "movd %0, r7" :: "m" (context[7]) : "r7" );
    asm volatile ( "movd %0, r1" :: "m" (context[2]) : "r1" );	      /* get return address */
    asm volatile ( "movd 1, r0"  ::: "r0" );			      /* setup result */
    asm volatile ( "jump 0(r1)" );				      /* jump back */
} /* uRestoreContext */
