#define BufferElemType uTask
#include "BoundedBufferPB.c"
/* #include "BoundedBufferAS.c" */
/* #include "BoundedBufferPIR.c" */ /* PIR */

/* #include "ReaderWriter3.c" */
#include "ReaderWriter4.c"
/* #include "ReaderWriter4aPB.c" */

void Euthanasia( int NoOfProcesses ) {
    int i;
    uTask temp;
    
    for ( i = 1; i <= NoOfProcesses; i += 1 ) {
	/* qremove( &temp ); */ /* PIR */
	/* uAbsorb( temp, NULL, 0 ); */ /* PIR */
	uAbsorb( qremove( ), NULL, 0 );
    } /* for */
    uDie( NULL, 0 );
} /* Euthanasia */

int SharedVar = 0;					/* shared variable to test readers and writers */

void Reader( ) {
    StartRead( );
    /* this print violates the monitor by referencing its internal variables */
    uPrintf( "Reader:%x, shared:%2d, concurrent readers:%2d, writers:%2d\n", uThisTask( ), SharedVar, ReadCount, WriteUsage );
    uDelay( 3 );
    EndRead( );
    qinsert( uThisTask( ) );				/* ask to be terminated */
    uDie( NULL, 0 );
} /* Reader */

void Writer( ) {
    StartWrite(  );
    SharedVar += 1;
    /* this print violates the monitor by referencing its internal variables */
    uPrintf( "Writer:%x, wrote: %2d, concurrent readers:%2d, writers:%2d\n", uThisTask( ), SharedVar, ReadCount, WriteUsage );
    uDelay( 1 );
    EndWrite(  );
    qinsert( uThisTask( ) );				/* ask to be terminated */
    uDie( NULL, 0 );
} /* Writer */

#define MaxProcess 1000

void uMain( ) {
    uTask euthanasia;
    int i;
    
    euthanasia = uEmit( Euthanasia, MaxProcess );
    for ( i = 0; i < MaxProcess; i += 1 ) {
	if ( random(  ) % 10 < 7 ) {			/* 70% of processes are readers */
	    uEmit( Reader );				/* start reader */
	} else {
	    uEmit( Writer );				/* start writer */
	} /* if */
	uDelay( 4 );
    } /* for */
    uAbsorb( euthanasia, NULL, 0 );
    uPrintf( "successful completion\n" );
} /* uMain */
