/* Monitor Program Example 1, 2 & 3 */
/* Copyright (c) 1986  P. A. Buhr */

/*
  Bounded buffer problem
  
  Two processes communicate through a unidirectional queue of finite
  length. A monitor is used to ensure that should the queue fill,
  the producer will wait until some free queue element appears.
  As well, if the queue is empty the consumer will wait until some
  element appears.
  */

#define BufferElemType int
#include "BoundedBufferPB.c"
/* #include "BoundedBufferAS.c" */
/* #include "BoundedBufferPIR.c" */ /* PIR */

void producer() {
    int i; /* loop counter */
    int N;
    
    for (i = 1; i <= 100; i += 1) {			/* produce a bunch of items */
	N = (abs(random()) % 100 + 1) + N;		/* produce a monotonic increasing positive random number */
	uPrintf(" Producer:%d, value:%d\n", uThisTask(), N);
	qinsert(N);					/* insert element into queue */
    } /* for */
    N = -1;						/* terminate production, indicate with negative value */
    uPrintf("Producer:%d, value:%d\n", uThisTask(), N);
    qinsert(N);
    uDie(NULL, 0);
} /* producer */

void consumer() {
    int N;
    
    /* consume until a negative element appears */
    
    do {
	N = qremove();					/* remove from front of queue */
	/* qremove(&N); */ /* PIR */
	uPrintf("Consumer :%d, value:%d\n", uThisTask(), N);
    } while (N > 0);
    uDie(NULL, 0);
} /* consumer */

void uMain() {
    uTask t0, t1;
    
    t0 = uEmit(producer);				/* start process */
    t1 = uEmit(consumer);				/* start process */
    
    uAbsorb(t0, NULL, 0);				/* wait for completion of process */
    uAbsorb(t1, NULL, 0);				/* wait for completion of process */
    uPrintf("successful completion\n");
} /* main */
