# This is an OS specific configuration file
#	It assumes that OBJDIR, TARGET and DEBUG are previously defined.
#	It defines	CFLAGS, LDARGS, CPPFLAGS, STARTUPFILE, LDOBJS
#	It augments	SRC, OBJDIR, TARGET, CFLAGS, LDLIBS
#
OSRELEASE *= mscdos
# Memory model to compile for
# set to s - small, m - medium, c - compact, l - large
.IF $(DEBUG)
   MODEL = l
.ELSE
   MODEL = c
.END

STARTUPFILE	= $(OS)/startup.mk

CPPFLAGS 	= $(CFLAGS)
LDOBJS		= $(CSTARTUP) $(OBJDIR)/{$(<:f)}
LDARGS		= @$(LDTMPOBJ),$(TARGET),NUL.MAP$(LDTAIL)
LDTAIL		= ,@$(LDTMPLIB)$(LDFLAGS),$(OS)\$(TARGET:b).def
LDTMPOBJ	= <+$(LDOBJS:s,/,\\,:t"+\n")+>
LDTMPLIB	= <+$(LDLIBS:s,/,\\,:t"+\n")+>

# Debug flags
DB_CFLAGS	= -DDBUG
DB_LDFLAGS	= /ST:8000
DB_LDLIBS	=

# NO Debug flags
NDB_CFLAGS	= -B2 C2L -WX # -B3 C3L
NDB_LDFLAGS	= /ST:8000
NDB_LDLIBS	=

# Local configuration modifications for CFLAGS.
CFLAGS         += -I$(OS) -DOS2

# OS2 does not have a swap version. The operating system will
# handle all swapping.
# To save copying unchanged files in from elsewhere, I shall use them in situ.
OS_SRC  += ruletab.c runargv.c _chdir.c switchar.c
DOS_SRC = dirbrk.c arlib.c
UNIX_SRC = rmprq.c explode.c

SRC += $(OS_SRC) $(DOS_SRC) $(UNIX_SRC)
.SETDIR=$(OS) : $(ASRC) $(OS_SRC)
.SETDIR=msdos : $(DOS_SRC)
.SETDIR=unix : $(UNIX_SRC)

# Set source dirs so that we can find files named in this
# config file.
.SOURCE.h : $(OS)

# See if we modify anything in the lower levels.
.IF $(OSRELEASE) != $(NULL)
   .INCLUDE .IGNORE : $(OS)$(DIRSEPSTR)$(OSRELEASE)$(DIRSEPSTR)config.mk
.END

# Set the proper macros based on whether we are making the debugging version
# or not.
.IF $(DEBUG)
   CFLAGS	+= $(DB_CFLAGS)
   LDFLAGS	+= $(DB_LDFLAGS)
   LDLIBS	+= $(DB_LDLIBS)

   SILENT	:= $(.SILENT)
   .SILENT	:= yes
   TARGET	:= db$(TARGET)
   OBJDIR	:= $(OBJDIR).dbg
   .SILENT	:= $(SILENT)

   SRC		+= dbug.c malloc.c
   HDR		+= db.h 

   .SOURCE.c : common
   .SOURCE.h : common
.ELSE
   CFLAGS	+= $(NDB_CFLAGS)
   LDFLAGS	+= $(NDB_LDFLAGS)
   LDLIBS	+= $(NDB_LDLIBS)
.END

