/* $Header: uti.c,v 1.4 92/08/04 15:07:34 salty Exp $ */

/**************************************************************************
 *                 ****** ISTK Release 1.2 *****                          *
 *                                                                        *
 *                                                                        *
 * This code has been produced by numerous authors at the CERN centre for *
 * high energy physics, Geneve, Switzerland, at the SSC laboratory in     *
 * Dallas, Texas, USA and at the Lawrence Berekeley Laboratory in         *
 * California, USA.                                                       *
 * The latter two institutions perform work under US Government contract. *
 * The intent of the work is to provide useful code for people who need   *
 * it, with an emphasis on free and collaborative exchange of ideas,      *
 * techniques and implementations.                                        *
 * Please read the disclaimer and copyright notices contained in the ISTK *
 * distribution and in distributed applications.                          *
 *                                                                        *
 **************************************************************************/



/* Reference release  Aug 10 1991 - C G Saltmarsh */
/* Has the basics used at CDG & SSC 1988-1991, plus vxworks
   support
*/

/************************************************************************
 *                           
 *      Copyright (C) Frogsoft Corporation, 1986      
 *                           
 *     This library contains Proprietary Information of Frogsoft   
 *   Corporation and should not be treated as Confidential.      
 *                           
 *                general  utility  library                    
 *                           
 *                authors:  probably many                               
 *       
 ************************************************************************/

#include <stdlib.h>
#include <string.h>

#ifndef vms
#include <unistd.h>
#endif

#if defined(vms)
#include "sdsgen.h"
#include "sds_externs.h"
#else
#include "Sds/sdsgen.h"
#include "Sds/sds_externs.h"
#endif

/********* forward declarations ************/
#if defined(__STDC__)
void inttoa(int, char *);
void reverse(char *);
void top_win();
void bot_win();
int  htoi(char *);
#else
void inttoa();
void reverse();
void top_win();
void bot_win();
int  htoi();
#endif
     
#if !defined(__hpux__) && !defined(hpux)
/************************************************************************
 * hp ux has its own ltoa, which does the right thing. The gnu
 * loader has problems with multiple definitions.
 ************************************************************************/
void
ltoa(n,s)
/************************************************************************
 * converts an integer n into ascii string s                  
 * Author:  Kernighan and Ritchie 
 ************************************************************************/
char    s[];
long    n;
{
  int i;
  long sign;
  if((sign = n) < 0)
     n = -n;
  i = 0;
  do   
  {
    s[i++] = n % 10L + '0';
  }  while ((n /= 10L) > 0);
  if(sign<0L)   
		s[i++] = '-';
  s[i] = '\0';
  reverse(s);
}
#endif /* not hpux */

void
inttoa(n,s)
/************************************************************************
 * converts an integer n into ascii string s                  *
 * Author:  Kernighan and Ritchie               */
/************************************************************************/
char    s[];
int     n;
{
  int i, sign;
  if((sign = n) < 0)
     n = -n;
  i = 0;
  do   
  {
    s[i++] = n % 10 + '0';
  }  while ((n /= 10) > 0);
  if(sign<0)  s[i++] = '-';
  s[i] = '\0';
  reverse(s);
}
void
reverse(s)
/************************************************************************
 *     reverses the ascii string s                            *
 *     Author:  Kernighan and Ritchie                         */
/************************************************************************/
char s[];
{
  int c,i,j;
     
  for (i = 0, j = (int)strlen(s) -1 ; i<j; i++, j--) 
  {
     c = s[i];
     s[i] = s[j];
     s[j] = c;
  }
}
#if !defined(psos)
/* pSOS has no fildes equiv */
/************************************************************************/
off_t ffsiz(fildes)
int   fildes;
/************************************************************************/
{
   struct   stat   buf;
   int   i;
     
   i = fstat(fildes,&buf);
   if (i != 0 ) 
		 return(-1);
   return(buf.st_size);
}
     
/************************************************************************/
off_t fsiz(path)
char   *path;
/************************************************************************/
{
   struct   stat   buf;
   int   i;
     
   i = stat(path,&buf);
   if (i != 0 ) 
		 return(-1);
   return(buf.st_size);
}
#endif
/* psos without fileds */
/************************************************************************/
/*  SUN: push your window to front!!!              */
void
top_win(){ printf("%c%c%c%c",(char)27,(char)91,(char)53,(char)116); }
/************************************************************************/
/************************************************************************/
/*  ZERO prizes..........            */
void
bot_win(){ printf("%c%c%c%c",(char)27,(char)91,(char)54,(char)116); }
/************************************************************************/
int
htoi(string)
char   *string;
{
 
   int    i;
   sscanf(string,"%x",&i);
   return(i);
}
/************************************************************************/
int
sds_namelist(to,from,delim)
char  *to,*from,delim;
/************************************************************************/
{
  int  count = 1;
  char  *f = from,*t = to;

  if ((*t = *f) == (char)0)
    return(0);
  while (*f != (char)0) 
  {
    *t = *f;
    if (*f == delim) 
    {
      *t = (char)0;
      count++;
    }
    f++;
    t++;
  }
  *t = (char)0;
  return(count);
}
int
get_size(input)
char  *input;
{

  int size,i=0;

  if (input[(int)strlen(input)-1] != 'k') 
  {
    size = atoi(input);
  }
  else 
  {
    input[(int)strlen(input)-1] = (char)0;
    size = atoi(input) << 10;
  }
  if (size > 0 ) 
    while ((1 << i++) < size);
      size = 1 << --i;
  return(size);
}
int
r_get_size(input)
char  *input;
{

  int size;

  if (input[(int)strlen(input)-1] != 'k') 
  {
    size = atoi(input);
  }
  else 
  {
    input[(int)strlen(input)-1] = (char)0;
    size = atoi(input) << 10;
  }
  return(size);
}

#ifdef vxworks
#include <vxWorks.h>

/***********************************************************************/
long 
time(tloc)
long *tloc;
/***********************************************************************/
{
  return ((long) 0);
}
/***********************************************************************/
char *
ctime(clock)
long *clock;
/***********************************************************************/
{
  return ((char *) 0);
}
/***********************************************************************/
int 
atoi(str)
char *str;
/***********************************************************************/
{
  int result;

  sscanf(str,"%d", &result);
  return(result);
}

#endif  /* Vxworks stuff */

/***********************************************************************/

/***********************************************************************/
int
sds_read_data(fd,ptr,nbytes)
int fd;
char *ptr;
int nbytes;
/***********************************************************************/
{
  int nleft, nread;

  nleft = nbytes;
  while (nleft > 0) 
  {
    nread = read(fd,ptr,nleft);
    if (nread < 0) 
    {
      return(nread);    /* error, return < 0 */
    }
    else if (nread == 0) 
    {
      return ( -1);    /* Treat like an error. */
    }
    nleft -= nread;
    ptr   += nread;
  }
  return(nbytes);
}


/***********************************************************************/
int
sds_write_data(fd,ptr,nbytes)
int fd;
char *ptr;
int nbytes;
/***********************************************************************/
{
  int nleft, nwritten;

  nleft = nbytes;
  while (nleft != 0) 
  {
    nwritten = write(fd,ptr,nleft);

#ifdef vxworks
    if (nwritten < 0) 
    {
      return(nwritten);    /* error */
    }
#else
    if (nwritten <= 0) 
    {
      return(nwritten);    /* error */
    }
#endif
    nleft -= nwritten;
    ptr   += nwritten;
  }
  return(nbytes);
}


