/* $Header: sds_map.c,v 1.14 93/01/13 12:41:35 salty Exp $ */

#if defined(vms)
#include "sdsgen.h"
#else
#include "Sds/sdsgen.h"
#endif

#ifndef MEMMAP /* mmap() not available for this architecture */

sds_handle
sds_map(source_name, access)
char *source_name;
sds_code access;
{
  fprintf(stderr, "mmap mapping routines not available for this machine\n");
  exit(1);
}

sds_handle
sds_adaptive_map(source_name, number, access, datafilenames, offsets, sizes)
char *source_name;
int number;
sds_code access;
char **datafilenames;
int *offsets;
int *sizes;
{
  fprintf(stderr, "mmap mapping routines not available for this machine\n");
  exit(1);
}

#else /* mmap() is available */

#include <string.h>
#include <stdlib.h>
#include <memory.h>

#ifndef vms
#include <unistd.h>
#endif

#include <malloc.h>
#include <sys/mman.h>

#include "Sds/sds_externs.h"

char      *sds_mappit();
sds_handle sds_adaptive_map();

extern int sds_error;
extern int load_source[];

#if defined(sgi)
extern int munmap (void *, int );
#else
#ifdef __STDC__
extern int munmap(caddr_t, int);
#else
extern int munmap();
#endif
#endif

sds_handle
sds_map(source_name, access)
char *source_name; /* filename of source dataset */
sds_code access; /* SDS_READ,SDS_WRITE */
{
  struct sds_header *sdsh;
  char              *dir;
  char              *dataddress;
  sds_handle         sds;
  caddr_t            sds_header;
  off_t              sds_size;
	struct direc *dptr;


  sds = next_sds(); /* Any sds space left? */
  if (sds < 0)
    return sds_error = sds;

  if ((dataddress = sds_mappit(source_name, access, &sds_size, 0)) == NULL)
    return sds_error;
  dptr = sds_direc_ptr(sds);
  dptr[0].illoca = SDS_DISJOINT_OBJECT;
  sds_header = (caddr_t)dataddress;

  sdsh = (struct sds_header *)sds_header;
  /* Check to see if the thing actually is an SDS for this architecture. If
  it is an SDS but for some other architecture, straight mapping will not
  help...we have to convert; so that is left to higher-level code invoking
  a conversion load to memory, for instance.
   */
  if (sdsh->magic_number != SDS_MAGIC)
  {
    if ((sdsh->magic_number & 0xffff00ff) == SDS_BASE_MAGIC)
      sds_error = SDS_WRONG_PADS;
    else if ((sdsh->magic_number & 0xff00ffff) == SDS_MAGIC_BYTESWAP)
      sds_error = SDS_SWAPPED_BYTES;
    else
      sds_error = SDS_NOT_SDS;
    munmap(sds_header, sds_size);
    return sds_error;
  }

  /* OK, the object is the right sort. Find where the directory is and
  register with the SDS system variables.
   */
  dir = (char *)sdsh + BASE_OFFSET +
                        (int)sdsh->list_size + 
                        (int)sdsh->heap_size;

  set_sys_vars(sds,(struct direc *)dir);
  load_source[sds] = SDS_MAPPED_MEM;

  return sds;
}

sds_handle
sds_adaptive_map(source_name, number, access, datafilenames, offset, size)
char *source_name;
int number;
sds_code access;
char **datafilenames;
int *offset;
int *size;
{
  char **dataddress;
  sds_handle status;
  int i,j = 1;
  struct direc *dptr;
  sds_handle sds = sds_use(source_name, SDS_FILE, access);
  int NElems;
  int allocated = 0;
  int *sizes;
  int *offsets;
  struct sds_odesc *things;
  char *filename;

  if (sds < 0)
    return sds_error = sds;
  dptr = sds_direc_ptr(sds);
  NElems = dptr[0].nelems;

  dataddress = (char **)calloc(NElems, sizeof(char *));
  if (number != NElems)
  {
    allocated = 1;
    sizes = (int *)calloc(NElems, sizeof(int));
    offsets = (int *)calloc(NElems, sizeof(int));
    memcpy(offsets,offset,number * sizeof(char *));
    memcpy(sizes,size,number * sizeof(int));
  }
  else
  {
    sizes = size;
    offsets = offset;
  }
 
  /* ...but the disjoint flag may not be there for older headers:
     in that case, all objects are mapped from one file 
   */
  if (number == 1 && datafilenames != NULL &&
			!strcmp(datafilenames[0], "Internal"))
  {
    /* we try to find that mapping file from a descritive object inside
    this header..
    */
    int size, date;
    if  ((filename = sds_searchmapfile(sds, &size, &date)) == NULL)
      return sds_error = SDS_NO_MAP_FILE;
    if (sds_mapfilecheck(filename, size, date) < 0)
      return sds_error;
    dataddress[1] = sds_mappit(filename, access, &sizes[1],offsets[1]);
  }
  else if (number == 1 && datafilenames != NULL &&  datafilenames[0] != NULL)
  {
     dataddress[1] = sds_mappit(datafilenames[0], access,
                          &sizes[1],offsets[1]);
  }
  else
  {
    if (sizes[0] == 0)
    {
      struct sds_header *sdsh = get_header(sds);
      sizes[0] = fsiz(source_name);
    }

    for (i=1;i<dptr[0].nelems;i++)
    {
      dataddress[i] = 0;
      if (i <= number && datafilenames[i] != NULL)
      {
        if ((dataddress[i] = sds_mappit(datafilenames[i],
                          access, &sizes[i],offsets[i])) == NULL)
        {
          sds_destroy(sds);
          if (allocated)
            free(sizes);
          free(dataddress);
          return sds_error;
         }
         else
         {
           dptr[i].illoca = SDS_DISJOINT_OBJECT;
         }
       }
    }
  }
  /* Now fill all the offsets, and scan variable size data if necessary */
  status = offil(sds, dataddress, NElems, sizes);
  load_source[sds] = SDS_MAPPED_MEM;

  if (allocated)
    free(sizes);
  free(dataddress);
  return sds;
}

char *
sds_mappit(source_name, access, size, offset)
char *source_name;
int access, offset;
off_t *size;
{
  int                status;
  int                prot;
  int                share    = MAP_SHARED;
  int                fd;

    /* fsiz() does an fstat on the file & returns size
       in bytes, or -1 if the file does not exist. It
       does not check to see if the file IS an SDS   
     */
  if (*size == 0) /* I will try to find out from the file itself */
  {
    if ((*size = fsiz(source_name)) == -1) 
    {
      sds_error = SDS_NO_SUCH_SDS;
      return NULL;
    }
  }

  if (access == SDS_WRITE)
  {
    access = O_RDWR;
    prot = PROT_READ|PROT_WRITE;
  }
  else
  {
    access = O_RDONLY;
    prot = PROT_READ;
  }

  if ((fd = open(source_name, access, 0x666)) == -1)
  {
    if (access == O_RDWR)
      fprintf (stderr,"open()'ing %s for read/write in sds_map(): ",
                      source_name);
    else
      fprintf (stderr,"open()'ing %s for read only in sds_map(): ",
                      source_name);
    perror(0);
    exit(1);
  }

  /*  Map the file (it exists and is accesible) into memory. Allow the
  system to choose where (returned in status); tell it how big, and the
  protection/access flags. 
   */
  if ((status = (int)mmap (0, *size, prot, share, fd, offset)) == -1 )
  {
    perror("mmap()'ing in sds_map()");
    exit(1);
  }
  close(fd);
  return (char *)status;
}

char *
sds_searchmapfile(sds, size, mod_date)
sds_handle sds;
int *size,*mod_date;
{
  sds_handle obind;
  int level;
  char *filename = NULL;
	struct sds_odesc *things;

  if ((obind = sds_oblike2ind(sds,"DisjointFile", 1)) < 0)
	{
     sds_error = SDS_NO_MAP_FILE;
		 return NULL;
	}
  while ((level = sds_describe(sds,obind,&things)) >= 0)
  {
    if (!strcmp(things[level].name, "filename"))
      filename = things[level].address;
    if (!strcmp(things[level].name, "mod_date"))
      *mod_date = *(int *)things[level].address;
    if (!strcmp(things[level].name, "size"))
      *size = *(int *)things[level].address;
  }
  return filename;
}

sds_handle
sds_mapfilecheck(filename, size, date) 
char *filename;
int size, date;
{
  struct stat databuf;
  int err = 0;

  if (stat(filename, &databuf) == -1)
    return sds_error = SDS_FILE_OP;
  if (databuf.st_mtime != date)
  {
    fprintf(stderr,"Mapped file %s has been modified since scan\n", filename);
    err = 1;
  }
  if (databuf.st_size != size)
  {
    fprintf(stderr,"Mapped file %s has changed size since scan\n", filename);
    err += 2;
  }
  return err;
}

#endif  /* I do have mmap() available */
