/* $Header: sds_fort.c,v 1.5 93/01/14 11:00:38 vern Exp $ */

/**************************************************************************
 *                 ****** ISTK Release 1.2 *****                          *
 *                                                                        *
 *                                                                        *
 * This code has been produced by numerous authors at the CERN centre for *
 * high energy physics, Geneve, Switzerland, at the SSC laboratory in     *
 * Dallas, Texas, USA and at the Lawrence Berekeley Laboratory in         *
 * California, USA.                                                       *
 * The latter two institutions perform work under US Government contract. *
 * The intent of the work is to provide useful code for people who need   *
 * it, with an emphasis on free and collaborative exchange of ideas,      *
 * techniques and implementations.                                        *
 * Please read the disclaimer and copyright notices contained in the ISTK *
 * distribution and in distributed applications.                          *
 *                                                                        *
 **************************************************************************/


/* Reference release  Aug 10 1991 - C G Saltmarsh */
/* Has the basics used at CDG & SSC 1988-1991, plus vxworks
   support
*/


/**** FORTRAN ACCESS CALLS *******************************************/
/*    All are functions returning a 4-byte integer : ie i*4
 *   basic rules for error returns are:
 *
 *  1 (ONE), the thing Bertrand Russell was worried about, is
 *    *** GOOD ***
 *  Even (bit 1 zero) is bad, usually fatal unless recoverable file
 *  name problem.
 *  
 *  SDS stands for 'standard dataset'.
 *
 *  It should be noted that all of this is conceptually MUCH
 *  CLEANER if a proper programming language such as C, Pascal,
 *  Modula whatever, is used.
 *  
 *  Most calls are simple interfaces to underlying C-routines.
 *  VMS-Fortran names are SDS_F**** where the C name is sds_***.
 *  F77 names are a mess.
 *  
 *  STATUS RETURNS:
 *  
 *  1  Everthing is wonderful.
 *  2   SDS_NO_SUCH_SDS            No such SDS
 *  4   SDS_NO_SPC                 No space for SDS directory 
 *                                         (current limit is 16)
 *  6   SDS_FILE_OP                Cannot open file
 *  8   SDS_FILE_WR                Cannot write to file
 *  10  SDS_NO_SUCH_OBJ            No such object in SDS
 *  12  SDS_FILE_RD                Cannot read file
 *  14  SDS_NOT_SDS                File is not an SDS
 *  16  SDS_VERSION                File is old SDS version
 *  18  SDS_FILE_NOP               No file open
 *  20  SDS_SWAPPED_BYTES          Sds with bytes the wrong way round
 *  22  SDS_NOT_ASS                SDS not assembled
 *  24  SDS_NOT_INITIALISED        Guess
 *  26  SDS_UNDEFINED_TYPE         Object type is not defined.
 *  28  SDS_NOT_DEFINABLE          You can't redefine an dataset you
 *                                 haven't started yourself.
 *  30  SDS_DEJA_LA                The named dataset already exists.
 *  32  SDS_TRANSFER_UNDEF         Transfer type unknown (eg SDS_TAPEFILE
 *                                           is not known on this version).
 *  34  SDS_WRONG_TYPE             Element type not as requested.
 *  36  SDS_WRONG_PADS             Wrong padding type.
 *  38  SDS_NO_MEM                 Not enough memory.
 *  40  SDS_NO_DB_PROC             No db - process assigned.
 *  42  SDS_DB_ACCESS              Database access error.
 *  44  SDS_NOT_COMPLEX_OBJECT     Not a complex object.
 *  46  SDS_WRONG_RES_LIST         Mixed up resolution lists
 *  48  SDS_ZERO_LENGTH            Structure is defined,but no data allocated
 *  
 *********************************************************************/

#include <stdlib.h>
#include <string.h>

#ifndef vms
#include <unistd.h>
#endif

#if defined(vms)
#include "sdsgen.h"
#include "sds_externs.h"
#else
#include "Sds/sdsgen.h"
#include "Sds/sds_externs.h"
#endif

char  cstring[256];
extern int sds_error;

/********** forward declarations **************/

#ifndef vms

#if defined(__STDC__)

int  getc_from_f(char *,char *,int*);
int  getf_from_c(char *,char *,int*);
void unzterm(char *,int);
void zterm(char *);

#else /* not STDC */

int  getc_from_f();
int  getf_from_c();
void unzterm();
void zterm();

#endif /* not STDC */

extern int  sds_dbrow_ins();
extern int  sds_dbtab_make();

#else /* in vms */
/*  Zap out the sybase access routines  */
int sds_dbrow_ins(){};
int sds_dbtab_make(){};
#endif

extern struct type_list *string_type_list;

#ifdef vms
struct vms_fstring {
  short len;
  short code;
  char   *string;
  };
#endif

/*********************************************************************/
/*  SDS_MTAB 
 *  Make an SDS from db table specification.
 *
 *********************************************************************/
#ifdef vms
/**************** VMS_FORTRAN ****************************************/
int
sds_mtab(sds,nrows,basename,tlist,select_list)
int  *sds,*nrows;
struct  type_list  *tlist;
char  *basename,*select_list;
{
  int  baselen,sellen;
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_mtab_(sds,nrows,basename,tlist,select_list,baselen,sellen)
int  *sds,*nrows,baselen,sellen;
struct  type_list  **tlist;
char  *basename,*select_list;
{
#endif
  char  sel[128];

  getc_from_f(&cstring[0],basename,&baselen);  
  getc_from_f(sel,select_list,&sellen);  
  *sds = sds_dbtab_make(*nrows,cstring,*tlist,sel);
  if (*sds < 0) return(-2*(*sds));
  else return(1);
}
/*********************************************************************/
/*  SDS_rowin
 *  Put a row into an SDS created by SDS_MTAB
 *
 *  
 *********************************************************************/
#ifdef vms
/**************** VMS_FORTRAN ****************************************/
int
sds_rowin(sds,pointer)
int  *sds;
char  *pointer;
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_rowin_(sds,pointer)
int  *sds;
char  *pointer;
#endif
{
  int  ret = sds_dbrow_ins(*sds,pointer);
  if (ret < 0) return(-2*ret);
  else return(1);
}
/*********************************************************************/
/*  SDS_FINIT
 *  initialise sds . MUST be called before using sds services
 *
 *  
 *********************************************************************/
#ifdef vms
/**************** VMS_FORTRAN ****************************************/
int
sds_finit()
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_finit_()
#endif
{
  sds_init();
  return(1);
}
/*********************************************************************/
/*  SDS_DEATH
 *
 *  Print system error and exit.
 *      SDS_DEATH("from boredom")
 *
 *  
 *********************************************************************/
#ifdef vms
/**************** VMS_FORTRAN ****************************************/
int
sds_death(name)
char *name;
{
  int  length;
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_death_(name,length)
char *name;
int  length;
{
#endif
  getc_from_f(cstring,name,&length);  
  sds_perror(cstring);
  exit((char)sds_error);
	return 1;
}
/*********************************************************************/
/*  SDS_FSTART
 *  start a new SDS of name 'name' or returns sds index
 *  of existing sds.
 *
 *      ISTATUS = SDS_FSTART("fred",sds)
 *
 *  Builds a new sds directory called "fred": the
 *  program may now fill this SDS with calls to 
 *  SDS_DECLARE.
 *  
 *  
 *********************************************************************/
#ifdef vms
/**************** VMS_FORTRAN ****************************************/
int
sds_fstart(name,sds)
char *name;
int  *sds;
{
  int  length;
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_fstart_(name,sds,length)
char *name;
int  length,*sds;
{
#endif
  getc_from_f(cstring,name,&length);  
  *sds = sds_new_index(cstring);
  if (*sds < 0) return(-2*(*sds));
  else return(1);
}
/*********************************************************************/
/*  SDS_FTSTAMP
 *  Put a timestamp on a dataset (OBJ_IND = 0)
 *  on a single object (OBJ_IND = object number)
 *  or on dataset and all objects (OBJ_IND = SDS_TIMESTAMP_ALL)
 *
 *      ISTATUS = SDS_FTSTAMP(sds,OBJ_IND)
 *
 *  
 *********************************************************************/
#ifdef vms
/**************** VMS_FORTRAN ****************************************/
int
sds_ftstamp(sds,obj_ind)
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_ftstamp_(sds,obj_ind)
#endif
int  *sds,*obj_ind;
{ 
  int ret = sds_tstamp(*sds,*obj_ind);
  if (ret < 0) return(-2*ret);
  else return(1);
}
/*********************************************************************/
/*  SDS_FEND
 *  Delete directory of SDS sds
 *
 *      ISTATUS = SDS_FEND(4)
 *
 *  Deletes sds 4
 *  
 *  
 *********************************************************************/
#ifdef vms
int
sds_fend(sds)
#else
int
sds_fend_(sds)
#endif
int  *sds;
{ 
  sds_discard(*sds);
  return(1);
}
/*********************************************************************/
/*  SDS_FDECLARE
 *  Declare an object to be in an sds
 *
 *  integer*2  IARR(100)
 *  integer*4  OBJ_IND
 *     c  .......
 *      ISTATUS = SDS_FDECLARE(1,IARR,"MYARRAY",100,SDS_WORD,OBJ_IND)
 *
 *  Declares first 100 elements of 2-byte integer array IARR to be part of
 *  SDS 1; its name in that SDS will be MYARRAY.
 *  The object index is returned in OBJ_IND.
 *
 *  Memory for an object may be allocated at runtime by the underlying
 *  software. Unfortunatly, there is no (standard) way to tell Fortran
 *  where such an object is, so if you want runtime memory allocation
 *  either wait until a solution is cobbled up or, better still, use
 *  C. 
 *  
 *    
 *    
 *********************************************************************/
#ifdef vms
/**************** VMS_FORTRAN ****************************************/
int
sds_fdeclare(sds,obj_ptr,name,nelems,elemcod,obj_index)
long  *sds,*elemcod,*nelems,*obj_index;
char  *obj_ptr,*name;
{
  int  length,leno;
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_fdeclare_(sds,obj_ptr,name,nelems,elemcod,obj_index,leno,length)
int  *sds,*elemcod,*nelems,length,leno,*obj_index;
char  *obj_ptr,*name;
{
#endif
  char  *pass_ptr = obj_ptr;
  long  ec = *elemcod;

  if (ec == SDS_STRING) {
#ifdef vms
    struct vms_fstring *obj = (struct vms_fstring*)pass_ptr;
    leno = (int)obj->len;
    pass_ptr = obj->string;
#endif
    string_type_list[0].nelems = (long)leno;
    ec = sds_define_object(*sds,string_type_list,"dim1,dim2");
  }
  getc_from_f(&cstring[0],name,&length);  
  *obj_index = 
    sds_declare_object(*sds,pass_ptr,cstring,*nelems,ec);
  if (*obj_index < 0) return(-2*(*obj_index));
  else return(1);
}
/*********************************************************************/
/*  SDS_TWOD_FDECLARE 
 *  Declare an 2-d array to be in an sds
 *
 *  integer*2  IARR(100,20)
 *  integer*4  OBJ_IND
 *     c  .......
 *      ISTATUS = SDS_TWOD_FDECLARE(1,IARR,"MYARRAY",100,20,SDS_WORD,OBJ_IND)
 *
 *  The object index is returned in OBJ_IND.
 *
 *    
 *********************************************************************/
#ifdef vms
/**************** VMS_FORTRAN ****************************************/
int
sds_twod_fdeclare(sds,obj_ptr,name,n1,n2,elemcod,obj_index)
long  *sds,*elemcod,*n1,*n2,*obj_index;
char  *obj_ptr,*name;
{
  int  length,leno;
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_twod_fdeclare_(sds,obj_ptr,name,n1,n2,elemcod,obj_index,length,leno)
int  *sds,*elemcod,*n1,*n2,length,leno,*obj_index;
char  *obj_ptr,*name;
{
#endif
  char  *pass_ptr = obj_ptr;
  long  ec = *elemcod;

  if (ec == SDS_STRING) {
#ifdef vms
    struct vms_fstring *obj = (struct vms_fstring*)pass_ptr;
    leno = (int)obj->len;
    pass_ptr = obj->string;
#endif
    string_type_list[0].nelems = leno;
    ec = sds_tlist_add(*sds,string_type_list);
  }
  getc_from_f(&cstring[0],name,&length);  
  *obj_index = sds_twod_declare(*sds,pass_ptr,cstring,*n2,*n1,ec);
  if (*obj_index < 0) return(-2*(*obj_index));
  else return(1);
}
/*********************************************************************/
/*  SDS_THREED_FDECLARE 
 *  Declare an 3-d array to be in an sds
 *
 *  integer*2  IARR(100,20,10)
 *  integer*4  OBJ_IND
 *     c  .......
 *      ISTATUS = SDS_THREED_FDECLARE(1,IARR,"MYARRAY",100,20,10,SDS_WORD,OBJ_IND)
 *
 *  The object index is returned in OBJ_IND.
 *
 *    
 *********************************************************************/
/**************** VMS_FORTRAN ****************************************/
#ifdef vms
int
sds_threed_fdeclare(sds,obj_ptr,name,n1,n2,n3,elemcod,obj_index)
long  *sds,*elemcod,*n1,*n2,*n3,*obj_index;
char  *obj_ptr,*name;
{
  int  length,leno;
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_threed_fdeclare_(sds,obj_ptr,name,n1,n2,n3,elemcod,obj_index,length,leno)
int  *sds,*elemcod,*n1,*n2,*n3,length,leno,*obj_index;
char  *obj_ptr,*name;
{
#endif
  char  *pass_ptr = obj_ptr;
  long  ec = *elemcod;

  if (ec == SDS_STRING) {
#ifdef vms
    struct vms_fstring *obj = (struct vms_fstring*)pass_ptr;
    leno = (int)obj->len;
    pass_ptr = obj->string;
#endif
    string_type_list[0].nelems = leno;
    ec = sds_define_object(*sds,string_type_list,"dim2,dim3");
  }
  getc_from_f(&cstring[0],name,&length);  
  *obj_index = sds_threed_declare(*sds,pass_ptr,cstring,*n3,*n2,*n1,ec);
  if (*obj_index < 0) return(-2*(*obj_index));
  else return(1);
}
/*********************************************************************/
/*  SDS_FDUPLICATE 
 *  Duplicate an existing SDS
 *
 *      ISTATUS = SDS_FDUPLICATE(sds,"myfile",NEW_SDS)
 *
 *  The new sds index is returned in NEW_SDS
 *  
 *  
 *********************************************************************/
/**************** VMS_FORTRAN ****************************************/
#ifdef vms
int
sds_fduplicate(sds,filename,new_sds)
int *sds,*new_sds;
char  *filename;
{
  int  length;
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_fduplicate_(sds,filename,length,new_sds)
int *sds,length,*new_sds;
char  *filename;
{
#endif

  getc_from_f(cstring,filename,&length);
  *new_sds = sds_duplicate(*sds,cstring);
  if (*new_sds < 0) return(-2*(*new_sds));
  else return(1);
}
/*********************************************************************/
/*      SDS_FMAKE
*      Assemble an SDS
*
*      ISTATUS = SDS_FMAKE(sds,"myfile",TYPE_PARAMETER,NEW_SDS)
*
*      NEW_SDS may be different from SDS if a new sds is made (eg when
*      assembled to shared memory)
*
*      where TYPE_PARAMETER is one of
*              SDS_NEW_FILE
*              SDS_APP_FILE
*              SDS_PROC_MEM
*              SDS_SHARED_MEM
*              SDS_SYBASE
*
*
*********************************************************************/
/**************** VMS_FORTRAN ****************************************/
#ifdef vms
int
sds_fmake(sds,filename,type,new_sds)
int *sds,*type,*new_sds;
char  *filename;
{
  int  length;
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_fmake_(sds,filename,type,new_sds,length)
int *sds,length,*type,*new_sds;
char  *filename;
{
#endif

  getc_from_f(cstring,filename,&length);
  *new_sds = sds_assemble((int)*sds,cstring,*type);
  if (*new_sds < 0) return(-2*(*sds));
  else return(1);
}
#ifdef vms
/**************** VMS_FORTRAN ****************************************/
int
sds_flatread(sds,object,max,number)
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_flatread_(sds,object,max,number)
#endif
int  *sds,*object,*max,*number;
{
  *number = sds_flat_read(*sds,*object,*max);
  if (*number < 0) 
    return(-2*(*number));
  else 
    return(1);
}
/*********************************************************************/
/*  SDS_FLATSU 
 *  set up a data address for filling from sds
 */
/*********************************************************************/
#ifdef vms
/**************** VMS_FORTRAN ****************************************/
int
sds_flatsu(sds,object,subelem,dataty,pointer)
#else
/*************** SUN-XTENDED_FORT ************************************/
int
sds_flatsu_(sds,object,subelem,dataty,pointer)
#endif
char  *pointer;
int *sds;
int *object,*subelem,*dataty;
{
  void  *pass_ptr = (void *)pointer;
  int  type = *dataty,elem = *subelem - 1;
  sds_error = sds_flat_setup((sds_handle)*sds,(sds_code)*object,
										 elem,(sds_code *)&type,pass_ptr);
  if (type != *dataty) {
    sds_error = SDS_WRONG_TYPE;
  }
  if (sds_error < 0) 
    return(-2*sds_error);
  else 
    return(1);
}
/*********************************************************************/
/*  SDS_FREADS 
 *
 *  Loads a data object into previously defined character string
 *  spcae. This is only necessary for Vax fortran character
 *  data: it is here for Sun as well for source code 
 *  compatablity. I'll try to find a better way....
 *
 */
/*********************************************************************/
/**************** VMS_FORTRAN ****************************************/
#ifdef vms
int
sds_freads(sds,object,obj_ptr,start,max,number)
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_freads_(sds,object,obj_ptr,start,max,number)
#endif
int  *sds,*object,*max,*number,*start;
char  *obj_ptr;
{
  char  *pass_ptr = obj_ptr;
  long  cstart = *start - 1;

#ifdef vms
  struct vms_fstring *obj = (struct vms_fstring*)obj_ptr;
  pass_ptr = obj->string;
#endif
  *number = sds_read_object(*sds,*object,pass_ptr,cstart,*max);
  if (*number < 0) 
    return(-2*(*number));
  else 
    return(1);
}
/*********************************************************************/
/*  SDS_FREAD0 
 *
 *  Loads a data object into previously defined space
 */
/*********************************************************************/
/**************** VMS_FORTRAN ****************************************/
#ifdef vms
int
sds_freado(sds,object,obj_ptr,start,max,number)
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_freado_(sds,object,obj_ptr,start,max,number)
#endif
int  *sds,*object,*max,*number,*start;
char  *obj_ptr;
{
  char  *pass_ptr = obj_ptr;
  long  cstart = *start - 1;

  *number = sds_read_object(*sds,*object,pass_ptr,cstart,*max);
  if (*number < 0) 
    return(-2*(*number));
  else 
    return(1);
}
/*********************************************************************/
/*  SDS_FLOAD 
 *
 *  Loads an existing SDS to process memory
 *
 *      ISTATUS = SDS_FLOAD("myfile_name",SOURCE_TYPE,ACCESS_MODE,sds)
 *
 *  Where SOURCE_TYPE is one of
 *    SDS_FILE
 *    SDS_DIREC_ONLY
 *    SDS_SHARED_MEM
 *  And ACCESS_MODE is one of
 *    SDS_READ
 *    SDS_WRITE
 *
 *  The resulting SDS index is return in sds
 *  
 *  
 *********************************************************************/
#ifdef vms
/**************** VMS_FORTRAN ****************************************/
int
sds_fload(name,type,mode,sds)
char  *name;
int  *type,*mode,*sds;
{
  int  length;
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_fload_(name,type,mode,sds,length)
char  *name;
int  length,*type,*mode,*sds;
{
#endif
  getc_from_f(cstring,name,&length);  
  *sds = sds_use(cstring,*type,*mode);
  if (*sds < 0) return(-2*(*sds));
  else return(1);
}
/*********************************************************************/
/*  SDS_STREAM_CLOSE 
 *  close an input stream (use after SDS_FLOAD with
 *  DIRECTORY_ONLY switch on
 *********************************************************************/
#ifdef vms
/**************** VMS_FORTRAN ****************************************/
int
sds_stream_close(sds)
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_stream_close_(sds)
#endif
int  *sds;
{
  sds_close_stream(*sds);
  return(1);
}
/*********************************************************************/
/*  SDS_FWHAT 
 *  
 *  Returns description of object 'obj' in sds 'sds'
 *  number of elements,name and type of element (elemcod) are filled.
 *
 *  INTEGER*4 IA,IB,IC
 *  CHARACTER*20 NAME
 *  .
 *  .
 *      ISTATUS = SDS_FWHAT(1,1,IA,IB,IC,NAME)
 *
 *  
 *  
 *********************************************************************/
#ifdef vms
/**************** VMS_FORTRAN ****************************************/
int
sds_fwhat(sds,obj,nelems,elemcod,name)
int  *sds,*obj,*nelems,*elemcod;
char   *name;
{
  int  length;
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_fwhat_(sds,obj,nelems,elemcod,name,length)
int  *sds,*obj,*nelems,*elemcod,length;
char   *name;
{
#endif
  struct direc *dptr;

  if ((dptr = sds_direc_ptr(*sds)) == DNULL) 
    return(-2*SDS_NO_SUCH_SDS);
  if (*obj > dptr[0].nelems) return(-2*SDS_NO_SUCH_OBJ);
  *nelems = dptr[*obj].nelems;
  *elemcod = dptr[*obj].elemcod;
  getf_from_c(sds_obind2name(*sds,*obj),name,&length);
  return(1);
}

/*********************************************************************/
/*  SDS_FPRINT 
 *  
 *  lists to standard out object 'obj' of SDS 'sds'
 *
 *
 *      ISTATUS = SDS_FPRINT(1,0)
 *
 *  Lists directory of SDS 1
 *
 *  
 *  
 *********************************************************************/
#ifdef vms
/**************** VMS_FORTRAN ****************************************/
int
sds_fprint(sds,obj)
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_fprint_(sds,obj)
#endif
int *sds,*obj;
{
  sds_list(*sds,*obj,SDS_LIST_FORMATTED);
  return(1);
}
/*********************************************************************/
/*  SDS_FINDO 
 *  find object name 'name' in SDS 'sds'
 *
 *      ISTATUS = SDS_FINDO(1,"blech",obj_ind)
 *
 *  Searches for object "blech" in SDS 1
 *  
 *  Returns object index in obj_ind
 *  
 *********************************************************************/
#ifdef vms
/**************** VMS_FORTRAN ****************************************/
int
sds_findo(sds,name,object)
int *sds,*object;
char *name;
{
  int  length;
#else
/*************** SUN-XTENDED_FORT ******************************************/
int
sds_findo_(sds,name,object,length)
int *sds,length,*object;
char *name;
{
#endif
  getc_from_f(cstring,name,&length);
  *object = sds_obname2ind(*sds,cstring); 
  if (*object < 0) return(-2*(*object));
  else return(1);
}
/*********************************************************************/
void
unzterm(buffer,length)
char *buffer;
int  length;
/*********************************************************************/
{
  int  i;
  for (i=0;i<length;i++,buffer++)
    if (*buffer = (char)0) *buffer = ' ';
}
/*********************************************************************/
void
zterm(cbuffer)
char *cbuffer;
/*********************************************************************/
{
  while(*(--cbuffer) == ' ');
  cbuffer++;
  if ((int)*cbuffer) *cbuffer = (char)0;
}
#ifdef vms
/*********************************************************************/
int
getc_from_f(cbuffer,fpointer,len)
char  *cbuffer;
struct vms_fstring *fpointer;
int  *len;
/*********************************************************************/
{
  int  i;
  char  *fptr = fpointer->string;
  for(i=0;i<(int)fpointer->len;i++,*cbuffer++ = *fptr++);
  zterm(cbuffer);
}
#else

/*********************************************************************/
int
getc_from_f(cbuffer,fpointer,len)
char  *cbuffer,*fpointer;
int  *len;
/*********************************************************************/
{
  int i;
  for(i=0;i<*len;i++,*cbuffer++ = *fpointer++);
  zterm(cbuffer);
	return 0;
}
#endif
#ifdef vms
/*********************************************************************/
int
getf_from_c(cbuffer,fpointer,len)
char  *cbuffer;
struct vms_fstring *fpointer;
int  *len;
/*********************************************************************/
{
  int i;
  char  *fptr,*tptr;
  tptr = fpointer->string;
  fptr = cbuffer;
  for(i=0;i<(int)fpointer->len && *fptr != (char)0;i++,*tptr++ = *fptr++);
  for(;i<(int)fpointer->len;i++,*tptr++ = ' ');
	return 1;
}
#else

/*********************************************************************/
int
getf_from_c(cbuffer,fpointer,len)
char  *cbuffer,*fpointer;
int  *len;
/*********************************************************************/
{
  int i;
  char  *fptr,*tptr;
  tptr = fpointer;
  fptr = cbuffer;
  for(i=0;i<*len && *fptr != (char)0;i++,*tptr++ = *fptr++);
  for(;i<*len;i++,*tptr++ = ' ');
	return 1;
}
#endif



