/* $Header: sds_fdb.c,v 1.5 93/02/18 07:01:24 salty Exp $ */

/**************************************************************************
 *                 ****** ISTK Release 1.2 *****                          *
 *                                                                        *
 *                                                                        *
 * This code has been produced by numerous authors at the CERN centre for *
 * high energy physics, Geneve, Switzerland, at the SSC laboratory in     *
 * Dallas, Texas, USA and at the Lawrence Berekeley Laboratory in         *
 * California, USA.                                                       *
 * The latter two institutions perform work under US Government contract. *
 * The intent of the work is to provide useful code for people who need   *
 * it, with an emphasis on free and collaborative exchange of ideas,      *
 * techniques and implementations.                                        *
 * Please read the disclaimer and copyright notices contained in the ISTK *
 * distribution and in distributed applications.                          *
 *                                                                        *
 **************************************************************************/


/* Reference release  Aug 10 1991 - C G Saltmarsh */
/* Has the basics used at CDG & SSC 1988-1991, plus vxworks
   support
*/

#include <stdlib.h>
#include <string.h>

#ifndef vms
#include <unistd.h>
#endif

#include <memory.h>

#if defined(vms)
#include "sdsgen.h"
#include "sds_externs.h"
#else
#include "Sds/sdsgen.h"
#include "Sds/sds_externs.h"
#endif

extern	int	sds_is_init,sds_error;

static	int	db_object[MAX_SDS];
static	long	db_next_row[MAX_SDS];

/************************************************************************/
sds_handle
sds_dbtab_make(nrows,basename,tlist,select_list)
int	nrows;
char	*select_list,*basename;
struct type_list	*tlist;
/************************************************************************/
{
	int	sds;
	unsigned long	tlist_index;

	sds_error = 0;
	if (!sds_is_init)
		sds_init();

	sds = sds_new_index(basename);

	tlist_index = sds_define_object(sds,tlist,select_list);

	db_object[sds] = sds_declare_object(sds,
			SDS_ALLOCATE,
			basename,
			nrows,
			tlist_index);
	db_next_row[sds] = 0;

	sds_assemble(sds,basename,SDS_PROC_MEM);

	if (sds_error) {
		sds_perror("Making table sds:");
		exit(1);
	}

	return(sds);
}
/************************************************************************/
sds_handle
sds_dbrow_ins(sds,pointer)
sds_handle	sds;
char	*pointer;
/************************************************************************/
{

	long	next_row = db_next_row[sds];
	int	object = db_object[sds];
	char	*sptr;
	struct direc	*dptr = sds_direc_ptr(sds);

	if (next_row > dptr[object].nelems)
		return(sds_error = SDS_NO_MEM);

	sptr = (char *)sds_getp(dptr,(long)object) +
										next_row * dptr[object].elemsz;

	memcpy(sptr,pointer,(int)dptr[object].elemsz);
	db_next_row[sds]++;
	return(0);
}
