/* $Header: sdc.c,v 1.9 93/01/13 16:57:46 vern Exp $ */

/**************************************************************************
 *                 ****** ISTK Release 1.2 *****                          *
 *                                                                        *
 *                                                                        *
 * This code has been produced by numerous authors at the CERN centre for *
 * high energy physics, Geneve, Switzerland, at the SSC laboratory in     *
 * Dallas, Texas, USA and at the Lawrence Berekeley Laboratory in         *
 * California, USA.                                                       *
 * The latter two institutions perform work under US Government contract. *
 * The intent of the work is to provide useful code for people who need   *
 * it, with an emphasis on free and collaborative exchange of ideas,      *
 * techniques and implementations.                                        *
 * Please read the disclaimer and copyright notices contained in the ISTK *
 * distribution and in distributed applications.                          *
 *                                                                        *
 **************************************************************************/


/* Reference release  Aug 10 1991 - C G Saltmarsh */
/* Has the basics used at CDG & SSC 1988-1991, plus vxworks
   support
*/

#ifdef HPUX
#include <ctype.h>
#endif

#include <stdlib.h>
#include <string.h>

#ifndef vms
#include <unistd.h>
#endif

#if defined(vms)

#include "sdsgen.h"
#include "sds_externs.h"
#else
#include "Sds/sdsgen.h"
#include "Sds/sds_externs.h"
#endif

extern char    sds_sizes[];
extern char    sds_arcs[NARCS][26];
extern char    sds_rbytes[NARCS];
extern  int    sds_error;
extern  int    allofl[];

struct  dshort 
  {
  char  one;
  char  two;
  };
struct  dlong 
  {
  char  one;
  char  two;
  char  three;
  char  four;
};
struct  ddouble 
  {
  char  one;
  char  two;
  char  three;
  char  four;
  char  five;
  char  six;
  char  seven;
  char  eight;
  };

#if !defined(hpux) && !defined(vxworks) && !defined(psos) && !defined(mips)
#if !defined(vms)
#if !defined(__GCC_2__)
#if defined(__GNUC__) && __GNUC__ != 2
extern char  *memcpy();
#endif
#endif
#endif
#endif

/********* forward declarations ****************************************/
char  *load_sds_file();
void   rswabw();
void   rswab();
void   rswabd();
void   sds_fix_tlist();
void   sds_fix_header();
void   sds_fix_direc();
int    sds_copen();

extern void   r_float();
extern void   r_double();


/***********************************************************************/
sds_handle
sds_load_conv(filename)
char  *filename;
/***********************************************************************/
{
  int fd;
  if ((fd = open(filename,O_RDONLY,0x644)) < 0) 
	{
    fprintf(stderr,"Cannot access file %s \n",filename);
    perror("because ");
    exit(2);
  }
	return sds_cload(fd);
}
/***********************************************************************/
sds_handle
sds_cload(fd)
int  fd;
/***********************************************************************/
{
  struct      type_list  *ntlist;
  struct      sds_header  *nheader,*header;
  sds_handle  sds,orig_state;
  long        new_sds,old_sds;
  int         size,dsize,first,second;
  int         i,old,new;
  long        new_type;
  int         del;
  char        junk[32];
  int         element_addr;
  int         nread;
  struct  sds_header head;
	struct  direc     *dptr;
	struct  direc     *ndptr;
  struct sds_odesc  *othing,*nthing;

  if ((old_sds = sds_cload_direc(fd,&orig_state, &head)) < 0) 
  {
    if (old_sds == SDS_GOOD_FORMAT)
    {
      sds = sds_na_load(fd, &head);
      close(fd);
      return(sds);
    }
    close(fd);
    sds_perror("foreign direc load");
    exit(1);
  }
  header = get_header(old_sds);
  dptr = sds_direc_ptr(old_sds);

      
  /*   Duplicate this header for the new, native arch, dataset */

  size = (char *)dptr - (char *)header;

  /*  the heap size may need to be increased (don't worry
    if it's too big)   */

  first = BASE_OFFSET + header->heap_size + header->list_size;
  dsize = align_delta(header->heap_size,RBYTE); 
  dsize = 0;
  size += dsize;
  second = size - first; 

  nheader = (struct sds_header *)malloc((unsigned)size +
        dptr[0].nelems * sizeof(struct direc));
  memcpy((char *)nheader,(char *)header,first);
  memcpy((char *)((int)nheader + first + dsize),
    (char *)((int)header + first),
    second);

  nheader->heap_size += dsize;
  nheader->magic_number = SDS_MAGIC;

  ndptr = (struct direc *)((char *)nheader +
        BASE_OFFSET +
        nheader->heap_size +
        nheader->list_size);
  memcpy((char *)ndptr,dptr,dptr[0].nelems * sizeof(struct direc));
  ndptr[0].offst = (long)((char *)ndptr - (char *)nheader);

  new_sds = next_sds();

  allofl[new_sds] = SDS_HEAD_ALLOC;
  set_sys_vars(new_sds,ndptr);

  fix_sizes_and_aligns(new_sds);

  ndptr[0].offst = SDS_NOT_ASSEMBLED;
   for (i=1;i<dptr[0].nelems;i++) 
  {
    ndptr[i].offst = (long)SDS_ALLOCATE;
    ndptr[i].illoca = (char)0;
  }

/*  The complete descriptions - header, tlist and
  directories - are now an accurate description
  of both input and output sds's. It remains to convert the 
  objects, which are pointed to by the object_pointer
  list and described by the direc's
 */

  sds = sds_assemble(new_sds,"temp",SDS_PROC_MEM);
  if (sds != new_sds) 
  {
    printf("erk!,sdses not equal\n");
    exit(1);
  }
  ntlist = get_tlist(new_sds);
  ndptr = sds_direc_ptr(new_sds);

  del = 
    dptr[1].offst -
    dptr[0].offst -
    dptr[0].nelems * dptr[0].elemsz;

  if (del > 0) 
  {
    sds_vread(fd,junk,(unsigned)del);
  }
  element_addr = 0;
  del = 0;

   for (i=1;i<ndptr[0].nelems;i++) 
   {
    while((old = sds_resolve(old_sds,i,&othing,SDS_OBJECT)) >= 0) 
    {
    sds_alt_resolution_stack();
      new = sds_resolve(new_sds,i,&nthing,SDS_OBJECT);
    sds_main_resolution_stack();
      if (othing[old].nelems != nthing[new].nelems) 
      {
        printf("new <--> old sds mismatch!\n");
        exit(1);
      }
      if (element_addr != 0)
        del = (int)othing[old].address - element_addr;
      if (del > 0) 
      {

        nread = sds_vread(fd,junk,(unsigned)del);
      }
      new_type = convert(fd,&othing[old],
          &nthing[new],
          orig_state);
      if (ndptr[i].elemcod & SDS_INDLIST)
        ntlist[nthing[new].ind-1].elemcod = new_type;
      else
        ndptr[i].elemcod = new_type;
      element_addr = (int)othing[old].address +
          othing[old].nelems * othing[old].size;
    }

    sds_alt_resolution_stack();
      new = sds_resolve(new_sds,i,&nthing,SDS_OBJECT);
    sds_main_resolution_stack();

  }
  close(fd);
  return(new_sds);
}
/***********************************************************************/
void
fix_sizes_and_aligns(sds)
sds_handle  sds;
/***********************************************************************/
{
  struct  direc *dptr = sds_direc_ptr(sds);
  struct  type_list  *ttptr = get_tlist(sds);
  struct  sds_header  *head = get_header(sds);
  char  align;
  unsigned  long  ind,i;
  unsigned long ntp = (unsigned long)head->list_size/sizeof(struct type_list);

  if (ntp) 
  {
    for (i=0;i<ntp;i++,ttptr++) 
    {
      if (ttptr->elemcod & SDS_SIZE_ALIGN) 
      {
        ind = (i+1) | SDS_INDLIST;
        ttptr->nelems = 
          sds_tlsize(sds,ind,&align);
        ttptr->elemcod = SDS_SIZE_ALIGN | (long)(align & 0xff);
      }
    }
  }
  for (i=0;i<dptr[0].nelems;i++)
    dptr[i].elemsz = sds_object_size(sds,
        dptr[i].elemcod,
        &dptr[i].align_type);
}
/***********************************************************************/
sds_code
convert(fd,old,new,bs_flag)
struct  sds_odesc  *old,*new;
int  bs_flag;
int  fd;
/***********************************************************************/
{

  long  ret_type = old->elemcod;
  char  *buffer = malloc(old->size * old->nelems);


  sds_vread(fd,buffer,old->size*old->nelems);


  switch((int)old->elemcod) 
  {
#ifdef  IEEEFP
    case SDS_IFLOAT:
      if(bs_flag == SDS_SWAPPED_BYTES) 
      {
        rswabw(buffer,new->address,old->size*old->nelems);
      } 
      else 
      {
        memcpy(new->address,buffer,old->size*old->nelems);
      }
    break;
    case SDS_VFLOAT:
      ret_type = SDS_IFLOAT;
#endif
#ifdef  VAXFP
    case SDS_VFLOAT:
      if(bs_flag == SDS_SWAPPED_BYTES) 
      {
        rswabw(buffer,new->address,old->size*old->nelems);
      } 
      else 
      {
        memcpy(new->address,buffer,old->size*old->nelems);
      }
    break;
    case SDS_IFLOAT:
      ret_type = SDS_VFLOAT;
#endif
      if(bs_flag != SDS_SWAPPED_BYTES) 
      {
        rswabw(buffer,buffer,old->size*old->nelems);
      }
      r_float(buffer,new->address,old->size*old->nelems);
    break;

#ifdef  IEEEFP
    case SDS_ICOMPLEX:
      if(bs_flag == SDS_SWAPPED_BYTES) 
      {
        rswabw(buffer,new->address,old->size*old->nelems);
      } 
      else 
      {
        memcpy(new->address,buffer,old->size*old->nelems);
      }
      break;
    case SDS_VCOMPLEX:
      ret_type = SDS_ICOMPLEX;
#endif
#ifdef  VAXFP
    case SDS_VCOMPLEX:
      if(bs_flag == SDS_SWAPPED_BYTES) 
      {
        rswabw(buffer,new->address,old->size*old->nelems);
      } 
      else 
      {
        memcpy(new->address,buffer,old->size*old->nelems);
      }
      break;
    case SDS_ICOMPLEX:
      ret_type = SDS_VCOMPLEX;
#endif

      if(bs_flag != SDS_SWAPPED_BYTES) 
      {
        rswabw(buffer,buffer,old->size*old->nelems);
      } 
      r_float(fd,new->address,old->size*old->nelems);
    break;
#ifdef  IEEEFP
    case SDS_IDOUBLE:
      if(bs_flag == SDS_SWAPPED_BYTES) 
      {
        rswabd(buffer,new->address,old->size*old->nelems);
      }
      else 
      {
        memcpy(new->address,buffer,old->size*old->nelems);
      }
    break;
    case SDS_DVDOUBLE:
    case SDS_GVDOUBLE:
      ret_type = SDS_IDOUBLE;
#endif
#ifdef  VAXFP
    case SDS_DVDOUBLE:
    case SDS_GVDOUBLE:
      if(bs_flag == SDS_SWAPPED_BYTES) 
      {
        rswabd(buffer,new->address,old->size*old->nelems);
      }
      else 
      {
        memcpy(new->address,buffer,old->size*old->nelems);
      }
    break;
    case SDS_IDOUBLE:
      ret_type = SDS_DVDOUBLE;
#endif
      if(bs_flag != SDS_SWAPPED_BYTES) 
      {
        rswabd(buffer,new->address,old->size*old->nelems);
      }

      r_double(buffer,new->address,old->size*old->nelems);
    break;

#ifdef  IEEEFP
    case SDS_IDOUBLE_COMPLEX:
      if(bs_flag == SDS_SWAPPED_BYTES) 
      {
        rswabd(buffer,new->address,old->size*old->nelems);
      } 
      else 
      {
        sds_vread(new->address,buffer,old->size*old->nelems);
      }
    break;
    case SDS_DVDOUBLE_COMPLEX:
    case SDS_GVDOUBLE_COMPLEX:
      ret_type = SDS_IDOUBLE;
#endif
#ifdef  VAXFP
    case SDS_DVDOUBLE_COMPLEX:
    case SDS_GVDOUBLE_COMPLEX:
      if(bs_flag == SDS_SWAPPED_BYTES) 
      {
        rswabd(buffer,new->address,old->size*old->nelems);
      } 
      else 
      {
        sds_vread(new->address,buffer,old->size*old->nelems);
      }
    break;
    case SDS_IDOUBLE_COMPLEX:
      ret_type = SDS_DVDOUBLE;
#endif
      if(bs_flag != SDS_SWAPPED_BYTES) 
      {
        rswabd(buffer,buffer,old->size*old->nelems);
      } 
      r_double(buffer,new->address,old->size*old->nelems);
    break;
    case SDS_POINTER:
      printf("Problem in conversion: pointer found!\n");
    break;
    case SDS_PADB:
      printf("Problem n conversion: pad byte found!\n");
    break;
    default:
    if(bs_flag != SDS_SWAPPED_BYTES ||
      old->elemcod == SDS_STRING ||
      old->elemcod == SDS_FSTRING ||
      old->elemcod == SDS_BYTE ||
      old->elemcod == SDS_UNS_BYTE ||
      old->elemcod == SDS_LOGICAL_1) 
    {
      memcpy(new->address,buffer,old->size*old->nelems);
    }
    else 
    {
      if (new->size == 2)
      {
        rswab(buffer,new->address,old->size*old->nelems);
      }
      else
      {
        rswabw(buffer,new->address,old->size*old->nelems);
      }
    }
  }
  free(buffer);
  return(ret_type);
}
/***********************************************************************/
void
rswab(buffer,to,number)
struct  dshort  *to;
int  number;
char  *buffer;
/***********************************************************************/
{
  int  i;
  struct  dshort  *from = (struct dshort *)buffer;
  char  temp;


  for (i=0;i<number;i += 2,to++,from++) 
  {
    temp = from->one;
     to->one = from->two;
     to->two = temp;
  }
}
/***********************************************************************/
void
rswabw(buffer,to,number)
struct  dlong  *to;
int  number;
char  *buffer;
/***********************************************************************/
{
  int  i;
  struct  dlong  *from = (struct dlong *)buffer;
  char  temp;

  for (i=0;i<number;i += 4,to++,from++) 
  {
    temp = from->four;
     to->four = from->one;
     to->one = temp;
    temp = from->two;
     to->two = from->three;
     to->three = temp;
   }
}
/***********************************************************************/
void
rswabd(buffer,to,number)
struct  ddouble  *to;
int  number;
char *buffer;
/***********************************************************************/
{
  int  i;
  struct  ddouble  *from = (struct ddouble *)buffer;
  char  temp;


  for (i=0;i<number;i += 8,to++,from++) 
  {
    temp = from->one;
     to->one = from->eight;
     to->eight = temp;
    temp = from->two;
     to->two = from->seven;
     to->seven = temp;
    temp = from->three;
     to->three = from->six;
     to->six = temp;
    temp = from->four;
     to->four = from->five;
     to->five = temp;
   }
}
/***********************************************************************/
void
sds_fix_header(header,orig_state)
struct  sds_header  *header;
int  orig_state;
/***********************************************************************/
{

  char  *cptr = (char *)header;

  if (orig_state == SDS_SWAPPED_BYTES) 
  {
    rswabw(cptr,cptr,8);
    cptr += 8;
    rswab(cptr,cptr,4);
  }
}
/***********************************************************************/
void
sds_fix_tlist(header,tlist,orig_state)
struct  sds_header  *header;
struct  type_list  *tlist;
int  orig_state;
/***********************************************************************/
{
  if (orig_state == SDS_SWAPPED_BYTES)
    rswabw((char *)tlist,(char *)tlist,(int)header->list_size);
}
/***********************************************************************/
void
sds_fix_direc(dptr,number,orig_state)
struct  direc  *dptr;
int  orig_state,number;
/***********************************************************************/
{
  int  i;
  char  *lptr;

  if (orig_state == SDS_SWAPPED_BYTES)
    for (i=0;i<number;i++) 
    {
      lptr = (char *)dptr;
      rswabw(lptr,lptr,20);
      lptr += 20;
      rswab(lptr,lptr,4);
      lptr += 4;
      rswabw(lptr,lptr,4);
      dptr++;
    }
}
/*********************************************************************/
int
sds_copen(filename)
/*********************************************************************/
char  *filename;
{

  int  fd;

  if ((fd = open(filename,O_RDONLY,0666)) < 0)
    return(SDS_FILE_OP);
  return(fd);
}
/*********************************************************************/
sds_handle
sds_cload_direc(fd,state ,header)
int  fd;
sds_handle *state;
struct sds_header *header;
/*********************************************************************/
{

  struct direc dtemp;
  char  *cptr;
  struct  type_list  *tl;
  struct sds_header *nhead;
  struct  direc  *dptr;
  int  sds,ierr,ndirecs,lhsize;
  char    old_rbyte;
  char    *temp_malloc;
  int arc;


  if (fd < 0)
    return(sds_error = SDS_FILE_NOP);

/*  Read in the header ;     */
  if  ((ierr = sds_vread(fd,header,BASE_OFFSET)) < 0)
    return(ierr);

  if (!(*state = bad_sds_header(header)))
    return(sds_error = SDS_GOOD_FORMAT);

  if ((header->magic_number  & 0xff00ffff) == SDS_MAGIC_BYTESWAP)
    *state = SDS_SWAPPED_BYTES;

  sds_fix_header(header,*state);

  arc = (header->magic_number & 0x0000ff00) >> 8;
  if (arc > NARCS)
  {
    fprintf(stderr,"Unkown architecture received for conversion\n");
    exit(1);
  }

  old_rbyte = sds_rbytes[((header->magic_number & 0x0000ff00) >> 8) -1 ];

  /* BUG WARNING. See sds_make bug warning */
  lhsize = (int)header->heap_size + (int)header->list_size + 
                  align_delta(header->heap_size,4);


  lhsize += align_delta(lhsize,4);
  temp_malloc = malloc((unsigned)lhsize);

  tl = (struct  type_list *)temp_malloc;
  sds_vread(fd,(char *)tl,lhsize);

  sds_fix_tlist(header,tl,*state);


/*  Find size of directory        */
  sds_vread(fd,(char *)&dtemp,sizeof(struct direc));
  sds_fix_direc(&dtemp,1,*state);
  ndirecs = (int)dtemp.nelems;

/*  New directory,tlist heap  and header go here    */
/* the '32' is a cheat to assure enough space for aligning
  on the old architecture worst-case boundary. This code must\
  br FIXED! */
  cptr = malloc((unsigned int)(ndirecs*sizeof(struct direc)) +
      (unsigned int)BASE_OFFSET +  
      (unsigned int)lhsize +
      32);
  cptr += align_delta((int)cptr,old_rbyte);

/*  Copy in header.....        */
  memcpy(cptr,(char *)header,BASE_OFFSET);
  nhead = (struct sds_header *)cptr;

  cptr += BASE_OFFSET;

/*  Copy in tlist and heap        */
  memcpy(cptr,tl,lhsize);

  cptr += lhsize;

/*  Copy in top directory.....      */
  memcpy(cptr,(char *)&dtemp,sizeof(struct direc));
  dptr = (struct direc *)cptr;

  cptr += sizeof(struct direc);

/*  Read in rest of directory.....      */
  sds_vread(fd,cptr,sizeof(struct direc)*(ndirecs-1));
  sds_fix_direc((struct direc *)cptr,ndirecs-1,*state);


  dptr[0].offst = (long)(char *)dptr - (long)(char *)nhead;
  sds = next_sds();
  set_sys_vars(sds,dptr);

  return(sds);
}
/*********************************************************************/
sds_handle
sds_na_load(fd,header)
int  fd;
struct sds_header *header;
/* Pulls in the sds from file, but SERIALLY - ie don't know 
   file size */
/*********************************************************************/
{

  struct direc        dtemp;
  char               *dirs;
  char               *cptr;
  struct  type_list  *tl;
  struct  direc      *dptr;
  int                 sds,ndirecs,lhsize;
  char               *temp_malloc;
  int                 i, remains, total_size = BASE_OFFSET;
  char               *new_sds_ptr;


  if (fd < 0)
    return(sds_error = SDS_FILE_NOP);

/* The header is already read in to *head */
/* How big are the variable length heaps? */
  lhsize = (int)header->heap_size + (int)header->list_size + 
                  align_delta(header->heap_size,4);
  total_size += lhsize;

/* Get space.... */
  if ((temp_malloc = malloc((unsigned)lhsize)) == NULL)
  {
    sds_perror("Temporary malloc in sds_na_load");
    exit(1);
  };

/* read in these heaps */
  tl = (struct  type_list *)temp_malloc;
  sds_vread(fd,(char *)tl,lhsize);

/*  Find size of directory        */
  sds_vread(fd,(char *)&dtemp,sizeof(struct direc));
  ndirecs = (int)dtemp.nelems;

/*  Read in rest of directory.....      */
  cptr = 
  dirs = malloc((unsigned int)(ndirecs*sizeof(struct direc)));
  memcpy(dirs,&dtemp,sizeof(struct direc));
  cptr += sizeof(struct direc);
  sds_vread(fd,cptr,sizeof(struct direc)*(ndirecs-1));


  dptr = (struct direc *)dirs;

/* Now I can work out the full sds size */
  for ( i = 0; i<dptr[0].nelems ; i++ )
  {
    total_size += align_delta((int)total_size,dptr[i].align_type);
    total_size += dptr[i].nelems*dptr[i].elemsz;
  }

/* and read in all the bits */
  cptr = 
  new_sds_ptr = malloc(total_size);
  memcpy(cptr,header,BASE_OFFSET);
  cptr+=BASE_OFFSET;
  memcpy(cptr,temp_malloc, lhsize);
  cptr+=lhsize;
  dptr = (struct direc *)cptr;
  memcpy(cptr, dirs, ndirecs*sizeof(struct direc));
  cptr+=ndirecs*sizeof(struct direc);
  remains = total_size -
    BASE_OFFSET -
    lhsize -
    ndirecs * sizeof(struct direc);
  sds_vread(fd,cptr,remains);

  free(dirs);
  free(temp_malloc);

  sds = next_sds();
  set_sys_vars(sds,dptr);

  return(sds);
}

