#ifndef ISTKdtypes_h
#define ISTKdtypes_h

/* $Header: dtypes.h,v 1.4 92/08/04 14:48:09 salty Exp $ */

/**************************************************************************
 *                 ****** ISTK Release 1.2 *****                          *
 *                                                                        *
 *                                                                        *
 * This code has been produced by numerous authors at the CERN centre for *
 * high energy physics, Geneve, Switzerland, at the SSC laboratory in     *
 * Dallas, Texas, USA and at the Lawrence Berekeley Laboratory in         *
 * California, USA.                                                       *
 * The latter two institutions perform work under US Government contract. *
 * The intent of the work is to provide useful code for people who need   *
 * it, with an emphasis on free and collaborative exchange of ideas,      *
 * techniques and implementations.                                        *
 * Please read the disclaimer and copyright notices contained in the ISTK *
 * distribution and in distributed applications.                          *
 *                                                                        *
 **************************************************************************/


/* Reference release  Aug 10 1991 - C G Saltmarsh */
/* Has the basics used at CDG & SSC 1988-1991, plus vxworks
   support
*/

char sds_sizes[NPRIMITIVES] = {
    (char)0,
    (char)sizeof(char),
    (char)sizeof(char),
    (char)sizeof(char),
    (char)sizeof(short),
    (char)sizeof(short),
    (char)sizeof(long),
    (char)sizeof(long),
    (char)sizeof(float),
    (char)sizeof(double),
    (char)sizeof(float),
    (char)sizeof(double),
    (char)sizeof(double),
    (char)1, /* by definition. It's a char */
    (char)sizeof(struct direc),
    (char)2*sizeof(float),
    (char)2*sizeof(double),
    (char)2*sizeof(float),
    (char)2*sizeof(double),
    (char)2*sizeof(double),
    (char)sizeof(char),
    (char)sizeof(short),
    (char)sizeof(long),
    (char)sizeof(char*),
    (char)2*sizeof(long),
    (char)0,
    (char)1,
    (char)sizeof(long),
    (char)sizeof(void*),
    (char)sizeof(long),
    };


char    sds_rbytes[NARCS] = 
	  /* See sds_mdep.h */
          { 2,8,1,4,4};


/* The following gives alignment for different SDS_XXX */
char    sds_arcs[NARCS][NPRIMITIVES] = 
          {2, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2,
           1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 1,
					 1, 2, 2, 2,
           8, 1, 1, 1, 2, 2, 4, 4, 4, 8, 4, 8, 8,
           1, 4, 4, 8, 4, 8, 8, 1, 2, 4, 4, 4, 1,
					 1, 4, 4, 4,
           1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
           1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
					 1, 1, 1, 1,
           8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
           8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
					 8, 8, 8, 8,
           4, 1, 1, 1, 2, 2, 4, 4, 4, 4, 4, 4, 4,
           1, 4, 4, 4, 4, 4, 4, 1, 2, 4, 4, 4, 1,
					 1, 4, 4, 4};

char    *sds_align = sds_arcs[SDS_ARC];

#endif
