/* $Header: direc.h,v 1.9 93/01/13 14:26:44 salty Exp $ */

#ifndef ISTKdirec_h
#define ISTKdirec_h     


/**************************************************************************
 *                 ****** ISTK Release 1.2 *****                          *
 *                                                                        *
 *                                                                        *
 * This code has been produced by numerous authors at the CERN centre for *
 * high energy physics, Geneve, Switzerland, at the SSC laboratory in     *
 * Dallas, Texas, USA and at the Lawrence Berekeley Laboratory in         *
 * California, USA.                                                       *
 * The latter two institutions perform work under US Government contract. *
 * The intent of the work is to provide useful code for people who need   *
 * it, with an emphasis on free and collaborative exchange of ideas,      *
 * techniques and implementations.                                        *
 * Please read the disclaimer and copyright notices contained in the ISTK *
 * distribution and in distributed applications.                          *
 *                                                                        *
 **************************************************************************/


/* Reference release  Aug 10 1991 - C G Saltmarsh */
/* Has the basics used at CDG & SSC 1988-1991, plus vxworks
   support
*/

/************************************************************************
 *            Copyright (C) Frogsoft Corporation,  1987                 *
 *
 * SSC VERSION 2.0001 April 29 1988
 *
 * Modification history:
 *
 * 2.0100 Base release Dec 20 1990 
 *
 ***********************************************************************/

#ifdef __cplusplus
#define EXTERN extern "C"
#else
#define EXTERN extern
#endif
     
typedef long sds_handle;
typedef unsigned long sds_code;
typedef struct record_header sds_record_handle;

      /*  a few NULL pointers */


#define DNULL ((struct direc *)0)
#define TNULL ((struct type_list *)0)
#define HNULL ((struct sds_header *)0)
#define INULL ((int *)0)
#define SNULL ((char *)0)
#define SDS_ALLOCATE ((char *)0)

#define SDS_NOT_ASSEMBLED ((unsigned long)0xffffffff)
#define SDS_IMPOSSIBLE_ADDRESS ((unsigned long)0xfffffffe)

#ifndef L_SET
#define L_SET 0
#endif
     

#define SDS_BASE_MAGIC  (unsigned long)0x50420043
#define SDS_MAGIC  SDS_BASE_MAGIC + (unsigned long)((SDS_ARC+1) << 8)
#define SDS_MAGIC_BYTESWAP (unsigned long)0x43004250
#define SDS_VERSION  (unsigned long)0x10002

/* the following are markers to define the end of a tlist... */

#define SDS_ENDLIST  ((unsigned long)0x40000001)

/* ... the end of a structure within a tlist...       */

#define SDS_RETLIST  ((unsigned long)0x40000000)

/* ...and a flag to be &'ed with an internal (not system) pointer
 to generate a non-primitive element code.                   */

#define SDS_INDLIST  ((unsigned long)0x80000000)
#define SDS_LOCALLIST  ((unsigned long)0x08000000)
#define SDS_CODE_MASK ((unsigned long)0xff000000)

/* this, at the start of a tlist,indicates that it is named   */

#define SDS_LENLIST  ((unsigned long)0x10000000)
#define SDS_SIZE_ALIGN  ((unsigned long)0x20000000)

/* These things should be hidden from the user as soon as possible */

#define SDS_WAS_ALLOCATED (char)0x01
#define SDS_EXTERNAL_OBJECT (char)0x02
#define SDS_REALLOC  (char)0x04
#define SDS_DISJOINT_OBJECT (char)0x08

#define SDS_GEN_NAME ((unsigned long)0xffffffff)

     
#define   DIR_NAM_LEN   32

#define SDS_HEAP_ALLOC   0x01
#define SDS_TLIST_ALLOC  0x02
#define SDS_DPTR_ALLOC   0x04
#define SDS_HEAD_ALLOC   0x08
#define SDS_DUP_ALLOC    0x10

#define SDS_NORMAL_OBJECT (short)0x00
#define SDS_LISTK (short)0x01
#define SDS_VARIABLE_LENGTH (short)0x02
#define SDS_RECORDS (short)0x04
#define SDS_FORTRAN_RECORDS (short)0x08
#define SDS_SDC_EVENT (short)0x10
#define SDS_EXTERNAL_LENGTH (short)0x20

#define SDS_LENGTH_UNDETERMINED 0xffffffff
#define SDS_LOADED_MULT 0xfffffffe

#define SDS_DATASET_LEVEL 0
#define SDS_OBJECT_LEVEL 1
#define SDS_SUBOBJECT_LEVEL 2


struct sds_header {  
  unsigned long magic_number; 
  unsigned long version; 
  unsigned short heap_size; 
  unsigned short list_size; 
 };

#define BASE_OFFSET sizeof(struct sds_header)
     
struct direc    {            /* Directory structure for standard dataset*/
 sds_code        offst;      /* offset from memory start */
 sds_code        nelems;     /* # elements */
 sds_code        elemsz;     /* size in bytes of 1 element */
 sds_code        elemcod;    /* code of the type */
 unsigned long   wtime;      /* last write time  */
 short           structype;  /* is it a list etc? */
 unsigned char   align_type; /* alignment type  */
 unsigned char   illoca;     /* reallocation flag */
 sds_code        obj_name;   /* name offset of the object */
 };

struct type_list {
 sds_code        nelems;    /* # elements requested */
 sds_code        elemcod;   /* code of the type */
 };

struct    sds_odesc {
 char *address;          /* start address */
 char *name;             /* base name */
 sds_code elemcod;       /* code */
 sds_code nelems;        /* number of elements */
 sds_code nnames;        /* number of names   */
 sds_code size;          /* size of one element, in bytes */
 char align;             /* Byte boundary for alignment */
 char *namelist;         /* Pointer to namelist of nnames names */
 sds_code maxn;          /* system bookkeeping */
 sds_code ind;           /* system bookkeeping */
 };

#if defined(__cplusplus) || defined(__STDC__)

EXTERN void       sds_discard(sds_handle);
EXTERN void       sds_destroy(sds_handle);

EXTERN sds_handle sds_use(char *,sds_code, sds_code);
EXTERN sds_handle sds_map(char *, sds_code);
EXTERN sds_handle sds_adaptive_map(char *,int, sds_code, char **, int *, int *);
EXTERN sds_handle sds_na_load(int,struct sds_header*);
EXTERN sds_handle sds_load_fd(int, unsigned long, int);

EXTERN sds_handle sds_mapfilecheck(char *, int, int);
EXTERN char *     sds_searchmapfile(sds_handle, int *, int *);


EXTERN void sds_print_record_def(sds_record_handle *);
EXTERN void sds_destroy_record_def(sds_record_handle *, int);
EXTERN void sds_record_entry(sds_record_handle *,sds_code,
																		sds_code,void *, char *);
EXTERN void sds_end_sub_record(sds_record_handle *);
EXTERN void sds_begin_sub_record(sds_record_handle *,char *);
EXTERN sds_record_handle * sds_begin_record(char *);
EXTERN sds_handle sds_end_and_declare(sds_record_handle *, sds_handle);
EXTERN int sds_copy_records(sds_handle,char *, sds_record_handle *);

EXTERN sds_handle sds_cload_direc(int, sds_handle*, struct sds_header *);
EXTERN sds_handle sds_load_conv(char *);
EXTERN sds_handle sds_cload(int);

EXTERN sds_handle sds_new_index(char *);
EXTERN sds_handle sds_assemble(sds_handle,char *,sds_code);
EXTERN sds_handle sds_declare_object(sds_handle, void *,
																							 char *,sds_code,sds_code);

EXTERN void       sds_perror(char *);

EXTERN sds_handle sds_list(sds_handle, sds_code, sds_code);
EXTERN void       sds_printit(sds_code ,sds_code ,char *);

EXTERN sds_handle sds_dataset_size(sds_handle);


EXTERN void       *sds_obname2ptr(sds_handle , char *);
EXTERN void       *sds_obind2ptr(sds_handle ,sds_code );
EXTERN char       *sds_obind2name(sds_handle , sds_code );
EXTERN sds_handle sds_obname2ind(sds_handle ,char *);
EXTERN sds_handle sds_oblike2ind(sds_handle ,char *, sds_handle);
EXTERN sds_handle sds_array_size(sds_handle ,sds_code );
EXTERN sds_handle sds_bad_object(sds_handle ,sds_code );
EXTERN sds_handle sds_get_checked(sds_handle ,char *,sds_code );

EXTERN sds_handle sds_tstamp(sds_handle, sds_code);
EXTERN long      *sds_get_tstamp(sds_handle, sds_code);

EXTERN float      sds_version(sds_handle );

EXTERN sds_handle sds_duplicate(sds_handle, char *);
EXTERN sds_handle sds_duplicate_def(sds_handle, sds_handle, sds_code);

EXTERN void       sds_init();
EXTERN void       sds_reinit_enable();

EXTERN int        sds_describe(sds_handle, sds_code, struct sds_odesc **);
EXTERN int        sds_resolve(sds_handle, sds_code,
																				 struct sds_odesc **, sds_code);
EXTERN int        sds_peek_endstruct();
EXTERN sds_handle sds_find_thing(sds_handle, char *,struct sds_odesc **);
EXTERN void       sds_cleanup();
EXTERN int        sds_make_name(char *, struct sds_odesc *, int, int);

EXTERN sds_handle is_sds(char *);

EXTERN char      *sds_oname(sds_handle,sds_code,sds_code);

EXTERN sds_handle sds_define_object(sds_handle,struct type_list *,char *);
EXTERN sds_handle sds_object_size(sds_handle,sds_code,unsigned char *);
EXTERN sds_handle sds_sizeof_object(sds_handle,sds_code);
EXTERN sds_handle sds_set_object_type(sds_handle, sds_handle,int);
EXTERN sds_handle sds_get_object_type(sds_handle,sds_handle);
EXTERN sds_handle sds_get_object_location(sds_handle,sds_handle, int);


EXTERN int        shm_q(char *);
EXTERN int        shm_destroy(char *);
EXTERN int        shm_quit(struct direc *);
EXTERN int        shm_sz(char *);

EXTERN sds_handle bad_sds_header(struct sds_header *);

EXTERN sds_handle sds_flat_setup(sds_handle,
																				sds_code, int, sds_code *, void *);
EXTERN sds_handle sds_flat_read(sds_handle, sds_code, unsigned long);

EXTERN sds_handle sds_twod_declare(sds_handle, void *, char *,
                                              long, long, sds_code);
EXTERN sds_handle sds_threed_declare(sds_handle, void *, char *,
                                        long, long, long, sds_code);

EXTERN void           sds_elbow_socket(sds_handle sds);
EXTERN sds_handle     write_sds(int fd, sds_handle sds);
EXTERN int            write_sds2socket(int fd, sds_handle sds);
EXTERN int            read_socket2sds(int fd, int mode);
#else /* It's boring old C */

double      strtod();
#if !defined(psos)
long       strtol();
#endif

EXTERN void           sds_discard();
EXTERN void           sds_destroy();

EXTERN sds_handle     sds_use();
EXTERN sds_handle     sds_map();
EXTERN sds_handle     sds_adaptive_map();
EXTERN sds_handle     sds_na_load();
EXTERN sds_handle     sds_load_fd();
EXTERN sds_handle     sds_cload_direc();
EXTERN sds_handle     sds_load_conv();
EXTERN sds_handle     sds_cload();

EXTERN sds_handle sds_mapfilecheck();
EXTERN char *     sds_searchmapfile();

EXTERN void sds_print_record_def();
EXTERN void sds_destroy_record_def();
EXTERN void sds_record_entry();
EXTERN void sds_end_sub_record();
EXTERN void sds_begin_sub_record();
EXTERN sds_record_handle * sds_begin_record();
EXTERN sds_handle sds_end_and_declare();
EXTERN int sds_copy_records();

EXTERN sds_handle     sds_new_index();
EXTERN sds_handle     sds_assemble();
EXTERN sds_handle     sds_declare_object();

EXTERN void           sds_perror();

EXTERN sds_handle     sds_list();
EXTERN void           sds_printit();

EXTERN sds_handle     sds_dataset_size();

EXTERN void          *sds_obname2ptr();
EXTERN void          *sds_obind2ptr();
EXTERN char          *sds_obind2name();
EXTERN sds_handle     sds_obname2ind();
EXTERN sds_handle     sds_oblike2ind();
EXTERN sds_handle     sds_array_size();
EXTERN sds_handle     sds_bad_object();
EXTERN sds_handle     sds_get_checked();

EXTERN sds_handle     sds_tstamp();
EXTERN long          *sds_get_tstamp();

EXTERN float          sds_version();

EXTERN sds_handle     sds_duplicate();
EXTERN sds_handle     sds_duplicate_def();
EXTERN sds_handle     sds_resize_object();


EXTERN void           sds_init();
EXTERN void           sds_reinit_enable();

EXTERN int            sds_describe();
EXTERN int            sds_resolve();
EXTERN int            sds_peek_endstruct();
EXTERN sds_handle     sds_find_thing();
EXTERN void           sds_cleanup();

EXTERN sds_handle     is_sds();

EXTERN char          *sds_oname();

EXTERN sds_handle     sds_define_object();
EXTERN sds_handle     sds_object_size();
EXTERN sds_handle     sds_sizeof_object();
EXTERN sds_handle     sds_set_object_type();
EXTERN sds_handle     sds_get_object_type();
EXTERN sds_handle     sds_get_object_location();

EXTERN int            shm_q();
EXTERN int            shm_destroy();
EXTERN int            shm_quit();
EXTERN int            shm_sz();

EXTERN sds_handle     bad_sds_header();

EXTERN sds_handle     sds_flat_setup();
EXTERN sds_handle     sds_flat_read();

EXTERN sds_handle     sds_twod_declare();
EXTERN sds_handle     sds_threed_declare();

EXTERN void           sds_elbow_socket();
EXTERN sds_handle     write_sds();
EXTERN int            write_sds2socket();
EXTERN int            read_socket2sds();

#endif
#endif
